/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CoeffConvertAlg;
import edu.jas.application.CoeffRecConvertAlg;
import edu.jas.application.ColoredSystem;
import edu.jas.application.GroebnerSystem;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithComplexRoots;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithRealRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PrimitiveElement;
import edu.jas.application.Residue;
import edu.jas.application.ResidueRing;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealRootsSturm;
import edu.jas.root.RootFactory;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.ListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class PolyUtilApp<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(PolyUtilApp.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<Residue<C>>>> toProductRes(GenPolynomialRing<Product<Residue<C>>> pfac, List<GenPolynomial<GenPolynomial<C>>> L) {
        ArrayList<GenPolynomial<Product<Residue<C>>>> list = new ArrayList<GenPolynomial<Product<Residue<C>>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<GenPolynomial<C>> a : L) {
            GenPolynomial<Product<Residue<C>>> b = PolyUtilApp.toProductRes(pfac, a);
            list.add(b);
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Product<Residue<C>>> toProductRes(GenPolynomialRing<Product<Residue<C>>> pfac, GenPolynomial<GenPolynomial<C>> A) {
        Object P = ((GenPolynomial)pfac.getZERO()).clone();
        if (A == null || A.isZERO()) {
            return P;
        }
        RingFactory rpfac = pfac.coFac;
        ProductRing fac = (ProductRing)rpfac;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> a = y.getValue();
            Product<Residue<C>> p = PolyUtilApp.toProductRes(fac, a);
            if (p == null || p.isZERO()) continue;
            ((GenPolynomial)P).doPutToMap(e, p);
        }
        return P;
    }

    public static <C extends GcdRingElem<C>> Product<Residue<C>> toProductRes(ProductRing<Residue<C>> pfac, GenPolynomial<C> c) {
        TreeMap<Integer, Residue<C>> elem = new TreeMap<Integer, Residue<C>>();
        int i = 0;
        while (i < pfac.length()) {
            RingFactory<Residue<C>> rfac = pfac.getFactory(i);
            ResidueRing fac = (ResidueRing)rfac;
            Residue<C> u = new Residue<C>(fac, c);
            if (u != null && !u.isZERO()) {
                elem.put(i, u);
            }
            ++i;
        }
        return new Product<Residue<C>>(pfac, elem);
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<Residue<C>>>> toProductRes(List<ColoredSystem<C>> CS) {
        List<GenPolynomial<Product<Residue<C>>>> list = new ArrayList<GenPolynomial<Product<Residue<C>>>>();
        if (CS == null || CS.size() == 0) {
            return list;
        }
        GenPolynomialRing pr = null;
        ArrayList rrl = new ArrayList(CS.size());
        for (ColoredSystem<C> cs : CS) {
            Ideal id = cs.condition.zero;
            ResidueRing r = new ResidueRing(id);
            if (!rrl.contains(r)) {
                rrl.add(r);
            }
            if (pr != null || cs.list.size() <= 0) continue;
            pr = cs.list.get((int)0).green.ring;
        }
        ProductRing pfac = new ProductRing(rrl);
        GenPolynomialRing<Product<Residue<C>>> rf = new GenPolynomialRing<Product<Residue<C>>>(pfac, pr.nvar, pr.tord, pr.getVars());
        GroebnerSystem<C> gs = new GroebnerSystem<C>(CS);
        List<GenPolynomial<GenPolynomial<C>>> F2 = gs.getCGB();
        list = PolyUtilApp.toProductRes(rf, F2);
        return list;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Residue<C>>> toResidue(GenPolynomialRing<Residue<C>> pfac, List<GenPolynomial<GenPolynomial<C>>> L) {
        ArrayList<GenPolynomial<Residue<C>>> list = new ArrayList<GenPolynomial<Residue<C>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<GenPolynomial<C>> a : L) {
            GenPolynomial<Residue<C>> b = PolyUtilApp.toResidue(pfac, a);
            if (b == null || b.isZERO()) continue;
            list.add(b);
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Residue<C>> toResidue(GenPolynomialRing<Residue<C>> pfac, GenPolynomial<GenPolynomial<C>> A) {
        Object P = ((GenPolynomial)pfac.getZERO()).clone();
        if (A == null || A.isZERO()) {
            return P;
        }
        RingFactory rpfac = pfac.coFac;
        ResidueRing fac = (ResidueRing)rpfac;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> a = y.getValue();
            Residue<C> p = new Residue<C>(fac, a);
            if (p == null || p.isZERO()) continue;
            ((GenPolynomial)P).doPutToMap(e, p);
        }
        return P;
    }

    public static <C extends GcdRingElem<C>> Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> productSlice(PolynomialList<Product<Residue<C>>> L) {
        RingFactory fpr = L.ring.coFac;
        ProductRing pr = (ProductRing)fpr;
        int s = pr.length();
        TreeMap<Ideal<C>, PolynomialList<GenPolynomial<C>>> map = new TreeMap<Ideal<C>, PolynomialList<GenPolynomial<C>>>();
        List<GenPolynomial<Product<Residue<C>>>> plist = L.list;
        int i = 0;
        while (i < s) {
            RingFactory r = pr.getFactory(i);
            ResidueRing rr = (ResidueRing)r;
            Ideal id = rr.ideal;
            GenPolynomialRing cof = rr.ring;
            GenPolynomialRing<GenPolynomial<C>> pfc = new GenPolynomialRing<GenPolynomial<C>>(cof, L.ring);
            List slist = PolyUtilApp.fromProduct(pfc, plist, i);
            PolynomialList<GenPolynomial<C>> spl = new PolynomialList<GenPolynomial<C>>(pfc, slist);
            PolynomialList d = (PolynomialList)map.get(id);
            if (d != null) {
                throw new RuntimeException("ideal exists twice " + id);
            }
            map.put(id, spl);
            ++i;
        }
        return map;
    }

    public static <C extends GcdRingElem<C>> PolynomialList<GenPolynomial<C>> productSlice(PolynomialList<Product<Residue<C>>> L, int i) {
        RingFactory fpr = L.ring.coFac;
        ProductRing pr = (ProductRing)fpr;
        List<GenPolynomial<Product<Residue<C>>>> plist = L.list;
        RingFactory r = pr.getFactory(i);
        ResidueRing rr = (ResidueRing)r;
        GenPolynomialRing cof = rr.ring;
        GenPolynomialRing<GenPolynomial<C>> pfc = new GenPolynomialRing<GenPolynomial<C>>(cof, L.ring);
        List slist = PolyUtilApp.fromProduct(pfc, plist, i);
        PolynomialList<GenPolynomial<C>> spl = new PolynomialList<GenPolynomial<C>>(pfc, slist);
        return spl;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<GenPolynomial<C>>> fromProduct(GenPolynomialRing<GenPolynomial<C>> pfac, List<GenPolynomial<Product<Residue<C>>>> L, int i) {
        ArrayList<GenPolynomial<GenPolynomial<C>>> list = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<Product<Residue<C>>> a : L) {
            AbelianGroupElem<GenPolynomial<C>> b = PolyUtilApp.fromProduct(pfac, a, i);
            if (b == null || b.isZERO() || list.contains(b = b.abs())) continue;
            list.add((GenPolynomial<GenPolynomial<C>>)b);
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> fromProduct(GenPolynomialRing<GenPolynomial<C>> pfac, GenPolynomial<Product<Residue<C>>> P, int i) {
        Object b = ((GenPolynomial)pfac.getZERO()).clone();
        if (P == null || P.isZERO()) {
            return b;
        }
        for (Map.Entry<ExpVector, Product<Residue<C>>> y : P.getMap().entrySet()) {
            GenPolynomial p;
            ExpVector e = y.getKey();
            Product<Residue<C>> a = y.getValue();
            Residue<C> r = a.get(i);
            if (r == null || r.isZERO() || (p = r.val) == null || p.isZERO()) continue;
            ((GenPolynomial)b).doPutToMap(e, p);
        }
        return b;
    }

    public static <C extends GcdRingElem<C>> String productSliceToString(Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> L) {
        TreeSet sl = new TreeSet();
        PolynomialList<GenPolynomial<C>> pl = null;
        StringBuffer sb = new StringBuffer();
        for (Ideal<C> id : L.keySet()) {
            sb.append("\n\ncondition == 0:\n");
            sb.append(id.list.toScript());
            pl = L.get(id);
            sl.addAll(pl.list);
            sb.append("\ncorresponding ideal:\n");
            sb.append(pl.toScript());
        }
        return sb.toString();
    }

    public static <C extends GcdRingElem<C>> String productToString(PolynomialList<Product<Residue<C>>> L) {
        Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> M = PolyUtilApp.productSlice(L);
        String s = PolyUtilApp.productSliceToString(M);
        return s;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<List<Complex<BigDecimal>>> complexRootTuples(Ideal<D> I2, C eps) {
        List<GenPolynomial<D>> univs = I2.constructUnivariate();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("univs = " + univs));
        }
        return PolyUtilApp.complexRoots(I2, univs, eps);
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<List<Complex<BigDecimal>>> complexRoots(Ideal<D> I2, List<GenPolynomial<D>> univs, C eps) {
        ArrayList<List<Complex<BigDecimal>>> croots = new ArrayList();
        RingFactory cf = I2.list.ring.coFac;
        ComplexRing cr = new ComplexRing(cf);
        ComplexRootsSturm<C> cra = new ComplexRootsSturm<C>(cr);
        ArrayList cunivs = new ArrayList();
        for (GenPolynomial<D> p : univs) {
            GenPolynomialRing pfac = new GenPolynomialRing(cr, p.ring);
            GenPolynomial cp = PolyUtil.toComplex(pfac, p);
            cunivs.add(cp);
        }
        int i = 0;
        while (i < I2.list.ring.nvar) {
            List<Complex<BigDecimal>> cri = cra.approximateRoots((GenPolynomial)cunivs.get(i), eps);
            croots.add(cri);
            ++i;
        }
        croots = ListUtil.tupleFromList(croots);
        return croots;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<List<Complex<BigDecimal>>> complexRootTuples(List<IdealWithUniv<D>> Il, C eps) {
        ArrayList<List<Complex<BigDecimal>>> croots = new ArrayList<List<Complex<BigDecimal>>>();
        for (IdealWithUniv<D> I2 : Il) {
            List<List<Complex<BigDecimal>>> cr = PolyUtilApp.complexRoots(I2.ideal, I2.upolys, eps);
            croots.addAll(cr);
        }
        return croots;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<IdealWithComplexRoots<D>> complexRoots(List<IdealWithUniv<D>> Il, C eps) {
        ArrayList<IdealWithComplexRoots<D>> Ic = new ArrayList<IdealWithComplexRoots<D>>(Il.size());
        for (IdealWithUniv<D> I2 : Il) {
            List<List<Complex<BigDecimal>>> cr = PolyUtilApp.complexRoots(I2.ideal, I2.upolys, eps);
            IdealWithComplexRoots<D> ic = new IdealWithComplexRoots<D>(I2, cr);
            Ic.add(ic);
        }
        return Ic;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<IdealWithComplexRoots<D>> complexRoots(Ideal<D> G, C eps) {
        List<IdealWithUniv<D>> Il = G.zeroDimDecomposition();
        return PolyUtilApp.complexRoots(Il, eps);
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<List<BigDecimal>> realRootTuples(Ideal<D> I2, C eps) {
        List<GenPolynomial<D>> univs = I2.constructUnivariate();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("univs = " + univs));
        }
        return PolyUtilApp.realRoots(I2, univs, eps);
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<List<BigDecimal>> realRoots(Ideal<D> I2, List<GenPolynomial<D>> univs, C eps) {
        ArrayList<List<BigDecimal>> roots = new ArrayList();
        RingFactory cf = I2.list.ring.coFac;
        RealRootsSturm<D> rra = new RealRootsSturm<D>();
        int i = 0;
        while (i < I2.list.ring.nvar) {
            List<BigDecimal> rri = rra.approximateRoots(univs.get(i), eps);
            roots.add(rri);
            ++i;
        }
        roots = ListUtil.tupleFromList(roots);
        return roots;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<List<BigDecimal>> realRootTuples(List<IdealWithUniv<D>> Il, C eps) {
        ArrayList<List<BigDecimal>> rroots = new ArrayList<List<BigDecimal>>();
        for (IdealWithUniv<D> I2 : Il) {
            List<List<BigDecimal>> rr = PolyUtilApp.realRoots(I2.ideal, I2.upolys, eps);
            rroots.addAll(rr);
        }
        return rroots;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<IdealWithRealRoots<D>> realRoots(List<IdealWithUniv<D>> Il, C eps) {
        ArrayList<IdealWithRealRoots<D>> Ir = new ArrayList<IdealWithRealRoots<D>>(Il.size());
        for (IdealWithUniv<D> I2 : Il) {
            List<List<BigDecimal>> rr = PolyUtilApp.realRoots(I2.ideal, I2.upolys, eps);
            IdealWithRealRoots<D> ir = new IdealWithRealRoots<D>(I2, rr);
            Ir.add(ir);
        }
        return Ir;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D>> List<IdealWithRealRoots<D>> realRoots(Ideal<D> G, C eps) {
        List<IdealWithUniv<D>> Il = G.zeroDimDecomposition();
        return PolyUtilApp.realRoots(Il, eps);
    }

    public static boolean isRealRoots(List<GenPolynomial<BigDecimal>> L, List<List<BigDecimal>> roots, BigDecimal eps) {
        if (L == null || L.size() == 0) {
            return true;
        }
        BigDecimal dc = BigDecimal.ONE;
        GenPolynomialRing dfac = L.get((int)0).ring;
        for (GenPolynomial<BigDecimal> dp : L) {
            for (List<BigDecimal> r : roots) {
                BigDecimal ev = PolyUtil.evaluateAll(dc, dfac, dp, r);
                if (ev.abs().compareTo(eps) <= 0) continue;
                System.out.println("ev = " + ev);
                return false;
            }
        }
        return true;
    }

    public static boolean isComplexRoots(List<GenPolynomial<Complex<BigDecimal>>> L, List<List<Complex<BigDecimal>>> roots, BigDecimal eps) {
        if (L == null || L.size() == 0) {
            return true;
        }
        BigDecimal dc = BigDecimal.ONE;
        ComplexRing<BigDecimal> dcc = new ComplexRing<BigDecimal>(dc);
        GenPolynomialRing dfac = L.get((int)0).ring;
        for (GenPolynomial<Complex<BigDecimal>> dp : L) {
            for (List<Complex<BigDecimal>> r : roots) {
                Complex<BigDecimal> ev = PolyUtil.evaluateAll(dcc, dfac, dp, r);
                if (((BigDecimal)((Complex)ev.norm()).getRe()).compareTo(eps) <= 0) continue;
                System.out.println("ev = " + ev);
                return false;
            }
        }
        return true;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D> & Rational> IdealWithRealAlgebraicRoots<C, D> realAlgebraicRoots(IdealWithUniv<D> I2) {
        int[] dep0;
        ArrayList<List<RealAlgebraicNumber<Object>>> ran = new ArrayList();
        if (I2 == null || I2.ideal == null || I2.ideal.isZERO() || I2.upolys == null || I2.upolys.size() == 0) {
            return new IdealWithRealAlgebraicRoots(I2, ran);
        }
        GenPolynomialRing fac = I2.ideal.list.ring;
        GenPolynomial p0 = I2.upolys.get(0);
        GenPolynomial p0p = PolyUtilApp.selectWithVariable(I2.ideal.list.list, fac.nvar - 1);
        if (p0p == null) {
            throw new RuntimeException("no polynomial found in " + (fac.nvar - 1) + " of  " + I2.ideal);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("p0p = " + p0p));
        }
        if ((dep0 = p0p.degreeVector().dependencyOnVariables()).length != 1) {
            throw new RuntimeException("wrong number of variables " + Arrays.toString(dep0));
        }
        List rra = RootFactory.realAlgebraicNumbersIrred(p0);
        for (RealAlgebraicNumber rr : rra) {
            ArrayList rl = new ArrayList();
            rl.add(rr);
            ran.add(rl);
        }
        int i = 1;
        while (i < I2.upolys.size()) {
            int[] depi;
            ArrayList rn = new ArrayList();
            GenPolynomial pi = I2.upolys.get(i);
            GenPolynomial pip = PolyUtilApp.selectWithVariable(I2.ideal.list.list, fac.nvar - 1 - i);
            if (pip == null) {
                throw new RuntimeException("no polynomial found in " + (fac.nvar - 1 - i) + " of  " + I2.ideal);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("pip = " + pip));
            }
            if ((depi = pip.degreeVector().dependencyOnVariables()).length < 1 || depi.length > 2) {
                throw new RuntimeException("wrong number of variables " + Arrays.toString(depi));
            }
            rra = RootFactory.realAlgebraicNumbersIrred(pi);
            if (depi.length == 1) {
                for (RealAlgebraicNumber rr : rra) {
                    for (List list : ran) {
                        ArrayList ry = new ArrayList();
                        ry.addAll(list);
                        ry.add(rr);
                        rn.add(ry);
                    }
                }
            } else {
                GenPolynomial pip2 = PolyUtilApp.removeUnusedUpperVariables(pip);
                GenPolynomialRing ufac = pip2.ring.contract(1);
                GenPolynomialRing genPolynomialRing = new GenPolynomialRing(ufac, 1);
                GenPolynomial pip2r = PolyUtil.recursive(genPolynomialRing, pip2);
                int ix = fac.nvar - 1 - depi[depi.length - 1];
                for (RealAlgebraicNumber rr : rra) {
                    GenPolynomial<GcdRingElem> pip2el = PolyUtil.evaluateMain(ufac, pip2r, (GcdRingElem)rr.ring.getRoot().left);
                    GenPolynomial<GcdRingElem> pip2er = PolyUtil.evaluateMain(ufac, pip2r, (GcdRingElem)rr.ring.getRoot().right);
                    GenPolynomialRing upfac = I2.upolys.get((int)ix).ring;
                    GenPolynomial<GcdRingElem> pip2elc = PolyUtilApp.convert(upfac, pip2el);
                    GenPolynomial<GcdRingElem> pip2erc = PolyUtilApp.convert(upfac, pip2er);
                    for (List list : ran) {
                        int sr;
                        RealAlgebraicRing rar = ((RealAlgebraicNumber)list.get((int)ix)).ring;
                        RealAlgebraicNumber<GcdRingElem> rel = new RealAlgebraicNumber<GcdRingElem>(rar, pip2elc);
                        RealAlgebraicNumber<GcdRingElem> rer = new RealAlgebraicNumber<GcdRingElem>(rar, pip2erc);
                        int sl = rel.signum();
                        if (sl * (sr = rer.signum()) > 0) continue;
                        ArrayList ry = new ArrayList();
                        ry.addAll(list);
                        ry.add(rr);
                        rn.add(ry);
                    }
                }
            }
            ran = rn;
            ++i;
        }
        IdealWithRealAlgebraicRoots Ir = new IdealWithRealAlgebraicRoots(I2, ran);
        return Ir;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D> & Rational> List<IdealWithRealAlgebraicRoots<C, D>> realAlgebraicRoots(List<IdealWithUniv<D>> I2) {
        ArrayList<IdealWithRealAlgebraicRoots<C, D>> lir = new ArrayList<IdealWithRealAlgebraicRoots<C, D>>(I2.size());
        for (IdealWithUniv<D> iu : I2) {
            IdealWithRealAlgebraicRoots<C, D> iur = PolyUtilApp.realAlgebraicRoots(iu);
            lir.add(iur);
        }
        return lir;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> selectWithVariable(List<GenPolynomial<C>> P, int i) {
        for (GenPolynomial<C> p : P) {
            int[] dep = p.leadingExpVector().dependencyOnVariables();
            if (dep.length != 1 || dep[0] != i) continue;
            return p;
        }
        return null;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> removeUnusedUpperVariables(GenPolynomial<C> p) {
        int[] dep = p.degreeVector().dependencyOnVariables();
        GenPolynomialRing fac = p.ring;
        if (fac.nvar == dep.length) {
            return p;
        }
        int l = dep[0];
        int r = dep[dep.length - 1];
        int n = l;
        GenPolynomialRing facr = fac.contract(n);
        Map<ExpVector, GenPolynomial<C>> mpr = p.contract(facr);
        if (mpr.size() != 1) {
            throw new RuntimeException("this should not happen " + mpr);
        }
        GenPolynomial<C> pr = mpr.values().iterator().next();
        n = fac.nvar - 1 - r;
        if (n == 0) {
            return pr;
        }
        return pr;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> convert(GenPolynomialRing<C> fac, GenPolynomial<C> p) {
        Element q = fac.parse(p.toString());
        return q;
    }

    public static <C extends RingElem<C> & Rational, D extends GcdRingElem<D> & Rational> List<IdealWithRealAlgebraicRoots<C, D>> realAlgebraicRoots(Ideal<D> I2) {
        List<IdealWithUniv<D>> Ir = I2.zeroDimRootDecomposition();
        List<IdealWithRealAlgebraicRoots<C, D>> roots = PolyUtilApp.realAlgebraicRoots(Ir);
        return roots;
    }

    public static <C extends GcdRingElem<C>> PrimitiveElement<C> primitiveElement(AlgebraicNumberRing<C> a, AlgebraicNumberRing<C> b) {
        GenPolynomial ap = a.modul;
        GenPolynomial bp = b.modul;
        String[] cv = new String[]{ap.ring.getVars()[0], bp.ring.getVars()[0]};
        TermOrder to = new TermOrder(2);
        GenPolynomialRing cfac = new GenPolynomialRing(ap.ring.coFac, 2, to, cv);
        AbelianGroupElem as = ap.extendUnivariate(cfac, 0);
        AbelianGroupElem bs = bp.extendUnivariate(cfac, 1);
        ArrayList L = new ArrayList(2);
        L.add(as);
        L.add(bs);
        ArrayList Op = new ArrayList();
        Ideal id = new Ideal(cfac, L);
        IdealWithUniv iu = id.normalPositionFor(0, 1, Op);
        List Np = iu.ideal.getList();
        as = Np.get(1);
        bs = Np.get(0);
        GenPolynomial cs = Np.get(2);
        String[] ev = new String[]{cs.ring.getVars()[0]};
        GenPolynomialRing efac = new GenPolynomialRing(ap.ring.coFac, 1, to, ev);
        cs = cs.contractCoeff(efac);
        as = as.reductum().contractCoeff(efac);
        as = as.negate();
        bs = bs.reductum().contractCoeff(efac);
        bs = bs.negate();
        AlgebraicNumberRing c = new AlgebraicNumberRing(cs);
        AlgebraicNumber ab = new AlgebraicNumber(c, as);
        AlgebraicNumber bb = new AlgebraicNumber(c, bs);
        PrimitiveElement pe = new PrimitiveElement(c, ab, bb, a, b);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("primitive element = " + c));
        }
        return pe;
    }

    public static <C extends GcdRingElem<C>> AlgebraicNumber<C> convertToPrimitiveElem(AlgebraicNumberRing<C> cfac, AlgebraicNumber<C> A, AlgebraicNumber<C> a) {
        GenPolynomialRing aufac = a.ring.ring;
        GenPolynomialRing ar = new GenPolynomialRing(cfac, aufac);
        GenPolynomial aps = PolyUtil.convertToAlgebraicCoefficients(ar, a.val);
        AlgebraicNumber<C> ac = PolyUtil.evaluateMain(cfac, aps, A);
        return ac;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToPrimitiveElem(AlgebraicNumberRing<C> cfac, AlgebraicNumber<C> A, GenPolynomial<AlgebraicNumber<C>> a) {
        GenPolynomialRing<C> cr = new GenPolynomialRing<C>(cfac, a.ring);
        return PolyUtil.map(cr, a, new CoeffConvertAlg<C>(cfac, A));
    }

    public static <C extends GcdRingElem<C>> AlgebraicNumber<C> convertToPrimitiveElem(AlgebraicNumberRing<C> cfac, AlgebraicNumber<C> A, AlgebraicNumber<C> B, AlgebraicNumber<AlgebraicNumber<C>> a) {
        GenPolynomial<AlgebraicNumber<C>> aps = PolyUtilApp.convertToPrimitiveElem(cfac, A, a.val);
        AlgebraicNumber<C> ac = PolyUtil.evaluateMain(cfac, aps, B);
        return ac;
    }

    public static <C extends GcdRingElem<C>> PrimitiveElement<C> primitiveElement(AlgebraicNumberRing<AlgebraicNumber<C>> b) {
        GenPolynomial bp = b.modul;
        AlgebraicNumberRing a = (AlgebraicNumberRing)b.ring.coFac;
        GenPolynomial ap = a.modul;
        String[] cv = new String[]{ap.ring.getVars()[0], bp.ring.getVars()[0]};
        TermOrder to = new TermOrder(2);
        GenPolynomialRing cfac = new GenPolynomialRing(ap.ring.coFac, 2, to, cv);
        GenPolynomialRing rfac = new GenPolynomialRing(a.ring, 1, bp.ring.getVars());
        AbelianGroupElem as = ap.extendUnivariate(cfac, 0);
        GenPolynomial bss = PolyUtil.fromAlgebraicCoefficients(rfac, bp);
        AbelianGroupElem bs = PolyUtil.distribute(cfac, bss);
        ArrayList L = new ArrayList(2);
        L.add(as);
        L.add(bs);
        ArrayList Op = new ArrayList();
        Ideal id = new Ideal(cfac, L);
        IdealWithUniv iu = id.normalPositionFor(0, 1, Op);
        List Np = iu.ideal.getList();
        as = Np.get(1);
        bs = Np.get(0);
        GenPolynomial cs = Np.get(2);
        String[] ev = new String[]{cs.ring.getVars()[0]};
        GenPolynomialRing efac = new GenPolynomialRing(ap.ring.coFac, 1, to, ev);
        cs = cs.contractCoeff(efac);
        as = as.reductum().contractCoeff(efac);
        as = as.negate();
        bs = bs.reductum().contractCoeff(efac);
        bs = bs.negate();
        AlgebraicNumberRing c = new AlgebraicNumberRing(cs);
        AlgebraicNumber ab = new AlgebraicNumber(c, as);
        AlgebraicNumber bb = new AlgebraicNumber(c, bs);
        PrimitiveElement pe = new PrimitiveElement(c, ab, bb);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("primitive element = " + pe));
        }
        return pe;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToPrimitiveElem(AlgebraicNumberRing<C> cfac, AlgebraicNumber<C> A, AlgebraicNumber<C> B, GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> a) {
        GenPolynomialRing<C> cr = new GenPolynomialRing<C>(cfac, a.ring);
        return PolyUtil.map(cr, a, new CoeffRecConvertAlg<C>(cfac, A, B));
    }
}

