/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.PolyUtilApp;
import edu.jas.application.PrimitiveElement;
import edu.jas.arith.BigRational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class PolyUtilAppTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigRational> dfac;
    GenPolynomialRing<BigRational> cfac;
    GenPolynomialRing<GenPolynomial<BigRational>> rfac;
    BigRational ai;
    BigRational bi;
    BigRational ci;
    BigRational di;
    BigRational ei;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    GenPolynomial<GenPolynomial<BigRational>> ar;
    GenPolynomial<GenPolynomial<BigRational>> br;
    GenPolynomial<GenPolynomial<BigRational>> cr;
    GenPolynomial<GenPolynomial<BigRational>> dr;
    GenPolynomial<GenPolynomial<BigRational>> er;
    int rl = 5;
    int kl = 5;
    int ll = 5;
    int el = 5;
    float q = 0.6f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)PolyUtilAppTest.suite());
    }

    public PolyUtilAppTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(PolyUtilAppTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to);
        this.cfac = null;
        this.rfac = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testPrimitiveElement() {
        String[] va = new String[]{"alpha"};
        String[] vb = new String[]{"beta"};
        GenPolynomialRing<BigRational> aufac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1, va);
        GenPolynomial<BigRational> m = aufac.univariate(0, 3L);
        m = m.subtract((BigRational)aufac.fromInteger(2L));
        GenPolynomialRing<BigRational> bufac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1, vb);
        GenPolynomial<BigRational> n = bufac.univariate(0, 2L);
        n = n.subtract((BigRational)bufac.fromInteger(3L));
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(m);
        AlgebraicNumberRing<BigRational> bfac = new AlgebraicNumberRing<BigRational>(n);
        PrimitiveElement<BigRational> pe = PolyUtilApp.primitiveElement(afac, bfac);
        AlgebraicNumberRing cfac = pe.primitiveElem;
        AlgebraicNumber<BigRational> a = afac.getGenerator();
        AlgebraicNumber<BigRational> b = bfac.getGenerator();
        AlgebraicNumber<BigRational> as = PolyUtilApp.convertToPrimitiveElem(cfac, pe.A, a);
        AlgebraicNumber<BigRational> bs = PolyUtilApp.convertToPrimitiveElem(cfac, pe.B, b);
        AlgebraicNumber<AlgebraicNumber<BigRational>> cs = as.sum((BigRational)((Object)bs));
        PolyUtilAppTest.assertEquals((String)"alpha+beta == gamma", cs, cfac.getGenerator());
    }

    public void testPrimitiveElementTower() {
        String[] va = new String[]{"alpha"};
        String[] vb = new String[]{"beta"};
        GenPolynomialRing<BigRational> ufac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1, va);
        GenPolynomial<BigRational> m = ufac.univariate(0, 3L);
        m = m.subtract((BigRational)ufac.fromInteger(2L));
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(m);
        GenPolynomialRing<BigRational> aufac = new GenPolynomialRing<BigRational>(afac, 1, vb);
        GenPolynomial<RingElem<BigRational>> n = aufac.univariate(0, 2L);
        n = n.subtract((BigRational)((Object)((GenPolynomial)aufac.getONE()).multiply(afac.getGenerator())));
        AlgebraicNumberRing<BigRational> bfac = new AlgebraicNumberRing<BigRational>(n);
        PrimitiveElement pe = PolyUtilApp.primitiveElement(bfac);
        AlgebraicNumberRing cfac = pe.primitiveElem;
        AlgebraicNumber<BigRational> a = afac.getGenerator();
        AlgebraicNumber<BigRational> b = bfac.getGenerator();
        AlgebraicNumber<BigRational> as = PolyUtilApp.convertToPrimitiveElem(cfac, pe.A, a);
        AlgebraicNumber bs = PolyUtilApp.convertToPrimitiveElem(cfac, pe.A, pe.B, b);
        AlgebraicNumber cs = as.sum((BigRational)((Object)bs));
        PolyUtilAppTest.assertEquals((String)"alpha+beta == gamma", cs, cfac.getGenerator());
        String[] vx = new String[]{"x"};
        GenPolynomialRing<BigRational> rafac = new GenPolynomialRing<BigRational>(afac, 1, vx);
        GenPolynomialRing<BigRational> rbfac = new GenPolynomialRing<BigRational>(bfac, 1, vx);
        GenPolynomial ap = rafac.getGenerators().get(0).multiply((BigRational)((Object)a));
        GenPolynomial bp = rbfac.getGenerators().get(0).multiply((BigRational)((Object)b));
        GenPolynomial asp = PolyUtilApp.convertToPrimitiveElem(cfac, pe.A, ap);
        GenPolynomial bsp = PolyUtilApp.convertToPrimitiveElem(cfac, pe.A, pe.B, bp);
        GenPolynomial csp = asp.sum(bsp);
        PolyUtilAppTest.assertEquals((String)"alpha+beta == gamma", csp.leadingBaseCoefficient(), cfac.getGenerator());
    }
}

