/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CReductionSeq;
import edu.jas.application.ColorPolynomial;
import edu.jas.application.ColoredSystem;
import edu.jas.application.Condition;
import edu.jas.application.Ideal;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.AbelianGroupElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ReductionTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    int rl = 2;
    int kl = 2;
    int ll = 3;
    int el = 3;
    float q = 0.4f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ReductionTest.suite());
        ComputerThreads.terminate();
    }

    public ReductionTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ReductionTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(0L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testRatPolReduction() {
        BigRational bi = new BigRational(0L);
        GenPolynomialRing<BigRational> pr = new GenPolynomialRing<BigRational>(bi, 2, new String[]{"a", "b"});
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(pr, this.rl);
        CReductionSeq<BigRational> cred = new CReductionSeq<BigRational>(bi);
        GenPolynomial<BigRational> a = fac.random(this.kl, this.ll, this.el, this.q);
        while (a.isZERO()) {
            a = fac.random(this.kl, this.ll, this.el, this.q).sum((BigRational)fac.getONE());
        }
        GenPolynomial<BigRational> b = fac.random(this.kl, this.ll, this.el, this.q);
        while (b.isZERO()) {
            b = fac.random(this.kl, this.ll, this.el, this.q).subtract((BigRational)fac.getONE());
        }
        AbelianGroupElem g = fac.getZERO();
        Map.Entry<ExpVector, BigRational> m = a.leadingMonomial();
        ExpVector e = m.getKey();
        GenPolynomial c = (GenPolynomial)((Object)m.getValue());
        GenPolynomial r = fac.getZERO();
        if ((r = r.sum(c, e)).isZERO()) {
            r = fac.getONE();
        }
        GenPolynomial<BigRational> w = a.reductum();
        ColorPolynomial p = new ColorPolynomial(g, r, w);
        ReductionTest.assertTrue((String)"check(p) ", (boolean)p.checkInvariant());
        ReductionTest.assertTrue((String)"deter(p) ", (boolean)p.isDetermined());
        p = new ColorPolynomial(r, g, w);
        ReductionTest.assertTrue((String)"check(p) ", (boolean)p.checkInvariant());
        if (!w.isZERO()) {
            ReductionTest.assertFalse((String)"deter(p) ", (boolean)p.isDetermined());
        }
        p = new ColorPolynomial(r, w, g);
        ReductionTest.assertTrue((String)"check(p) ", (boolean)p.checkInvariant());
        ReductionTest.assertTrue((String)"deter(p) ", (boolean)p.isDetermined());
        p = new ColorPolynomial(w, g, g);
        ReductionTest.assertTrue((String)"check(p) ", (boolean)p.checkInvariant());
        ReductionTest.assertTrue((String)"deter(p) ", (boolean)p.isDetermined());
        ReductionTest.assertTrue((String)"p == 0 ", (boolean)p.isZERO());
        ArrayList i = new ArrayList();
        Ideal<BigRational> id = new Ideal<BigRational>(pr, i);
        ArrayList cp = new ArrayList();
        Condition<BigRational> cond = new Condition<BigRational>(id);
        ColoredSystem<BigRational> s = new ColoredSystem<BigRational>(cond, cp);
        ReductionTest.assertTrue((String)"isDetermined ", (boolean)s.isDetermined());
        ReductionTest.assertTrue((String)"checkInvariant ", (boolean)s.checkInvariant());
        ArrayList<ColoredSystem<BigRational>> CS = new ArrayList<ColoredSystem<BigRational>>();
        CS.add(s);
        List<Object> CSp = CS;
        for (ColoredSystem coloredSystem : CS) {
            ReductionTest.assertTrue((String)"isDetermined ", (boolean)coloredSystem.isDetermined());
            ReductionTest.assertTrue((String)"checkInvariant ", (boolean)coloredSystem.checkInvariant());
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(a);
        arrayList.add(b);
        List<Condition<BigRational>> Ccond = cred.caseDistinction(arrayList);
        CSp = cred.determine(arrayList);
        for (ColoredSystem coloredSystem : CSp) {
            ReductionTest.assertTrue((String)"isDetermined ", (boolean)coloredSystem.isDetermined());
            ReductionTest.assertTrue((String)"checkInvariant ", (boolean)coloredSystem.checkInvariant());
        }
        for (ColoredSystem coloredSystem : CSp) {
            int k = coloredSystem.list.size();
            int j = 0;
            while (j < k) {
                p = coloredSystem.list.get(j);
                int l = j + 1;
                while (l < k) {
                    ColorPolynomial colorPolynomial = coloredSystem.list.get(l);
                    ColorPolynomial<BigRational> h = cred.SPolynomial(p, colorPolynomial);
                    boolean t = true;
                    h = cred.normalform(coloredSystem.condition, coloredSystem.list, h);
                    t = cred.isNormalform(coloredSystem.list, h);
                    ReductionTest.assertTrue((String)"isNF(NF(spol(a,b))) ", (boolean)t);
                    ++l;
                }
                ++j;
            }
        }
    }
}

