/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.Residue;
import edu.jas.application.ResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ResidueTest
extends TestCase {
    Ideal<BigRational> id;
    ResidueRing<BigRational> fac;
    GenPolynomialRing<BigRational> mfac;
    List<GenPolynomial<BigRational>> F;
    Residue<BigRational> a;
    Residue<BigRational> b;
    Residue<BigRational> c;
    Residue<BigRational> d;
    Residue<BigRational> e;
    int rl = 3;
    int kl = 3;
    int ll = 7;
    int el = 3;
    float q = 0.4f;
    int il = this.rl == 1 ? 1 : 2;

    public static void main(String[] args) {
        TestRunner.run((Test)ResidueTest.suite());
    }

    public ResidueTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ResidueTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.mfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl);
        this.F = new ArrayList<GenPolynomial<BigRational>>(this.il);
        int i = 0;
        while (i < this.il) {
            GenPolynomial<BigRational> mo = this.mfac.random(this.kl, this.ll, this.el, this.q);
            while (mo.isConstant()) {
                mo = this.mfac.random(this.kl, this.ll, this.el, this.q);
            }
            this.F.add(mo);
            ++i;
        }
        this.id = new Ideal<BigRational>(this.mfac, this.F);
        this.fac = new ResidueRing<BigRational>(this.id);
        this.F = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.id = null;
        this.mfac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        ResidueTest.assertTrue((String)"length( c ) = 1", (this.c.val.length() == 1 ? 1 : 0) != 0);
        ResidueTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ResidueTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ResidueTest.assertTrue((String)"length( d ) = 0", (this.d.val.length() == 0 ? 1 : 0) != 0);
        ResidueTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ResidueTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            if (!this.a.isZERO() && !this.a.isONE()) {
                ResidueTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.val.length() >= 0 ? 1 : 0) != 0);
                ResidueTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                ResidueTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        ResidueTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        ResidueTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        ResidueTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Residue<BigRational>)this.fac.getZERO());
        this.d = this.a.subtract((Residue<BigRational>)this.fac.getZERO());
        ResidueTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Residue)this.fac.getZERO()).sum(this.a);
        this.d = ((Residue)this.fac.getZERO()).subtract(this.a.negate());
        ResidueTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO()) {
            return;
        }
        ResidueTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.a = this.a.monic();
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (this.b.isZERO()) {
            return;
        }
        ResidueTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.b = this.b.monic();
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ResidueTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ResidueTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        ResidueTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ResidueTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ResidueTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.d = this.c.remainder(this.a);
        if (this.d.isZERO()) {
            this.d = this.c.divide(this.a);
            this.e = this.d.multiply(this.a);
            ResidueTest.assertEquals((String)"((b*a)/a)*a = b*a", this.e, this.c);
        }
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        ResidueTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ResidueTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((Residue<BigRational>)this.fac.getONE());
        this.d = ((Residue)this.fac.getONE()).multiply(this.a);
        ResidueTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply(this.a);
            ResidueTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }
}

