/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigRational;
import edu.jas.arith.Combinatoric;
import edu.jas.arith.Roots;
import edu.jas.structure.Power;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArithTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ArithTest.suite());
    }

    public ArithTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ArithTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testIntegerConstants() {
        BigInteger a = BigInteger.ZERO;
        BigInteger b = BigInteger.ONE;
        BigInteger c = b.subtract(b);
        ArithTest.assertTrue((String)"0.isZERO()", (boolean)a.isZERO());
        ArithTest.assertTrue((String)"1.isONE", (boolean)b.isONE());
        ArithTest.assertEquals((String)"1-1 = 0", (Object)c, (Object)a);
        ArithTest.assertTrue((String)"(1-1).isZERO()", (boolean)c.isZERO());
        BigInteger d = b.multiply(b);
        ArithTest.assertTrue((String)"1*1 = 1", (boolean)d.isONE());
        d = b.multiply(a);
        ArithTest.assertTrue((String)"1*0 = 0", (boolean)d.isZERO());
    }

    public void testIntegerConstructor() {
        BigInteger a = new BigInteger(1L);
        BigInteger b = new BigInteger(-1L);
        BigInteger c = new BigInteger(0L);
        BigInteger d = a.sum(b);
        ArithTest.assertTrue((String)"'1'.isONE()", (boolean)a.isONE());
        ArithTest.assertTrue((String)"1+(-1) = 0", (boolean)d.isZERO());
        d = a.negate();
        ArithTest.assertEquals((String)"-1 = -(1)", (Object)d, (Object)b);
        d = a.multiply(c);
        ArithTest.assertTrue((String)"'0'.isZERO()", (boolean)d.isZERO());
        d = b.multiply(b);
        ArithTest.assertTrue((String)"(-1)*(-1) = 1", (boolean)d.isONE());
        a = new BigInteger(3L);
        b = new BigInteger("3");
        ArithTest.assertEquals((String)"3 = '3'", (Object)a, (Object)b);
        a = new BigInteger(-5L);
        b = new BigInteger("-5");
        ArithTest.assertEquals((String)"-5 = '-5'", (Object)a, (Object)b);
        String s = "1111111111111111111111111111111111111111111111";
        a = new BigInteger(s);
        String t = a.toString();
        ArithTest.assertEquals((String)"stringConstr = toString", (String)s, (String)t);
    }

    public void testIntegerRandom() {
        BigInteger a = BigInteger.ZERO.random(500);
        BigInteger b = new BigInteger("" + a);
        BigInteger c = b.subtract(a);
        ArithTest.assertTrue((String)"a-'a' = 0", (boolean)c.isZERO());
        ArithTest.assertEquals((String)"compareTo('a',a) = 0", (int)0, (int)b.compareTo(a));
        ArithTest.assertEquals((String)"signum('a'-a) = 0", (int)0, (int)c.signum());
    }

    public void testIntegerAddition() {
        BigInteger a = BigInteger.ZERO.random(500);
        BigInteger d = a.sum(BigInteger.ZERO);
        ArithTest.assertEquals((String)"a+0 = a", (Object)d, (Object)a);
        d = a.subtract(BigInteger.ZERO);
        ArithTest.assertEquals((String)"a-0 = a", (Object)d, (Object)a);
        BigInteger b = a.sum(a);
        BigInteger c = b.subtract(a);
        ArithTest.assertEquals((String)"(a+a)-a = a", (Object)c, (Object)a);
        b = a.subtract(a);
        c = b.sum(a);
        ArithTest.assertEquals((String)"(a-a)+a = a", (Object)c, (Object)a);
        b = BigInteger.ZERO.random(500);
        c = a.sum(b);
        d = b.sum(a);
        ArithTest.assertEquals((String)"a+b = b+a", (Object)c, (Object)d);
        c = a.subtract(b);
        d = a.sum(b.negate());
        ArithTest.assertEquals((String)"a-b = a+(-b)", (Object)c, (Object)d);
        c = BigInteger.ZERO.random(500);
        d = a.sum(b.sum(c));
        BigInteger e = a.sum(b).sum(c);
        ArithTest.assertEquals((String)"a+(b+c) = (a+b)+c", (Object)d, (Object)e);
    }

    public void testIntegerMultiplication() {
        BigInteger a = BigInteger.ZERO.random(500);
        BigInteger d = a.multiply(BigInteger.ONE);
        ArithTest.assertEquals((String)"a*1 = a", (Object)d, (Object)a);
        d = a.divide(BigInteger.ONE);
        ArithTest.assertEquals((String)"a/1 = a", (Object)d, (Object)a);
        BigInteger b = a.multiply(a);
        BigInteger c = b.divide(a);
        ArithTest.assertEquals((String)"(a*a)/a = a", (Object)c, (Object)a);
        b = a.divide(a);
        c = b.multiply(a);
        ArithTest.assertEquals((String)"(a/a)*a = a", (Object)c, (Object)a);
        b = BigInteger.ZERO.random(500);
        c = a.multiply(b);
        d = b.multiply(a);
        ArithTest.assertEquals((String)"a*b = b*a", (Object)c, (Object)d);
        d = c.divide(b);
        BigInteger e = a;
        ArithTest.assertEquals((String)"a/b = a*(1/b)", (Object)d, (Object)e);
        c = BigInteger.ZERO.random(500);
        d = a.multiply(b.multiply(c));
        e = a.multiply(b).multiply(c);
        ArithTest.assertEquals((String)"a*(b*c) = (a*b)*c", (Object)d, (Object)e);
    }

    public void testRationalConstants() {
        BigRational a = BigRational.ZERO;
        BigRational b = BigRational.ONE;
        BigRational c = b.subtract(b);
        ArithTest.assertTrue((String)"0.isZERO()", (boolean)a.isZERO());
        ArithTest.assertTrue((String)"1.isONE", (boolean)b.isONE());
        ArithTest.assertEquals((String)"1-1 = 0", (Object)c, (Object)a);
        ArithTest.assertTrue((String)"(1-1).isZERO()", (boolean)c.isZERO());
        BigRational d = b.multiply(b);
        ArithTest.assertTrue((String)"1*1 = 1", (boolean)d.isONE());
        d = b.multiply(a);
        ArithTest.assertTrue((String)"1*0 = 0", (boolean)d.isZERO());
    }

    public void testComplexConstants() {
        BigComplex a = BigComplex.ZERO;
        BigComplex b = BigComplex.ONE;
        BigComplex c = b.subtract(b);
        ArithTest.assertTrue((String)"0.isZERO()", (boolean)a.isZERO());
        ArithTest.assertTrue((String)"1.isONE", (boolean)b.isONE());
        ArithTest.assertEquals((String)"1-1 = 0", (Object)c, (Object)a);
        ArithTest.assertTrue((String)"(1-1).isZERO()", (boolean)c.isZERO());
        BigComplex d = b.multiply(b);
        ArithTest.assertTrue((String)"1*1 = 1", (boolean)d.isONE());
        d = b.multiply(a);
        ArithTest.assertTrue((String)"1*0 = 0", (boolean)d.isZERO());
    }

    public void testQuaternionConstants() {
        BigQuaternion a = BigQuaternion.ZERO;
        BigQuaternion b = BigQuaternion.ONE;
        BigQuaternion c = b.subtract(b);
        ArithTest.assertTrue((String)"0.isZERO()", (boolean)a.isZERO());
        ArithTest.assertTrue((String)"1.isONE", (boolean)b.isONE());
        ArithTest.assertEquals((String)"1-1 = 0", (Object)c, (Object)a);
        ArithTest.assertTrue((String)"(1-1).isZERO()", (boolean)c.isZERO());
        BigQuaternion d = b.multiply(b);
        ArithTest.assertTrue((String)"1*1 = 1", (boolean)d.isONE());
        d = b.multiply(a);
        ArithTest.assertTrue((String)"1*0 = 0", (boolean)d.isZERO());
    }

    public void testRationalConstructor() {
        BigRational a = new BigRational(1L);
        BigRational b = new BigRational(-1L);
        BigRational c = new BigRational(0L);
        BigRational d = a.sum(b);
        ArithTest.assertTrue((String)"'1'.isONE()", (boolean)a.isONE());
        ArithTest.assertTrue((String)"1+(-1) = 0", (boolean)d.isZERO());
        d = a.negate();
        ArithTest.assertEquals((String)"-1 = -(1)", (Object)d, (Object)b);
        d = a.multiply(c);
        ArithTest.assertTrue((String)"'0'.isZERO()", (boolean)d.isZERO());
        d = b.multiply(b);
        ArithTest.assertTrue((String)"(-1)*(-1) = 1", (boolean)d.isONE());
        a = new BigRational(3L);
        b = new BigRational("3");
        ArithTest.assertEquals((String)"3 = '3'", (Object)a, (Object)b);
        a = new BigRational(-5L);
        b = new BigRational("-5");
        ArithTest.assertEquals((String)"-5 = '-5'", (Object)a, (Object)b);
        String s = "1111111111111111111111111111111111111111111111";
        a = new BigRational(s);
        String t = a.toString();
        ArithTest.assertEquals((String)"stringConstr = toString", (String)s, (String)t);
        s = "2/4";
        a = new BigRational(s);
        t = a.toString(5);
        String r = "0.5";
        ArithTest.assertEquals((String)"stringConstr = toString", (String)r, (String)t);
    }

    public void testComplexConstructor() {
        BigComplex a = new BigComplex(1L);
        BigComplex b = new BigComplex(-1L);
        BigComplex c = new BigComplex(0L);
        BigComplex d = a.sum(b);
        ArithTest.assertTrue((String)"'1'.isONE()", (boolean)a.isONE());
        ArithTest.assertTrue((String)"1+(-1) = 0", (boolean)d.isZERO());
        d = a.negate();
        ArithTest.assertEquals((String)"-1 = -(1)", (Object)d, (Object)b);
        d = a.multiply(c);
        ArithTest.assertTrue((String)"'0'.isZERO()", (boolean)d.isZERO());
        d = b.multiply(b);
        ArithTest.assertTrue((String)"(-1)*(-1) = 1", (boolean)d.isONE());
        a = new BigComplex(3L);
        b = new BigComplex("3");
        ArithTest.assertEquals((String)"3 = '3'", (Object)a, (Object)b);
        a = new BigComplex(-5L);
        b = new BigComplex("-5");
        ArithTest.assertEquals((String)"-5 = '-5'", (Object)a, (Object)b);
        String s = "1111111111111111111111111111111111111111111111";
        a = new BigComplex(s);
        String t = a.toString();
        ArithTest.assertEquals((String)"stringConstr = toString", (String)s, (String)t);
    }

    public void testQuaternionConstructor() {
        BigQuaternion a = new BigQuaternion(1L);
        BigQuaternion b = new BigQuaternion(-1L);
        BigQuaternion c = new BigQuaternion(0L);
        BigQuaternion d = a.sum(b);
        ArithTest.assertTrue((String)"'1'.isONE()", (boolean)a.isONE());
        ArithTest.assertTrue((String)"1+(-1) = 0", (boolean)d.isZERO());
        d = a.negate();
        ArithTest.assertEquals((String)"-1 = -(1)", (Object)d, (Object)b);
        d = a.multiply(c);
        ArithTest.assertTrue((String)"'0'.isZERO()", (boolean)d.isZERO());
        d = b.multiply(b);
        ArithTest.assertTrue((String)"(-1)*(-1) = 1", (boolean)d.isONE());
        a = new BigQuaternion(3L);
        b = new BigQuaternion("3");
        ArithTest.assertEquals((String)"3 = '3'", (Object)a, (Object)b);
        a = new BigQuaternion(-5L);
        b = new BigQuaternion("-5");
        ArithTest.assertEquals((String)"-5 = '-5'", (Object)a, (Object)b);
        String s = "1111111111111111111111111111111111111111111111";
        a = new BigQuaternion(s);
        String t = a.toString();
        ArithTest.assertEquals((String)"stringConstr = toString", (String)s, (String)t);
    }

    public void testRationalRandom() {
        BigRational a = BigRational.ZERO.random(500);
        BigRational b = new BigRational("" + a);
        BigRational c = b.subtract(a);
        ArithTest.assertTrue((String)"a-'a' = 0", (boolean)c.isZERO());
        ArithTest.assertEquals((String)"compareTo('a',a) = 0", (int)0, (int)b.compareTo(a));
        ArithTest.assertEquals((String)"signum('a'-a) = 0", (int)0, (int)c.signum());
    }

    public void testComplexRandom() {
        BigComplex a = BigComplex.ZERO.random(500);
        BigComplex b = new BigComplex("" + a);
        BigComplex c = b.subtract(a);
        ArithTest.assertTrue((String)"a-'a' = 0", (boolean)c.isZERO());
        ArithTest.assertEquals((String)"compareTo('a',a) = 0", (int)0, (int)b.compareTo(a));
        ArithTest.assertEquals((String)"signum('a'-a) = 0", (int)0, (int)c.signum());
    }

    public void testQuaternionRandom() {
        BigQuaternion a = BigQuaternion.ZERO.random(500);
        BigQuaternion b = new BigQuaternion("" + a);
        BigQuaternion c = b.subtract(a);
        ArithTest.assertTrue((String)"a-'a' = 0", (boolean)c.isZERO());
        ArithTest.assertEquals((String)"signum('a'-a) = 0", (int)0, (int)c.signum());
        ArithTest.assertEquals((String)"compareTo('a',a) = 0", (int)0, (int)b.compareTo(a));
    }

    public void testRationalAddition() {
        BigRational a = BigRational.ZERO.random(500);
        BigRational d = a.sum(BigRational.ZERO);
        ArithTest.assertEquals((String)"a+0 = a", (Object)d, (Object)a);
        d = a.subtract(BigRational.ZERO);
        ArithTest.assertEquals((String)"a-0 = a", (Object)d, (Object)a);
        BigRational b = a.sum(a);
        BigRational c = b.subtract(a);
        ArithTest.assertEquals((String)"(a+a)-a = a", (Object)c, (Object)a);
        b = a.subtract(a);
        c = b.sum(a);
        ArithTest.assertEquals((String)"(a-a)+a = a", (Object)c, (Object)a);
        b = BigRational.ZERO.random(500);
        c = a.sum(b);
        d = b.sum(a);
        ArithTest.assertEquals((String)"a+b = b+a", (Object)c, (Object)d);
        c = a.subtract(b);
        d = a.sum(b.negate());
        ArithTest.assertEquals((String)"a-b = a+(-b)", (Object)c, (Object)d);
        c = BigRational.ZERO.random(500);
        d = a.sum(b.sum(c));
        BigRational e = a.sum(b).sum(c);
        ArithTest.assertEquals((String)"a+(b+c) = (a+b)+c", (Object)d, (Object)e);
    }

    public void testComplexAddition() {
        BigComplex a = BigComplex.ZERO.random(500);
        BigComplex d = a.sum(BigComplex.ZERO);
        ArithTest.assertEquals((String)"a+0 = a", (Object)d, (Object)a);
        d = a.subtract(BigComplex.ZERO);
        ArithTest.assertEquals((String)"a-0 = a", (Object)d, (Object)a);
        BigComplex b = a.sum(a);
        BigComplex c = b.subtract(a);
        ArithTest.assertEquals((String)"(a+a)-a = a", (Object)c, (Object)a);
        b = a.subtract(a);
        c = b.sum(a);
        ArithTest.assertEquals((String)"(a-a)+a = a", (Object)c, (Object)a);
        b = BigComplex.ZERO.random(500);
        c = a.sum(b);
        d = b.sum(a);
        ArithTest.assertEquals((String)"a+b = b+a", (Object)c, (Object)d);
        c = a.subtract(b);
        d = a.sum(b.negate());
        ArithTest.assertEquals((String)"a-b = a+(-b)", (Object)c, (Object)d);
        c = BigComplex.ZERO.random(500);
        d = a.sum(b.sum(c));
        BigComplex e = a.sum(b).sum(c);
        ArithTest.assertEquals((String)"a+(b+c) = (a+b)+c", (Object)d, (Object)e);
    }

    public void testQuaternionAddition() {
        BigQuaternion a = BigQuaternion.ZERO.random(500);
        BigQuaternion d = a.sum(BigQuaternion.ZERO);
        ArithTest.assertEquals((String)"a+0 = a", (Object)d, (Object)a);
        d = a.subtract(BigQuaternion.ZERO);
        ArithTest.assertEquals((String)"a-0 = a", (Object)d, (Object)a);
        BigQuaternion b = a.sum(a);
        BigQuaternion c = b.subtract(a);
        ArithTest.assertEquals((String)"(a+a)-a = a", (Object)c, (Object)a);
        b = a.subtract(a);
        c = b.sum(a);
        ArithTest.assertEquals((String)"(a-a)+a = a", (Object)c, (Object)a);
        b = BigQuaternion.ZERO.random(500);
        c = a.sum(b);
        d = b.sum(a);
        ArithTest.assertEquals((String)"a+b = b+a", (Object)c, (Object)d);
        c = a.subtract(b);
        d = a.sum(b.negate());
        ArithTest.assertEquals((String)"a-b = a+(-b)", (Object)c, (Object)d);
        c = BigQuaternion.ZERO.random(500);
        d = a.sum(b.sum(c));
        BigQuaternion e = a.sum(b).sum(c);
        ArithTest.assertEquals((String)"a+(b+c) = (a+b)+c", (Object)d, (Object)e);
    }

    public void testRationalMultiplication() {
        BigRational a = BigRational.ZERO.random(500);
        BigRational d = a.multiply(BigRational.ONE);
        ArithTest.assertEquals((String)"a*1 = a", (Object)d, (Object)a);
        d = a.divide(BigRational.ONE);
        ArithTest.assertEquals((String)"a/1 = a", (Object)d, (Object)a);
        BigRational b = a.multiply(a);
        BigRational c = b.divide(a);
        ArithTest.assertEquals((String)"(a*a)/a = a", (Object)c, (Object)a);
        b = a.divide(a);
        c = b.multiply(a);
        ArithTest.assertEquals((String)"(a/a)*a = a", (Object)c, (Object)a);
        b = BigRational.ZERO.random(500);
        c = a.multiply(b);
        d = b.multiply(a);
        ArithTest.assertEquals((String)"a*b = b*a", (Object)c, (Object)d);
        d = c.divide(b);
        BigRational e = c.multiply(b.inverse());
        ArithTest.assertEquals((String)"a/b = a*(1/b)", (Object)d, (Object)e);
        c = BigRational.ZERO.random(500);
        d = a.multiply(b.multiply(c));
        e = a.multiply(b).multiply(c);
        ArithTest.assertEquals((String)"a*(b*c) = (a*b)*c", (Object)d, (Object)e);
    }

    public void testComplexMultiplication() {
        BigComplex a = BigComplex.ZERO.random(500);
        BigComplex d = a.multiply(BigComplex.ONE);
        ArithTest.assertEquals((String)"a*1 = a", (Object)d, (Object)a);
        d = a.divide(BigComplex.ONE);
        ArithTest.assertEquals((String)"a/1 = a", (Object)d, (Object)a);
        BigComplex b = a.multiply(a);
        BigComplex c = b.divide(a);
        ArithTest.assertEquals((String)"(a*a)/a = a", (Object)c, (Object)a);
        b = a.divide(a);
        c = b.multiply(a);
        ArithTest.assertEquals((String)"(a/a)*a = a", (Object)c, (Object)a);
        b = BigComplex.ZERO.random(500);
        c = a.multiply(b);
        d = b.multiply(a);
        ArithTest.assertEquals((String)"a*b = b*a", (Object)c, (Object)d);
        d = c.divide(b);
        BigComplex e = c.multiply(b.inverse());
        ArithTest.assertEquals((String)"a/b = a*(1/b)", (Object)d, (Object)e);
        c = BigComplex.ZERO.random(500);
        d = a.multiply(b.multiply(c));
        e = a.multiply(b).multiply(c);
        ArithTest.assertEquals((String)"a*(b*c) = (a*b)*c", (Object)d, (Object)e);
    }

    public void testQuaternionMultiplication() {
        BigQuaternion a = BigQuaternion.ZERO.random(500);
        BigQuaternion d = a.multiply(BigQuaternion.ONE);
        ArithTest.assertEquals((String)"a*1 = a", (Object)d, (Object)a);
        d = a.divide(BigQuaternion.ONE);
        ArithTest.assertEquals((String)"a/1 = a", (Object)d, (Object)a);
        BigQuaternion b = a.multiply(a);
        BigQuaternion c = b.divide(a);
        ArithTest.assertEquals((String)"(a*a)/a = a", (Object)c, (Object)a);
        b = a.divide(a);
        c = b.multiply(a);
        ArithTest.assertEquals((String)"(a/a)*a = a", (Object)c, (Object)a);
        b = BigQuaternion.ZERO.random(500);
        c = b.multiply(a);
        d = c.divide(b);
        BigQuaternion e = c.multiply(b.inverse());
        ArithTest.assertEquals((String)"a/b = a*(1/b)", (Object)d, (Object)e);
        c = BigQuaternion.ZERO.random(500);
        d = a.multiply(b.multiply(c));
        e = a.multiply(b).multiply(c);
        ArithTest.assertEquals((String)"a*(b*c) = (a*b)*c", (Object)d, (Object)e);
        a = BigQuaternion.I;
        b = BigQuaternion.J;
        c = a.multiply(b);
        d = b.multiply(a);
        ArithTest.assertEquals((String)"I*J = -J*I", (Object)c, (Object)d.negate());
        a = BigQuaternion.I;
        b = BigQuaternion.K;
        c = a.multiply(b);
        d = b.multiply(a);
        ArithTest.assertEquals((String)"I*K = -K*I", (Object)c, (Object)d.negate());
        a = BigQuaternion.J;
        b = BigQuaternion.K;
        c = a.multiply(b);
        d = b.multiply(a);
        ArithTest.assertEquals((String)"J*K = -K*J", (Object)c, (Object)d.negate());
    }

    public void testRationalPower() {
        BigRational a = BigRational.ZERO.random(500);
        BigRational b = Power.positivePower(a, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)b, (Object)a);
        Power<BigRational> pow = new Power<BigRational>(BigRational.ONE);
        b = pow.power(a, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)b, (Object)a);
        b = pow.power(a, 2L);
        BigRational c = a.multiply(a);
        ArithTest.assertEquals((String)"a^2 = a*a", (Object)b, (Object)c);
        BigRational d = pow.power(a, -2L);
        c = b.multiply(d);
        ArithTest.assertTrue((String)"a^2 * a^-2 = 1", (boolean)c.isONE());
        b = pow.power(a, 3L);
        c = a.multiply(a).multiply(a);
        ArithTest.assertEquals((String)"a^3 = a*a*a", (Object)b, (Object)c);
        d = pow.power(a, -3L);
        c = b.multiply(d);
        ArithTest.assertTrue((String)"a^3 * a^-3 = 1", (boolean)c.isONE());
    }

    public void testIntegerPower() {
        BigInteger a = BigInteger.ZERO.random(500);
        BigInteger b = Power.positivePower(a, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)b, (Object)a);
        Power<BigInteger> pow = new Power<BigInteger>(BigInteger.ONE);
        b = pow.power(a, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)b, (Object)a);
        b = pow.power(a, 2L);
        BigInteger c = a.multiply(a);
        ArithTest.assertEquals((String)"a^2 = a*a", (Object)b, (Object)c);
        b = pow.power(a, 3L);
        c = a.multiply(a).multiply(a);
        ArithTest.assertEquals((String)"a^3 = a*a*a", (Object)b, (Object)c);
        a = new BigInteger(3L);
        b = Power.positivePower(a, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)b, (Object)a);
        a = new BigInteger(11L);
        BigInteger e = new BigInteger(2L);
        c = Power.modPositivePower(a, 10L, e);
        ArithTest.assertTrue((String)"3^n mod 2 = 1", (boolean)c.isONE());
        a = BigInteger.ZERO.random(500);
        b = new BigInteger(11L);
        c = Power.modPositivePower(a, 11L, b);
        BigInteger d = a.remainder(b);
        ArithTest.assertEquals((String)"a^p = a mod p", (Object)c, (Object)d);
        c = pow.modPower(a, 11L, b);
        ArithTest.assertEquals((String)"a^p = a mod p", (Object)c, (Object)d);
    }

    public void testCombinatoric() {
        BigInteger b;
        BigInteger a = Combinatoric.binCoeff(5, 0);
        ArithTest.assertTrue((String)"(5 0) == 1 ", (boolean)a.isONE());
        a = Combinatoric.binCoeff(5, 7);
        ArithTest.assertTrue((String)"(5 7) == 1 ", (boolean)a.isONE());
        int n = 7;
        int k = 0;
        while (k <= n) {
            a = Combinatoric.binCoeff(n, k);
            b = Combinatoric.binCoeff(n, n - k);
            ArithTest.assertEquals((String)"(5 k) == (5 5-k) ", (Object)b, (Object)a);
            ++k;
        }
        ArithTest.assertTrue((String)"(5 5) == 1 ", (boolean)a.isONE());
        b = Combinatoric.binCoeffSum(n, n);
        BigInteger c = Power.positivePower(new BigInteger(2L), n);
        ArithTest.assertEquals((String)"sum(5 5) == 1 ", (Object)b, (Object)c);
    }

    public void testSquareRoot() {
        BigInteger a = BigInteger.ONE;
        BigInteger b = a.random(47).abs();
        BigInteger d = Roots.sqrtInt(b);
        BigInteger e = d.multiply(d);
        ArithTest.assertTrue((String)"root^2 <= a ", (e.compareTo(b) <= 0 ? 1 : 0) != 0);
        d = d.sum(BigInteger.ONE);
        BigInteger f = d.multiply(d);
        ArithTest.assertTrue((String)"(root+1)^2 >= a ", (f.compareTo(b) >= 0 ? 1 : 0) != 0);
        BigInteger c = Roots.sqrt(b);
        e = c.multiply(c);
        ArithTest.assertTrue((String)"root^2 <= a ", (e.compareTo(b) <= 0 ? 1 : 0) != 0);
        c = c.sum(BigInteger.ONE);
        f = c.multiply(c);
        ArithTest.assertTrue((String)"(root+1)^2 >= a ", (f.compareTo(b) >= 0 ? 1 : 0) != 0);
    }

    public void testRoot() {
        BigInteger a = BigInteger.ONE;
        BigInteger b = a.random(47).abs();
        int n = 2;
        while (n < 8) {
            BigInteger d = Roots.root(b, n);
            BigInteger e = Power.positivePower(d, n);
            ArithTest.assertTrue((String)("root^" + n + " <= a " + b.subtract(e)), (e.compareTo(b) <= 0 ? 1 : 0) != 0);
            d = d.sum(BigInteger.ONE);
            BigInteger f = Power.positivePower(d, n);
            ArithTest.assertTrue((String)("(root+1)^" + n + " >= a "), (f.compareTo(b) >= 0 ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testRootDecimal() {
        BigDecimal a = BigDecimal.ONE;
        BigDecimal b = a.random(7).abs();
        int n = 1;
        while (n < 8) {
            BigDecimal d = Roots.root(b, n);
            BigDecimal e = Power.positivePower(d, n);
            e = e.subtract(d).abs();
            e = e.divide(b);
            if (b.compareTo(a) > 0) {
                ArithTest.assertTrue((String)("root^" + n + " == a: " + e), (a.compareTo(e) >= 0 ? 1 : 0) != 0);
            } else {
                ArithTest.assertTrue((String)("root^" + n + " == a: " + e), (a.compareTo(e) <= 0 ? 1 : 0) != 0);
            }
            ++n;
        }
    }
}

