/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigComplexTest
extends TestCase {
    BigComplex a;
    BigComplex b;
    BigComplex c;
    BigComplex d;
    BigComplex e;

    public static void main(String[] args) {
        TestRunner.run((Test)BigComplexTest.suite());
    }

    public BigComplexTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BigComplexTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstants() {
        this.a = BigComplex.ZERO;
        this.b = BigComplex.ONE;
        this.c = BigComplex.CDIF(this.b, this.b);
        BigComplexTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        BigComplexTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigComplexTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
        this.a = BigComplex.ZERO;
        this.b = BigComplex.ONE;
        this.c = BigComplex.CDIF(this.b, this.b);
        BigComplexTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
    }

    public void testConstructor() {
        this.a = new BigComplex("6/8");
        this.b = new BigComplex("3/4");
        BigComplexTest.assertEquals((String)"6/8 = 3/4", (Object)this.a, (Object)this.b);
        this.a = new BigComplex("3/4 i 4/5");
        this.b = new BigComplex("-3/4 i -4/5");
        BigComplexTest.assertEquals((String)"3/4 + i 4/5 ", (Object)this.a, (Object)this.b.negate());
        String s = "6/1111111111111111111111111111111111111111111";
        this.a = new BigComplex(s);
        String t = this.a.toString();
        BigComplexTest.assertEquals((String)"stringConstr = toString", (String)s, (String)t);
        this.a = new BigComplex(1L);
        this.b = new BigComplex(-1L);
        this.c = BigComplex.CSUM(this.b, this.a);
        BigComplexTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigComplexTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)BigComplex.ZERO);
    }

    public void testRandom() {
        this.a = BigComplex.CRAND(500);
        this.b = new BigComplex(this.a.getRe(), this.a.getIm());
        this.c = BigComplex.CDIF(this.b, this.a);
        BigComplexTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)BigComplex.ZERO);
        this.d = new BigComplex(this.b.getRe(), this.b.getIm());
        BigComplexTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.a = BigComplex.CRAND(100);
        this.b = BigComplex.CSUM(this.a, this.a);
        this.c = BigComplex.CDIF(this.b, this.a);
        BigComplexTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        BigComplexTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = BigComplex.CSUM(this.a, BigComplex.ZERO);
        BigComplexTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = BigComplex.CDIF(this.a, BigComplex.ZERO);
        BigComplexTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = BigComplex.CDIF(this.a, this.a);
        BigComplexTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)BigComplex.ZERO);
    }

    public void testMultiplication() {
        this.a = BigComplex.CRAND(100);
        this.b = BigComplex.CPROD(this.a, this.a);
        this.c = BigComplex.CQ(this.b, this.a);
        BigComplexTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        BigComplexTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = BigComplex.CPROD(this.a, BigComplex.ONE);
        BigComplexTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = BigComplex.CQ(this.a, BigComplex.ONE);
        BigComplexTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = BigComplex.CRAND(100);
        this.b = BigComplex.CINV(this.a);
        this.c = BigComplex.CPROD(this.a, this.b);
        BigComplexTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
    }

    public void testDistributive() {
        BigComplex fac = new BigComplex();
        this.a = fac.random(500);
        this.b = fac.random(500);
        this.c = fac.random(500);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigComplexTest.assertEquals((String)"a(b+c) = ab+ac", (Object)this.d, (Object)this.e);
    }
}

