/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigRational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public final class BigQuaternion
implements StarRingElem<BigQuaternion>,
GcdRingElem<BigQuaternion>,
RingFactory<BigQuaternion> {
    public final BigRational re;
    public final BigRational im;
    public final BigRational jm;
    public final BigRational km;
    private static final Random random = new Random();
    private static final Logger logger = Logger.getLogger(BigQuaternion.class);
    private final boolean debug = logger.isDebugEnabled();
    public static final BigQuaternion ZERO = new BigQuaternion();
    public static final BigQuaternion ONE = new BigQuaternion(BigRational.ONE);
    public static final BigQuaternion I = new BigQuaternion(BigRational.ZERO, BigRational.ONE);
    public static final BigQuaternion J = new BigQuaternion(BigRational.ZERO, BigRational.ZERO, BigRational.ONE);
    public static final BigQuaternion K = new BigQuaternion(BigRational.ZERO, BigRational.ZERO, BigRational.ZERO, BigRational.ONE);

    public BigQuaternion(BigRational r, BigRational i, BigRational j, BigRational k) {
        this.re = r;
        this.im = i;
        this.jm = j;
        this.km = k;
    }

    public BigQuaternion(BigRational r, BigRational i, BigRational j) {
        this(r, i, j, BigRational.ZERO);
    }

    public BigQuaternion(BigRational r, BigRational i) {
        this(r, i, BigRational.ZERO);
    }

    public BigQuaternion(BigRational r) {
        this(r, BigRational.ZERO);
    }

    public BigQuaternion(BigComplex r) {
        this(r.re, r.im);
    }

    public BigQuaternion(long r) {
        this(new BigRational(r), BigRational.ZERO);
    }

    public BigQuaternion() {
        this(BigRational.ZERO);
    }

    public BigQuaternion(String s) throws NumberFormatException {
        int k;
        int j;
        if (s == null || s.length() == 0) {
            this.re = BigRational.ZERO;
            this.im = BigRational.ZERO;
            this.jm = BigRational.ZERO;
            this.km = BigRational.ZERO;
            return;
        }
        int r = (s = s.trim()).indexOf("i") + s.indexOf("j") + s.indexOf("k");
        if (r == -3) {
            this.re = new BigRational(s);
            this.im = BigRational.ZERO;
            this.jm = BigRational.ZERO;
            this.km = BigRational.ZERO;
            return;
        }
        int i = s.indexOf("i");
        String sr = "";
        if (i > 0) {
            sr = s.substring(0, i);
        } else if (i < 0) {
            throw new NumberFormatException("BigQuaternion missing i");
        }
        String si = "";
        if (i < s.length()) {
            s = s.substring(i + 1, s.length());
        }
        if ((j = s.indexOf("j")) > 0) {
            si = s.substring(0, j);
        } else if (j < 0) {
            throw new NumberFormatException("BigQuaternion missing j");
        }
        String sj = "";
        if (j < s.length()) {
            s = s.substring(j + 1, s.length());
        }
        if ((k = s.indexOf("k")) > 0) {
            sj = s.substring(0, k);
        } else if (k < 0) {
            throw new NumberFormatException("BigQuaternion missing k");
        }
        String sk = "";
        if (k < s.length()) {
            s = s.substring(k + 1, s.length());
        }
        sk = s;
        this.re = new BigRational(sr.trim());
        this.im = new BigRational(si.trim());
        this.jm = new BigRational(sj.trim());
        this.km = new BigRational(sk.trim());
    }

    public BigQuaternion factory() {
        return this;
    }

    @Override
    public List<BigQuaternion> generators() {
        ArrayList<BigQuaternion> g = new ArrayList<BigQuaternion>(4);
        g.add(this.getONE());
        g.add(I);
        g.add(J);
        g.add(K);
        return g;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    public BigQuaternion clone() {
        return new BigQuaternion(this.re, this.im, this.jm, this.km);
    }

    @Override
    public BigQuaternion copy(BigQuaternion c) {
        return new BigQuaternion(c.re, c.im, c.jm, c.km);
    }

    @Override
    public BigQuaternion getZERO() {
        return ZERO;
    }

    @Override
    public BigQuaternion getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigQuaternion fromInteger(BigInteger a) {
        return new BigQuaternion(new BigRational(a));
    }

    @Override
    public BigQuaternion fromInteger(long a) {
        return new BigQuaternion(new BigRational(a));
    }

    public BigRational getRe() {
        return this.re;
    }

    public BigRational getIm() {
        return this.im;
    }

    public BigRational getJm() {
        return this.jm;
    }

    public BigRational getKm() {
        return this.km;
    }

    public String toString() {
        String s = "" + this.re;
        int i = this.im.compareTo(BigRational.ZERO);
        int j = this.jm.compareTo(BigRational.ZERO);
        int k = this.km.compareTo(BigRational.ZERO);
        if (this.debug) {
            logger.debug((Object)("compareTo " + this.im + " ? 0 = " + i));
            logger.debug((Object)("compareTo " + this.jm + " ? 0 = " + j));
            logger.debug((Object)("compareTo " + this.km + " ? 0 = " + k));
        }
        if (i == 0 && j == 0 && k == 0) {
            return s;
        }
        s = String.valueOf(s) + "i" + this.im;
        s = String.valueOf(s) + "j" + this.jm;
        s = String.valueOf(s) + "k" + this.km;
        return s;
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        boolean i = this.im.isZERO();
        boolean j = this.jm.isZERO();
        boolean k = this.km.isZERO();
        if (i && j && k) {
            if (this.re.isZERO()) {
                return "0 ";
            }
            if (!this.re.isONE()) {
                s.append(String.valueOf(this.re.toScript()) + "*");
            }
            s.append("oneQ ");
            return s.toString();
        }
        if (!this.re.isZERO()) {
            if (!this.re.isONE()) {
                s.append(String.valueOf(this.re.toScript()) + "*");
            }
            s.append("oneQ ");
        }
        if (!i) {
            if (s.length() > 0) {
                s.append("+ ");
            }
            if (!this.im.isONE()) {
                s.append(String.valueOf(this.im.toScript()) + "*");
            }
            s.append("IQ ");
        }
        if (!j) {
            if (s.length() > 0) {
                s.append("+ ");
            }
            if (!this.jm.isONE()) {
                s.append(String.valueOf(this.jm.toScript()) + "*");
            }
            s.append("JQ ");
        }
        if (!k) {
            if (s.length() > 0) {
                s.append("+ ");
            }
            if (!this.km.isONE()) {
                s.append(String.valueOf(this.km.toScript()) + "*");
            }
            s.append("KQ ");
        }
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return "Quat()";
    }

    public static boolean isQZERO(BigQuaternion A) {
        if (A == null) {
            return false;
        }
        return A.isZERO();
    }

    @Override
    public boolean isZERO() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ZERO) && this.jm.equals(BigRational.ZERO) && this.km.equals(BigRational.ZERO);
    }

    public static boolean isQONE(BigQuaternion A) {
        if (A == null) {
            return false;
        }
        return A.isONE();
    }

    @Override
    public boolean isONE() {
        return this.re.equals(BigRational.ONE) && this.im.equals(BigRational.ZERO) && this.jm.equals(BigRational.ZERO) && this.km.equals(BigRational.ZERO);
    }

    public boolean isIMAG() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ONE) && this.jm.equals(BigRational.ZERO) && this.km.equals(BigRational.ZERO);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof BigQuaternion)) {
            return false;
        }
        BigQuaternion B = (BigQuaternion)b;
        return this.re.equals(B.re) && this.im.equals(B.im) && this.jm.equals(B.jm) && this.km.equals(B.km);
    }

    @Override
    public int hashCode() {
        int h = 37 * this.re.hashCode();
        h += 37 * this.im.hashCode();
        h += 37 * this.jm.hashCode();
        return h += 37 * this.km.hashCode();
    }

    @Override
    public int compareTo(BigQuaternion b) {
        int s = this.re.compareTo(b.re);
        if (s != 0) {
            return s;
        }
        s = this.im.compareTo(b.im);
        if (s != 0) {
            return s;
        }
        s = this.jm.compareTo(b.jm);
        if (s != 0) {
            return s;
        }
        return this.km.compareTo(b.km);
    }

    @Override
    public int signum() {
        int s = this.re.signum();
        if (s != 0) {
            return s;
        }
        s = this.im.signum();
        if (s != 0) {
            return s;
        }
        s = this.jm.signum();
        if (s != 0) {
            return s;
        }
        return this.km.signum();
    }

    @Override
    public BigQuaternion sum(BigQuaternion B) {
        return new BigQuaternion(this.re.sum(B.re), this.im.sum(B.im), this.jm.sum(B.jm), this.km.sum(B.km));
    }

    public static BigQuaternion QSUM(BigQuaternion A, BigQuaternion B) {
        if (A == null) {
            return null;
        }
        return A.sum(B);
    }

    public static BigQuaternion QDIF(BigQuaternion A, BigQuaternion B) {
        if (A == null) {
            return null;
        }
        return A.subtract(B);
    }

    @Override
    public BigQuaternion subtract(BigQuaternion B) {
        return new BigQuaternion(this.re.subtract(B.re), this.im.subtract(B.im), this.jm.subtract(B.jm), this.km.subtract(B.km));
    }

    public static BigQuaternion QNEG(BigQuaternion A) {
        if (A == null) {
            return null;
        }
        return A.negate();
    }

    @Override
    public BigQuaternion negate() {
        return new BigQuaternion(this.re.negate(), this.im.negate(), this.jm.negate(), this.km.negate());
    }

    public static BigQuaternion QCON(BigQuaternion A) {
        if (A == null) {
            return null;
        }
        return A.conjugate();
    }

    @Override
    public BigQuaternion conjugate() {
        return new BigQuaternion(this.re, this.im.negate(), this.jm.negate(), this.km.negate());
    }

    @Override
    public BigQuaternion norm() {
        BigRational v = this.re.multiply(this.re);
        v = v.sum(this.im.multiply(this.im));
        v = v.sum(this.jm.multiply(this.jm));
        v = v.sum(this.km.multiply(this.km));
        return new BigQuaternion(v);
    }

    @Override
    public BigQuaternion abs() {
        BigQuaternion n = this.norm();
        logger.error((Object)"abs() square root missing");
        return n;
    }

    public static BigRational QABS(BigQuaternion A) {
        if (A == null) {
            return null;
        }
        return A.abs().re;
    }

    public static BigQuaternion QPROD(BigQuaternion A, BigQuaternion B) {
        if (A == null) {
            return null;
        }
        return A.multiply(B);
    }

    @Override
    public BigQuaternion multiply(BigQuaternion B) {
        BigRational r = this.re.multiply(B.re);
        r = r.subtract(this.im.multiply(B.im));
        r = r.subtract(this.jm.multiply(B.jm));
        r = r.subtract(this.km.multiply(B.km));
        BigRational i = this.re.multiply(B.im);
        i = i.sum(this.im.multiply(B.re));
        i = i.sum(this.jm.multiply(B.km));
        i = i.subtract(this.km.multiply(B.jm));
        BigRational j = this.re.multiply(B.jm);
        j = j.subtract(this.im.multiply(B.km));
        j = j.sum(this.jm.multiply(B.re));
        j = j.sum(this.km.multiply(B.im));
        BigRational k = this.re.multiply(B.km);
        k = k.sum(this.im.multiply(B.jm));
        k = k.subtract(this.jm.multiply(B.im));
        k = k.sum(this.km.multiply(B.re));
        return new BigQuaternion(r, i, j, k);
    }

    public static BigQuaternion QINV(BigQuaternion A) {
        if (A == null) {
            return null;
        }
        return A.inverse();
    }

    @Override
    public BigQuaternion inverse() {
        BigRational a = this.norm().re.inverse();
        return new BigQuaternion(this.re.multiply(a), this.im.multiply(a.negate()), this.jm.multiply(a.negate()), this.km.multiply(a.negate()));
    }

    @Override
    public BigQuaternion remainder(BigQuaternion S) {
        if (S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public static BigQuaternion QQ(BigQuaternion A, BigQuaternion B) {
        if (A == null) {
            return null;
        }
        return A.divide(B);
    }

    @Override
    public BigQuaternion divide(BigQuaternion b) {
        return this.multiply(b.inverse());
    }

    @Override
    public BigQuaternion divide(BigRational b) {
        BigRational bi = b.inverse();
        return new BigQuaternion(this.re.multiply(bi), this.im.multiply(bi), this.jm.multiply(bi), this.km.multiply(bi));
    }

    @Override
    public BigQuaternion random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigQuaternion random(int n, Random rnd) {
        BigRational r = BigRational.ONE.random(n, rnd);
        BigRational i = BigRational.ONE.random(n, rnd);
        BigRational j = BigRational.ONE.random(n, rnd);
        BigRational k = BigRational.ONE.random(n, rnd);
        return new BigQuaternion(r, i, j, k);
    }

    public static BigQuaternion QRAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public BigQuaternion parse(String s) {
        return new BigQuaternion(s);
    }

    @Override
    public BigQuaternion parse(Reader r) {
        return this.parse(StringUtil.nextString(r));
    }

    @Override
    public BigQuaternion gcd(BigQuaternion S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        return ONE;
    }

    public BigQuaternion[] egcd(BigQuaternion S) {
        BigQuaternion[] ret = new BigQuaternion[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        BigQuaternion half = new BigQuaternion(new BigRational(1L, 2L));
        ret[0] = ONE;
        ret[1] = this.inverse().multiply(half);
        ret[2] = S.inverse().multiply(half);
        return ret;
    }
}

