/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigRational;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigRationalTest
extends TestCase {
    BigRational a;
    BigRational b;
    BigRational c;
    BigRational d;
    BigRational e;

    public static void main(String[] args) {
        TestRunner.run((Test)BigRationalTest.suite());
    }

    public BigRationalTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BigRationalTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstants() {
        this.a = BigRational.ZERO;
        this.b = BigRational.ONE;
        this.c = BigRational.RNDIF(this.b, this.b);
        BigRationalTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        BigRationalTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigRationalTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
        this.a = BigRational.ZERO;
        this.b = BigRational.ONE;
        this.c = BigRational.RNDIF(this.b, this.b);
        BigRationalTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
    }

    public void testConstructor() {
        this.a = new BigRational("6/8");
        this.b = new BigRational("3/4");
        BigRationalTest.assertEquals((String)"6/8 = 3/4", (Object)this.a, (Object)this.b);
        this.a = new BigRational("3/-4");
        this.b = new BigRational("-3/4");
        BigRationalTest.assertEquals((String)"3/-4 = -3/4", (Object)this.a, (Object)this.b);
        String s = "6/1111111111111111111111111111111111111111111";
        this.a = new BigRational(s);
        String t = this.a.toString();
        BigRationalTest.assertEquals((String)"stringConstr = toString", (String)s, (String)t);
        this.a = new BigRational(1L);
        this.b = new BigRational(-1L);
        this.c = BigRational.RNSUM(this.b, this.a);
        BigRationalTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigRationalTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)BigRational.ZERO);
        s = "1.500000000";
        this.a = new BigRational(s);
        this.b = new BigRational("3/2");
        BigRationalTest.assertEquals((String)"decimalConstr = b ", (Object)this.a, (Object)this.b);
        s = "-1.500000000";
        this.a = new BigRational(s);
        this.b = new BigRational("-3/2");
        BigRationalTest.assertEquals((String)"decimalConstr = b ", (Object)this.a, (Object)this.b);
        s = "0.750000000";
        this.a = new BigRational(s);
        this.b = new BigRational("3/4");
        BigRationalTest.assertEquals((String)"decimalConstr = b ", (Object)this.a, (Object)this.b);
        s = "0.333333333";
        this.a = new BigRational(s);
        t = this.a.toString(9);
        BigRationalTest.assertEquals((String)("decimalConstr = b " + t), (String)s, (String)t);
        s = "-0.000033333";
        this.a = new BigRational(s);
        t = this.a.toString(9);
        BigRationalTest.assertEquals((String)("decimalConstr = b " + t), (String)s, (String)t);
    }

    public void testRandom() {
        this.a = BigRational.RNRAND(500);
        this.b = new BigRational("" + this.a);
        this.c = BigRational.RNDIF(this.b, this.a);
        BigRationalTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)BigRational.ZERO);
        this.d = new BigRational(this.b.numerator(), this.b.denominator());
        BigRationalTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.a = BigRational.RNRAND(100);
        this.b = BigRational.RNSUM(this.a, this.a);
        this.c = BigRational.RNDIF(this.b, this.a);
        BigRationalTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        BigRationalTest.assertEquals((String)"a+a-a = a", (int)0, (int)BigRational.RNCOMP(this.c, this.a));
        this.d = BigRational.RNSUM(this.a, BigRational.ZERO);
        BigRationalTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = BigRational.RNDIF(this.a, BigRational.ZERO);
        BigRationalTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = BigRational.RNDIF(this.a, this.a);
        BigRationalTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)BigRational.ZERO);
    }

    public void testMultiplication() {
        this.a = BigRational.RNRAND(100);
        this.b = BigRational.RNPROD(this.a, this.a);
        this.c = BigRational.RNQ(this.b, this.a);
        BigRationalTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        BigRationalTest.assertEquals((String)"a*a/a = a", (int)0, (int)BigRational.RNCOMP(this.c, this.a));
        this.d = BigRational.RNPROD(this.a, BigRational.ONE);
        BigRationalTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = BigRational.RNQ(this.a, BigRational.ONE);
        BigRationalTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = BigRational.RNRAND(100);
        this.b = BigRational.RNINV(this.a);
        this.c = BigRational.RNPROD(this.a, this.b);
        BigRationalTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
    }

    public void testDistributive() {
        BigRational fac = new BigRational();
        this.a = fac.random(500);
        this.b = fac.random(500);
        this.c = fac.random(500);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigRationalTest.assertEquals((String)"a(b+c) = ab+ac", (Object)this.d, (Object)this.e);
    }

    public void testIterator() {
        int t = 0;
        BigRational bi = new BigRational();
        bi.setAllIterator();
        BigRational j = null;
        BigRational elem = null;
        for (BigRational i : bi) {
            if (++t < 20) continue;
            j = i;
            break;
        }
        elem = new BigRational(-2L, 3L);
        BigRationalTest.assertTrue((String)"j == 10 ", (boolean)j.equals(elem));
    }

    public void testNNIterator() {
        int t = 0;
        BigRational bi = new BigRational();
        bi.setNonNegativeIterator();
        BigRational j = null;
        BigRational elem = null;
        for (BigRational i : bi) {
            if (++t < 20) continue;
            j = i;
            break;
        }
        elem = new BigRational(4L, 3L);
        BigRationalTest.assertTrue((String)"j == 10 ", (boolean)j.equals(elem));
    }

    public void testUniqueNNIterator() {
        int t = 0;
        BigRational bi = new BigRational();
        bi.setNonNegativeIterator();
        BigRational j = null;
        BigRational elem = null;
        Iterator<BigRational> iter = bi.uniqueIterator();
        while (iter.hasNext()) {
            BigRational i = iter.next();
            if (++t < 20) continue;
            j = i;
            break;
        }
        elem = new BigRational(5L, 3L);
        BigRationalTest.assertTrue((String)"j == 10 ", (boolean)j.equals(elem));
    }
}

