/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.PrimeList;
import edu.jas.kern.PrettyPrint;
import edu.jas.structure.NotInvertibleException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ModIntegerTest
extends TestCase {
    ModIntegerRing zm;
    ModIntegerRing z1;
    ModIntegerRing z2;
    ModInteger a;
    ModInteger b;
    ModInteger c;
    ModInteger d;
    ModInteger e;

    public static void main(String[] args) {
        TestRunner.run((Test)ModIntegerTest.suite());
    }

    public ModIntegerTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ModIntegerTest.class);
        return suite;
    }

    protected void setUp() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected static BigInteger getPrime1() {
        long prime = 2L;
        int i = 1;
        while (i < 60) {
            prime *= 2L;
            ++i;
        }
        return new BigInteger("" + (prime -= 93L));
    }

    protected static BigInteger getPrime2() {
        long prime = 2L;
        int i = 1;
        while (i < 30) {
            prime *= 2L;
            ++i;
        }
        return new BigInteger("" + (prime -= 35L));
    }

    public void testConstants() {
        this.zm = new ModIntegerRing(5L);
        this.d = new ModInteger(this.zm, 11L);
        this.a = this.zm.getZERO();
        this.b = this.zm.getONE();
        this.c = ModInteger.MIDIF(this.b, this.b);
        ModIntegerTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        ModIntegerTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        ModIntegerTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
    }

    public void testConstructor() {
        String st;
        this.zm = new ModIntegerRing("5");
        this.a = new ModInteger(this.zm, "64");
        this.b = new ModInteger(this.zm, "34");
        ModIntegerTest.assertEquals((String)"64(5) = 34(5)", (Object)this.a, (Object)this.b);
        this.zm = new ModIntegerRing("7");
        this.a = new ModInteger(this.zm, "-4");
        this.b = new ModInteger(this.zm, "3");
        ModIntegerTest.assertEquals((String)"-4(7) = 3(7)", (Object)this.a, (Object)this.b);
        String s = "61111111111111111111111111111111111111111111";
        this.zm = new ModIntegerRing("10");
        this.a = new ModInteger(this.zm, s);
        String t = this.a.toString();
        if (PrettyPrint.isTrue()) {
            st = "1";
            ModIntegerTest.assertEquals((String)"stringConstr = toString", (String)st, (String)t);
        } else {
            st = "1 mod(10)";
            ModIntegerTest.assertEquals((String)"stringConstr = toString", (String)st, (String)t);
        }
        this.zm = new ModIntegerRing(7L);
        this.a = new ModInteger(this.zm, 1L);
        this.b = new ModInteger(this.zm, -1L);
        this.c = ModInteger.MISUM(this.b, this.a);
        ModIntegerTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        ModIntegerTest.assertTrue((String)"1 = 1", (boolean)this.b.isUnit());
        ModIntegerTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.zm = new ModIntegerRing(5L);
        this.a = new ModInteger(this.zm, 3L);
        this.b = new ModInteger(this.zm, 0L);
        this.c = this.zm.parse(" 13 ");
        ModIntegerTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
        StringReader sr = new StringReader("  13\n w ");
        this.c = this.zm.parse(sr);
        ModIntegerTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
    }

    public void testRandom() {
        this.zm = new ModIntegerRing(19L);
        this.a = this.zm.random(500);
        this.b = this.a.clone();
        this.c = ModInteger.MIDIF(this.b, this.a);
        ModIntegerTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.d = new ModInteger(new ModIntegerRing(this.b.getModul()), this.b.getVal());
        ModIntegerTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.zm = new ModIntegerRing(19L);
        this.a = this.zm.random(100);
        this.b = ModInteger.MISUM(this.a, this.a);
        this.c = ModInteger.MIDIF(this.b, this.a);
        ModIntegerTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ModIntegerTest.assertEquals((String)"a+a-a = a", (int)0, (int)ModInteger.MICOMP(this.c, this.a));
        this.d = ModInteger.MISUM(this.a, this.zm.getZERO());
        ModIntegerTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = ModInteger.MIDIF(this.a, this.zm.getZERO());
        ModIntegerTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = ModInteger.MIDIF(this.a, this.a);
        ModIntegerTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)this.zm.getZERO());
    }

    public void testMultiplication() {
        this.zm = new ModIntegerRing(5L);
        this.d = new ModInteger(this.zm, 11L);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = ModInteger.MIPROD(this.a, this.a);
        this.c = ModInteger.MIQ(this.b, this.a);
        ModIntegerTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        ModIntegerTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = ModInteger.MIPROD(this.a, this.zm.getONE());
        ModIntegerTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = ModInteger.MIQ(this.a, this.zm.getONE());
        ModIntegerTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = ModInteger.MIINV(this.a);
        this.c = ModInteger.MIPROD(this.a, this.b);
        ModIntegerTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
        try {
            this.a = this.zm.getZERO().inverse();
        }
        catch (NotInvertibleException expected) {
            return;
        }
        ModIntegerTest.fail((String)"0 invertible");
    }

    public void testChineseRemainder() {
        this.zm = new ModIntegerRing(247L);
        this.a = this.zm.random(9);
        this.z1 = new ModIntegerRing(19L);
        this.b = new ModInteger(this.z1, this.a.getVal().longValue());
        this.z2 = new ModIntegerRing(13L);
        this.c = new ModInteger(this.z2, this.a.getVal().longValue());
        this.d = new ModInteger(this.z2, 19L);
        this.d = this.d.inverse();
        this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
        ModIntegerTest.assertEquals((String)"cra(a mod 19,a mod 13) = a", (Object)this.a, (Object)this.e);
        BigInteger p1 = ModIntegerTest.getPrime1();
        BigInteger p2 = ModIntegerTest.getPrime2();
        BigInteger p1p2 = p1.multiply(p2);
        this.zm = new ModIntegerRing(p1p2);
        this.z1 = new ModIntegerRing(p1);
        this.z2 = new ModIntegerRing(p2);
        int i = 0;
        while (i < 5) {
            this.a = this.zm.random(44);
            this.b = new ModInteger(this.z1, this.a.getVal());
            this.c = new ModInteger(this.z2, this.a.getVal());
            ModInteger di = new ModInteger(this.z2, p1);
            this.d = di.inverse();
            this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
            ModIntegerTest.assertEquals((String)"cra(a mod p1,a mod p2) = a", (Object)this.a, (Object)this.e);
            ++i;
        }
    }

    public void testPrime() {
        PrimeList primes = new PrimeList();
        int i = 0;
        for (BigInteger p : primes) {
            if (i++ > 50) break;
        }
        ModIntegerTest.assertTrue((String)"all primes ", (boolean)primes.checkPrimes());
    }

    public void testMersennePrime() {
        PrimeList primes = new PrimeList(PrimeList.Range.mersenne);
        int i = 1;
        for (BigInteger p : primes) {
            if (i++ > 23) break;
        }
        ModIntegerTest.assertTrue((String)"all primes ", (boolean)primes.checkPrimes(15));
    }

    public void testIterator() {
        int m = 10;
        this.zm = new ModIntegerRing(m);
        ModInteger j = null;
        Iterator<ModInteger> iterator = this.zm.iterator();
        while (iterator.hasNext()) {
            ModInteger i;
            j = i = iterator.next();
        }
        ModInteger end = new ModInteger(this.zm, m - 1);
        ModIntegerTest.assertTrue((String)"j == m-1 ", (boolean)j.equals(end));
    }
}

