/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;

public final class ModLong
implements GcdRingElem<ModLong>,
Modular {
    public final ModLongRing ring;
    protected final long val;

    public ModLong(ModLongRing m, java.math.BigInteger a) {
        this(m, a.mod(new java.math.BigInteger("" + m.modul)).longValue());
    }

    public ModLong(ModLongRing m, long a) {
        this.ring = m;
        long v = a % this.ring.modul;
        this.val = v >= 0L ? v : v + this.ring.modul;
    }

    public ModLong(ModLongRing m, Long a) {
        this(m, (long)a);
    }

    public ModLong(ModLongRing m, String s) {
        this(m, new Long(s.trim()));
    }

    public ModLong(ModLongRing m) {
        this(m, 0L);
    }

    public long getVal() {
        return this.val;
    }

    public long getModul() {
        return this.ring.modul;
    }

    public ModLongRing factory() {
        return this.ring;
    }

    public long getSymmetricVal() {
        if (this.val + this.val > this.ring.modul) {
            return this.val - this.ring.modul;
        }
        return this.val;
    }

    @Override
    public BigInteger getInteger() {
        return new BigInteger(this.val);
    }

    @Override
    public BigInteger getSymmetricInteger() {
        long v = this.val;
        if (this.val + this.val > this.ring.modul) {
            v = this.val - this.ring.modul;
        }
        return new BigInteger(v);
    }

    public ModLong clone() {
        return new ModLong(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val == 0L;
    }

    @Override
    public boolean isONE() {
        return this.val == 1L;
    }

    @Override
    public boolean isUnit() {
        if (this.isZERO()) {
            return false;
        }
        if (this.ring.isField()) {
            return true;
        }
        long g = this.gcd(this.ring.modul, this.val);
        return g == 1L || g == -1L;
    }

    public String toString() {
        return "" + this.val;
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.factory().toScript();
    }

    @Override
    public int compareTo(ModLong b) {
        long v = b.val;
        if (this.ring != b.ring) {
            v %= this.ring.modul;
        }
        if (this.val > v) {
            return 1;
        }
        return this.val < v ? -1 : 0;
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof ModLong)) {
            return false;
        }
        return this.compareTo((ModLong)b) == 0;
    }

    @Override
    public int hashCode() {
        return (int)this.val;
    }

    @Override
    public ModLong abs() {
        return new ModLong(this.ring, this.val < 0L ? -this.val : this.val);
    }

    @Override
    public ModLong negate() {
        return new ModLong(this.ring, -this.val);
    }

    @Override
    public int signum() {
        if (this.val > 0L) {
            return 1;
        }
        return this.val < 0L ? -1 : 0;
    }

    @Override
    public ModLong subtract(ModLong S) {
        return new ModLong(this.ring, this.val - S.val);
    }

    @Override
    public ModLong divide(ModLong S) {
        try {
            return this.multiply(S.inverse());
        }
        catch (NotInvertibleException e) {
            try {
                if (this.val % S.val == 0L) {
                    return new ModLong(this.ring, this.val / S.val);
                }
                throw new NotInvertibleException(e.getCause());
            }
            catch (ArithmeticException a) {
                throw new NotInvertibleException(a.getCause());
            }
        }
    }

    @Override
    public ModLong inverse() {
        try {
            return new ModLong(this.ring, this.modInverse(this.val, this.ring.modul));
        }
        catch (ArithmeticException e) {
            throw new NotInvertibleException(e.getCause());
        }
    }

    @Override
    public ModLong remainder(ModLong S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(String.valueOf(this.getClass().getName()) + " division by zero");
        }
        if (S.isONE()) {
            return this.ring.getZERO();
        }
        if (S.isUnit()) {
            return this.ring.getZERO();
        }
        return new ModLong(this.ring, this.val % S.val);
    }

    @Override
    public ModLong multiply(ModLong S) {
        return new ModLong(this.ring, this.val * S.val);
    }

    @Override
    public ModLong sum(ModLong S) {
        return new ModLong(this.ring, this.val + S.val);
    }

    @Override
    public ModLong gcd(ModLong S) {
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.isUnit() || S.isUnit()) {
            return this.ring.getONE();
        }
        return new ModLong(this.ring, this.gcd(this.val, S.val));
    }

    public ModLong[] egcd(ModLong S) {
        ModLong[] ret = new ModLong[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        if (this.isUnit() || S.isUnit()) {
            ret[0] = this.ring.getONE();
            if (this.isUnit() && S.isUnit()) {
                ModLong half = new ModLong(this.ring, 2L).inverse();
                ret[1] = this.inverse().multiply(half);
                ret[2] = S.inverse().multiply(half);
                return ret;
            }
            if (this.isUnit()) {
                ret[1] = this.inverse();
                ret[2] = this.ring.getZERO();
                return ret;
            }
            ret[1] = this.ring.getZERO();
            ret[2] = S.inverse();
            return ret;
        }
        long q = this.val;
        long r = S.val;
        long c1 = 1L;
        long d1 = 0L;
        long c2 = 0L;
        long d2 = 1L;
        while (r != 0L) {
            long a = q / r;
            long b = q % r;
            q = a;
            long x1 = c1 - q * d1;
            long x2 = c2 - q * d2;
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = b;
        }
        System.out.println("q = " + q + "\n c1 = " + c1 + "\n c2 = " + c2);
        ret[0] = new ModLong(this.ring, q);
        ret[1] = new ModLong(this.ring, c1);
        ret[2] = new ModLong(this.ring, c2);
        return ret;
    }

    public long gcd(long T, long S) {
        if (S == 0L) {
            return T;
        }
        if (T == 0L) {
            return S;
        }
        long a = T;
        long b = S;
        while (b != 0L) {
            long r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    public long[] hegcd(long T, long S) {
        long[] ret = new long[2];
        if (S == 0L) {
            ret[0] = T;
            ret[1] = 1L;
            return ret;
        }
        if (T == 0L) {
            ret[0] = S;
            ret[1] = 0L;
            return ret;
        }
        long a = T;
        long b = S;
        long a1 = 1L;
        long b1 = 0L;
        while (b != 0L) {
            long q = a / b;
            long r = a % b;
            a = b;
            b = r;
            long r1 = a1 - q * b1;
            a1 = b1;
            b1 = r1;
        }
        if (a1 < 0L) {
            a1 += S;
        }
        ret[0] = a;
        ret[1] = a1;
        return ret;
    }

    public long modInverse(long T, long m) {
        if (T == 0L) {
            throw new NotInvertibleException("zero is not invertible");
        }
        long[] hegcd = this.hegcd(T, m);
        long a = hegcd[0];
        if (a != 1L && a != -1L) {
            throw new NotInvertibleException("element not invertible, gcd != 1");
        }
        long b = hegcd[1];
        if (b == 0L) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        if (b < 0L) {
            b += m;
        }
        return b;
    }
}

