/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.structure.NotInvertibleException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ModLongTest
extends TestCase {
    ModLongRing zm;
    ModLongRing z1;
    ModLongRing z2;
    ModLong a;
    ModLong b;
    ModLong c;
    ModLong d;
    ModLong e;

    public static void main(String[] args) {
        TestRunner.run((Test)ModLongTest.suite());
    }

    public ModLongTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ModLongTest.class);
        return suite;
    }

    protected void setUp() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected static BigInteger getPrime1() {
        long prime = 2L;
        int i = 1;
        while (i < 30) {
            prime *= 2L;
            ++i;
        }
        return new BigInteger("" + (prime -= 35L));
    }

    protected static BigInteger getPrime2() {
        long prime = 2L;
        int i = 1;
        while (i < 30) {
            prime *= 2L;
            ++i;
        }
        prime = 37L;
        return new BigInteger("" + prime);
    }

    public void testConstants() {
        this.zm = new ModLongRing(5L);
        this.d = new ModLong(this.zm, 11L);
        this.a = this.zm.getZERO();
        this.b = this.zm.getONE();
        this.c = this.b.subtract(this.b);
        ModLongTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        ModLongTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        ModLongTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
    }

    public void testConstructor() {
        String st;
        this.zm = new ModLongRing("5");
        this.a = new ModLong(this.zm, "64");
        this.b = new ModLong(this.zm, "34");
        ModLongTest.assertEquals((String)"64(5) = 34(5)", (Object)this.a, (Object)this.b);
        this.zm = new ModLongRing("7");
        this.a = new ModLong(this.zm, "-4");
        this.b = new ModLong(this.zm, "3");
        ModLongTest.assertEquals((String)"-4(7) = 3(7)", (Object)this.a, (Object)this.b);
        String s = "61111111111111111";
        this.zm = new ModLongRing("10");
        this.a = new ModLong(this.zm, s);
        String t = this.a.toString();
        if (PrettyPrint.isTrue()) {
            st = "1";
            ModLongTest.assertEquals((String)"stringConstr = toString", (String)st, (String)t);
        } else {
            st = "1 mod(10)";
            ModLongTest.assertEquals((String)"stringConstr = toString", (String)st, (String)t);
        }
        this.zm = new ModLongRing(7L);
        this.a = new ModLong(this.zm, 1L);
        this.b = new ModLong(this.zm, -1L);
        this.c = this.b.sum(this.a);
        ModLongTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        ModLongTest.assertTrue((String)"1 = 1", (boolean)this.b.isUnit());
        ModLongTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.zm = new ModLongRing(5L);
        this.a = new ModLong(this.zm, 3L);
        this.b = new ModLong(this.zm, 0L);
        this.c = this.zm.parse(" 13 ");
        ModLongTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
        StringReader sr = new StringReader("  13\n w ");
        this.c = this.zm.parse(sr);
        ModLongTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
    }

    public void testRandom() {
        this.zm = new ModLongRing(19L);
        this.a = this.zm.random(500);
        this.b = this.a.clone();
        this.c = this.b.subtract(this.a);
        ModLongTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.d = new ModLong(new ModLongRing(this.b.getModul()), this.b.getVal());
        ModLongTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.zm = new ModLongRing(19L);
        this.a = this.zm.random(100);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        ModLongTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ModLongTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.sum(this.zm.getZERO());
        ModLongTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.zm.getZERO());
        ModLongTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.a);
        ModLongTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)this.zm.getZERO());
    }

    public void testMultiplication() {
        this.zm = new ModLongRing(5L);
        this.d = new ModLong(this.zm, 11L);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = this.a.multiply(this.a);
        this.c = this.b.divide(this.a);
        ModLongTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        ModLongTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.multiply(this.zm.getONE());
        ModLongTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(this.zm.getONE());
        ModLongTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        ModLongTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
        try {
            this.a = this.zm.getZERO().inverse();
        }
        catch (NotInvertibleException expected) {
            return;
        }
        ModLongTest.fail((String)"0 invertible");
    }

    public void testChineseRemainder() {
        this.zm = new ModLongRing(247L);
        this.a = this.zm.random(9);
        this.z1 = new ModLongRing(19L);
        this.b = new ModLong(this.z1, this.a.getVal());
        this.z2 = new ModLongRing(13L);
        this.c = new ModLong(this.z2, this.a.getVal());
        this.d = new ModLong(this.z2, 19L);
        this.d = this.d.inverse();
        this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
        ModLongTest.assertEquals((String)"cra(a mod 19,a mod 13) = a", (Object)this.a, (Object)this.e);
        BigInteger p1 = ModLongTest.getPrime2();
        BigInteger p2 = new BigInteger("19");
        BigInteger p1p2 = p1.multiply(p2);
        this.zm = new ModLongRing(p1p2);
        this.z1 = new ModLongRing(p1);
        this.z2 = new ModLongRing(p2);
        int i = 0;
        while (i < 5) {
            this.a = this.zm.random(44);
            this.b = new ModLong(this.z1, this.a.getVal());
            this.c = new ModLong(this.z2, this.a.getVal());
            ModLong di = new ModLong(this.z2, p1);
            this.d = di.inverse();
            this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
            ModLongTest.assertEquals((String)"cra(a mod p1,a mod p2) = a ", (Object)this.a, (Object)this.e);
            ++i;
        }
    }

    public void testTiming() {
        this.zm = new ModLongRing(ModLongTest.getPrime1());
        this.a = this.zm.random(9);
        this.b = this.zm.random(9);
        this.c = this.zm.getONE();
        ModIntegerRing ZM = new ModIntegerRing(this.zm.modul);
        ModInteger A = new ModInteger(ZM, this.a.getVal());
        ModInteger B = new ModInteger(ZM, this.b.getVal());
        ModInteger C = ZM.getONE();
        int run = 1000;
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < run) {
            if (this.c.isZERO()) {
                this.c = this.zm.getONE();
            }
            this.c = this.a.sum(this.b.divide(this.c));
            ++i;
        }
        t = System.currentTimeMillis() - t;
        ModInteger D2 = new ModInteger(ZM, this.c.getVal());
        t = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < run) {
            if (C.isZERO()) {
                C = ZM.getONE();
            }
            C = A.sum(B.divide(C));
            ++i2;
        }
        t = System.currentTimeMillis() - t;
        ModLongTest.assertEquals((String)"C == D ", (Object)C, (Object)D2);
    }

    public void testIterator() {
        int m = 10;
        this.zm = new ModLongRing(m);
        ModLong j = null;
        Iterator<ModLong> iterator = this.zm.iterator();
        while (iterator.hasNext()) {
            ModLong i;
            j = i = iterator.next();
        }
        ModLong end = new ModLong(this.zm, m - 1);
        ModLongTest.assertTrue((String)"j == m-1 ", (boolean)j.equals(end));
    }
}

