/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.structure.Power;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PrimeList
implements Iterable<java.math.BigInteger> {
    protected final List<java.math.BigInteger> val = new ArrayList<java.math.BigInteger>(50);
    protected java.math.BigInteger last;

    public PrimeList() {
        this(Range.medium);
    }

    public PrimeList(Range r) {
        switch (r) {
            case small: {
                this.addSmall();
                break;
            }
            default: {
                this.addMedium();
                break;
            }
            case large: {
                this.addLarge();
                break;
            }
            case mersenne: {
                this.addMersenne();
            }
        }
        this.last = this.get(this.size() - 1);
    }

    private void addSmall() {
        this.val.add(new java.math.BigInteger("2"));
        this.val.add(new java.math.BigInteger("3"));
        this.val.add(new java.math.BigInteger("5"));
        this.val.add(new java.math.BigInteger("7"));
        this.val.add(new java.math.BigInteger("11"));
        this.val.add(new java.math.BigInteger("13"));
        this.val.add(new java.math.BigInteger("17"));
        this.val.add(new java.math.BigInteger("19"));
        this.val.add(new java.math.BigInteger("23"));
    }

    private void addMedium() {
        this.val.add(PrimeList.getLongPrime(28, 57));
        this.val.add(PrimeList.getLongPrime(28, 89));
        this.val.add(PrimeList.getLongPrime(28, 95));
        this.val.add(PrimeList.getLongPrime(28, 119));
        this.val.add(PrimeList.getLongPrime(28, 125));
        this.val.add(PrimeList.getLongPrime(28, 143));
        this.val.add(PrimeList.getLongPrime(28, 165));
        this.val.add(PrimeList.getLongPrime(28, 183));
        this.val.add(PrimeList.getLongPrime(28, 213));
        this.val.add(PrimeList.getLongPrime(28, 273));
        this.val.add(PrimeList.getLongPrime(29, 3));
        this.val.add(PrimeList.getLongPrime(29, 33));
        this.val.add(PrimeList.getLongPrime(29, 43));
        this.val.add(PrimeList.getLongPrime(29, 63));
        this.val.add(PrimeList.getLongPrime(29, 73));
        this.val.add(PrimeList.getLongPrime(29, 75));
        this.val.add(PrimeList.getLongPrime(29, 93));
        this.val.add(PrimeList.getLongPrime(29, 99));
        this.val.add(PrimeList.getLongPrime(29, 121));
        this.val.add(PrimeList.getLongPrime(29, 133));
    }

    private void addLarge() {
        this.val.add(PrimeList.getLongPrime(59, 55));
        this.val.add(PrimeList.getLongPrime(59, 99));
        this.val.add(PrimeList.getLongPrime(59, 225));
        this.val.add(PrimeList.getLongPrime(59, 427));
        this.val.add(PrimeList.getLongPrime(59, 517));
        this.val.add(PrimeList.getLongPrime(59, 607));
        this.val.add(PrimeList.getLongPrime(59, 649));
        this.val.add(PrimeList.getLongPrime(59, 687));
        this.val.add(PrimeList.getLongPrime(59, 861));
        this.val.add(PrimeList.getLongPrime(59, 871));
        this.val.add(PrimeList.getLongPrime(60, 93));
        this.val.add(PrimeList.getLongPrime(60, 107));
        this.val.add(PrimeList.getLongPrime(60, 173));
        this.val.add(PrimeList.getLongPrime(60, 179));
        this.val.add(PrimeList.getLongPrime(60, 257));
        this.val.add(PrimeList.getLongPrime(60, 279));
        this.val.add(PrimeList.getLongPrime(60, 369));
        this.val.add(PrimeList.getLongPrime(60, 395));
        this.val.add(PrimeList.getLongPrime(60, 399));
        this.val.add(PrimeList.getLongPrime(60, 453));
        this.val.add(PrimeList.getLongPrime(63, 25));
        this.val.add(PrimeList.getLongPrime(63, 165));
        this.val.add(PrimeList.getLongPrime(63, 259));
        this.val.add(PrimeList.getLongPrime(63, 301));
        this.val.add(PrimeList.getLongPrime(63, 375));
        this.val.add(PrimeList.getLongPrime(63, 387));
        this.val.add(PrimeList.getLongPrime(63, 391));
        this.val.add(PrimeList.getLongPrime(63, 409));
        this.val.add(PrimeList.getLongPrime(63, 457));
        this.val.add(PrimeList.getLongPrime(63, 471));
    }

    private void addMersenne() {
        this.val.add(PrimeList.getMersennePrime(2));
        this.val.add(PrimeList.getMersennePrime(3));
        this.val.add(PrimeList.getMersennePrime(5));
        this.val.add(PrimeList.getMersennePrime(7));
        this.val.add(PrimeList.getMersennePrime(13));
        this.val.add(PrimeList.getMersennePrime(17));
        this.val.add(PrimeList.getMersennePrime(19));
        this.val.add(PrimeList.getMersennePrime(31));
        this.val.add(PrimeList.getMersennePrime(61));
        this.val.add(PrimeList.getMersennePrime(89));
        this.val.add(PrimeList.getMersennePrime(107));
        this.val.add(PrimeList.getMersennePrime(127));
        this.val.add(PrimeList.getMersennePrime(521));
        this.val.add(PrimeList.getMersennePrime(607));
        this.val.add(PrimeList.getMersennePrime(1279));
        this.val.add(PrimeList.getMersennePrime(2203));
        this.val.add(PrimeList.getMersennePrime(2281));
        this.val.add(PrimeList.getMersennePrime(3217));
        this.val.add(PrimeList.getMersennePrime(4253));
        this.val.add(PrimeList.getMersennePrime(4423));
        this.val.add(PrimeList.getMersennePrime(9689));
        this.val.add(PrimeList.getMersennePrime(9941));
        this.val.add(PrimeList.getMersennePrime(11213));
        this.val.add(PrimeList.getMersennePrime(19937));
    }

    protected static java.math.BigInteger getLongPrime(int n, int m) {
        long prime = 2L;
        int i = 1;
        while (i < n) {
            prime *= 2L;
            ++i;
        }
        return new java.math.BigInteger("" + (prime -= (long)m));
    }

    protected static java.math.BigInteger getMersennePrime(int n) {
        BigInteger t = new BigInteger(2L);
        BigInteger p = Power.positivePower(t, n);
        p = p.subtract(new BigInteger(1L));
        java.math.BigInteger prime = p.getVal();
        return prime;
    }

    protected boolean checkPrimes() {
        return this.checkPrimes(this.size());
    }

    protected boolean checkPrimes(int n) {
        int i = 0;
        for (java.math.BigInteger p : this.val) {
            if (i++ >= n) break;
            boolean isPrime = p.isProbablePrime(63);
            if (isPrime) continue;
            System.out.println("not prime = " + p);
            return false;
        }
        return true;
    }

    public String toString() {
        return this.val.toString();
    }

    public int size() {
        return this.val.size();
    }

    public java.math.BigInteger get(int i) {
        java.math.BigInteger p;
        if (i < this.size()) {
            p = this.val.get(i);
        } else {
            p = this.last.nextProbablePrime();
            this.val.add(p);
            this.last = p;
        }
        return p;
    }

    @Override
    public Iterator<java.math.BigInteger> iterator() {
        return new Iterator<java.math.BigInteger>(){
            int index = -1;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not implemented");
            }

            @Override
            public java.math.BigInteger next() {
                ++this.index;
                return PrimeList.this.get(this.index);
            }
        };
    }

    public static enum Range {
        small,
        medium,
        large,
        mersenne;

    }
}

