/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.commons.math;

import edu.jas.commons.math.CMFieldElement;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import org.apache.commons.math.Field;

public class CMField<C extends RingElem<C>>
implements Field<CMFieldElement<C>> {
    public final RingFactory<C> fac;

    public CMField(ElemFactory<C> f) {
        this((RingFactory)f);
    }

    public CMField(RingFactory<C> f) {
        this.fac = f;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Field)) {
            return false;
        }
        if (obj instanceof CMField) {
            CMField other = (CMField)obj;
            RingFactory<C> ofac = other.fac;
            if (!this.fac.getClass().getName().equals(ofac.getClass().getName())) {
                return false;
            }
            RingFactory ofac1 = null;
            try {
                ofac1 = (RingFactory)((RingElem)((Object)ofac)).factory();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (ofac.equals(ofac1)) {
                return true;
            }
            return this.fac.equals(ofac);
        }
        return false;
    }

    public CMFieldElement<C> get(int i) {
        return new CMFieldElement<RingElem>((RingElem)this.fac.fromInteger(i));
    }

    public CMFieldElement<C> get(long i) {
        return new CMFieldElement<RingElem>((RingElem)this.fac.fromInteger(i));
    }

    public CMFieldElement<C> get(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        return new CMFieldElement<RingElem>((RingElem)this.fac.parse(s));
    }

    public CMFieldElement<C>[] getArray(int size) {
        CMFieldElement[] arr = new CMFieldElement[size];
        int i = 0;
        while (i < arr.length) {
            arr[i] = this.getZero();
            ++i;
        }
        return arr;
    }

    public CMFieldElement<C>[][] getArray(int rows, int columns) {
        CMFieldElement[][] arr = new CMFieldElement[rows][columns];
        int i = 0;
        while (i < arr.length) {
            arr[i] = this.getArray(columns);
            ++i;
        }
        return arr;
    }

    @Override
    public CMFieldElement<C> getOne() {
        return new CMFieldElement<RingElem>((RingElem)this.fac.getONE());
    }

    @Override
    public CMFieldElement<C> getZero() {
        return new CMFieldElement<RingElem>((RingElem)this.fac.getZERO());
    }

    public int hashCode() {
        RingFactory fac1 = null;
        try {
            fac1 = (RingFactory)((RingElem)((Object)this.fac)).factory();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.fac.equals(fac1)) {
            return this.fac.getClass().getName().hashCode();
        }
        return this.fac.hashCode();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        String f = null;
        try {
            f = ((Element)((Object)this.fac)).toScriptFactory();
        }
        catch (Exception ignored) {
            f = this.fac.toScript();
        }
        if (f != null) {
            s.append(f);
        }
        return s.toString();
    }
}

