/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.commons.math;

import edu.jas.commons.math.CMField;
import edu.jas.structure.RingElem;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;

public class CMFieldElement<C extends RingElem<C>>
implements FieldElement<CMFieldElement<C>>,
Comparable<CMFieldElement<C>> {
    public final C val;

    public CMFieldElement(C v) {
        this.val = v;
    }

    @Override
    public CMFieldElement<C> add(CMFieldElement<C> other) {
        return new CMFieldElement<RingElem>((RingElem)this.val.sum(other.val));
    }

    @Override
    public int compareTo(CMFieldElement<C> other) {
        return this.val.compareTo(other.val);
    }

    @Override
    public CMFieldElement<C> divide(CMFieldElement<C> other) throws ArithmeticException {
        return new CMFieldElement<RingElem>((RingElem)this.val.divide(other.val));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMFieldElement)) {
            return false;
        }
        CMFieldElement other = (CMFieldElement)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public Field<CMFieldElement<C>> getField() {
        return new CMField(this.val.factory());
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public CMFieldElement<C> multiply(CMFieldElement<C> other) {
        return new CMFieldElement<RingElem>((RingElem)this.val.multiply(other.val));
    }

    @Override
    public CMFieldElement<C> subtract(CMFieldElement<C> other) {
        return new CMFieldElement<RingElem>((RingElem)this.val.subtract(other.val));
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.val.toString());
        return s.toString();
    }

    public boolean isOne() {
        return this.val.isONE();
    }

    public boolean isZero() {
        return this.val.isZERO();
    }
}

