/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.commons.math;

import edu.jas.arith.BigRational;
import edu.jas.commons.math.CMField;
import edu.jas.commons.math.CMFieldElement;
import edu.jas.commons.math.CMFieldElementUtil;
import edu.jas.structure.RingElem;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CMFieldElementTest
extends TestCase {
    int rl = 5;
    int kl = 10;
    int ll = 10;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)CMFieldElementTest.suite());
    }

    public CMFieldElementTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(CMFieldElementTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstruction() {
        BigRational z = new BigRational(0L);
        CMFieldElement<BigRational> a = new CMFieldElement<BigRational>(z);
        CMFieldElementTest.assertTrue((String)"isZero( a )", (boolean)a.isZero());
        BigRational o = new BigRational(1L);
        CMFieldElement<BigRational> b = new CMFieldElement<BigRational>(o);
        CMFieldElementTest.assertTrue((String)"isOne( b )", (boolean)b.isOne());
        CMFieldElement<BigRational> c = b.subtract(b);
        CMFieldElementTest.assertTrue((String)"isZero( c )", (boolean)c.isZero());
        CMFieldElementTest.assertEquals((String)"a == c ", a, c);
        c = new CMFieldElement<BigRational>(new BigRational(1L, 2L));
        CMFieldElementTest.assertTrue((String)"!isZero( c )", (!c.isZero() ? 1 : 0) != 0);
    }

    public void testFactory() {
        BigRational z = new BigRational(0L);
        CMField<BigRational> fac = new CMField<BigRational>(z);
        Object a = fac.getZero();
        CMFieldElementTest.assertTrue((String)"isZero( a )", (boolean)((CMFieldElement)a).isZero());
        Object b = fac.getOne();
        CMFieldElementTest.assertTrue((String)"isOne( b )", (boolean)((CMFieldElement)b).isOne());
    }

    public void testVectorConversion() {
        BigRational z = new BigRational(0L);
        CMField<BigRational> fac = new CMField<BigRational>(z);
        Object[] vec1 = fac.getArray(this.ll);
        RingElem[] v1 = CMFieldElementUtil.fromCMFieldElement((CMFieldElement[])vec1);
        Object[] vec2 = CMFieldElementUtil.toCMFieldElementRE(v1);
        CMFieldElementTest.assertTrue((String)"v1[] == v2[] ", (boolean)Arrays.equals(vec1, vec2));
        Object[] v2 = new BigRational[this.ll];
        int i = 0;
        while (i < v2.length) {
            v2[i] = (BigRational)z.random(this.kl);
            ++i;
        }
        CMFieldElement[] vec3 = CMFieldElementUtil.toCMFieldElement((RingElem[])v2);
        Object[] v3 = CMFieldElementUtil.fromCMFieldElement((CMFieldElement[])vec3);
        CMFieldElementTest.assertTrue((String)"v2[] == v3[] ", (boolean)Arrays.equals(v2, v3));
    }

    public void testMatrixConversion() {
        BigRational z = new BigRational(0L);
        CMField<BigRational> fac = new CMField<BigRational>(z);
        Object[][] vec1 = fac.getArray(this.ll, this.ll);
        RingElem[][] v1 = CMFieldElementUtil.fromCMFieldElement((CMFieldElement[][])vec1);
        Object[][] vec2 = CMFieldElementUtil.toCMFieldElementRE(v1);
        this.assertMatrixEquals(vec1, vec2);
        Object[][] v2 = new BigRational[this.ll][];
        int i = 0;
        while (i < v2.length) {
            v2[i] = new BigRational[this.ll];
            int j = 0;
            while (j < v2.length) {
                v2[i][j] = (BigRational)z.random(this.kl);
                ++j;
            }
            ++i;
        }
        CMFieldElement[][] vec3 = CMFieldElementUtil.toCMFieldElement((RingElem[][])v2);
        Object[][] v3 = CMFieldElementUtil.fromCMFieldElement((CMFieldElement[][])vec3);
        this.assertMatrixEquals(v2, v3);
    }

    public String matrixToString(Object[][] m) {
        StringBuffer s = new StringBuffer("[");
        int i = 0;
        while (i < m.length) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(Arrays.toString(m[i]));
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    public void assertMatrixEquals(Object[][] m1, Object[][] m2) {
        int i = 0;
        while (i < m1.length) {
            CMFieldElementTest.assertTrue((String)"m1[][] == m2[][] ", (boolean)Arrays.equals(m1[i], m2[i]));
            ++i;
        }
    }
}

