/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.commons.math;

import edu.jas.commons.math.CMFieldElement;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.linear.ArrayFieldVector;
import org.apache.commons.math.linear.BlockFieldMatrix;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CMFieldElementUtil {
    public static <C extends RingElem<C>> C[] toArray(GenVector<C> a) {
        if (a == null) {
            return null;
        }
        return CMFieldElementUtil.toArray(a.val);
    }

    public static <C extends RingElem<C>> C[] toArray(List<C> a) {
        if (a == null) {
            return null;
        }
        RingElem[] av = new RingElem[a.size()];
        int i = 0;
        for (RingElem e : a) {
            av[i++] = e;
        }
        return av;
    }

    public static <C extends RingElem<C>> ArrayList<C> toList(C[] a) {
        if (a == null) {
            return null;
        }
        ArrayList<C> av = new ArrayList<C>(a.length);
        int i = 0;
        while (i < a.length) {
            av.add(a[i]);
            ++i;
        }
        return av;
    }

    public static <C extends RingElem<C>> ArrayList<ArrayList<C>> toList(C[][] a) {
        if (a == null) {
            return null;
        }
        ArrayList<ArrayList<C>> av = new ArrayList<ArrayList<C>>(a.length);
        int i = 0;
        while (i < a.length) {
            av.add(CMFieldElementUtil.toList(a[i]));
            ++i;
        }
        return av;
    }

    public static <C extends RingElem<C>> C[][] toArray(GenMatrix<C> a) {
        if (a == null) {
            return null;
        }
        return CMFieldElementUtil.toArray(a.matrix);
    }

    public static <C extends RingElem<C>> C[][] toArray(List<ArrayList<C>> a) {
        if (a == null) {
            return null;
        }
        RingElem[][] av = new RingElem[a.size()][];
        int i = 0;
        for (List list : a) {
            av[i++] = CMFieldElementUtil.toArray((List)list);
        }
        return av;
    }

    public static <C extends RingElem<C>> CMFieldElement<C>[] toCMFieldElement(C[] v) {
        if (v == null) {
            return null;
        }
        CMFieldElement[] va = new CMFieldElement[v.length];
        int i = 0;
        while (i < v.length) {
            va[i] = new CMFieldElement<C>(v[i]);
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> CMFieldElement<C>[] toCMFieldElementRE(RingElem<C>[] v) {
        if (v == null) {
            return null;
        }
        CMFieldElement[] va = new CMFieldElement[v.length];
        int i = 0;
        while (i < v.length) {
            va[i] = new CMFieldElement<RingElem<C>>(v[i]);
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> CMFieldElement<C>[] toCMFieldElement(GenVector<C> v) {
        if (v == null) {
            return null;
        }
        CMFieldElement<C>[] va = CMFieldElementUtil.toCMFieldElement(v.val);
        return va;
    }

    public static <C extends RingElem<C>> CMFieldElement<C>[] toCMFieldElement(List<C> v) {
        if (v == null) {
            return null;
        }
        CMFieldElement[] va = new CMFieldElement[v.size()];
        int i = 0;
        while (i < v.size()) {
            va[i] = new CMFieldElement<RingElem>((RingElem)v.get(i));
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> FieldVector<CMFieldElement<C>> toCMFieldElementVector(GenVector<C> v) {
        if (v == null) {
            return null;
        }
        return new ArrayFieldVector((FieldElement[])CMFieldElementUtil.toCMFieldElement(v.val));
    }

    public static <C extends RingElem<C>> CMFieldElement<C>[][] toCMFieldElement(C[][] v) {
        if (v == null) {
            return null;
        }
        CMFieldElement[][] va = new CMFieldElement[v.length][];
        int i = 0;
        while (i < v.length) {
            va[i] = CMFieldElementUtil.toCMFieldElement(v[i]);
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> CMFieldElement<C>[][] toCMFieldElementRE(RingElem<C>[][] v) {
        if (v == null) {
            return null;
        }
        CMFieldElement[][] va = new CMFieldElement[v.length][];
        int i = 0;
        while (i < v.length) {
            va[i] = CMFieldElementUtil.toCMFieldElementRE(v[i]);
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> CMFieldElement<C>[][] toCMFieldElement(GenMatrix<C> v) {
        if (v == null) {
            return null;
        }
        CMFieldElement<C>[][] va = CMFieldElementUtil.toCMFieldElement(v.matrix);
        return va;
    }

    public static <C extends RingElem<C>> CMFieldElement<C>[][] toCMFieldElement(List<ArrayList<C>> v) {
        if (v == null) {
            return null;
        }
        CMFieldElement[][] va = new CMFieldElement[v.size()][];
        int i = 0;
        while (i < v.size()) {
            va[i] = CMFieldElementUtil.toCMFieldElement((List)v.get(i));
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> FieldMatrix<CMFieldElement<C>> toCMFieldMatrix(GenMatrix<C> v) {
        if (v == null) {
            return null;
        }
        BlockFieldMatrix va = new BlockFieldMatrix((FieldElement[][])CMFieldElementUtil.toCMFieldElement(v.matrix));
        return va;
    }

    public static <C extends RingElem<C>> C[] fromCMFieldElement(CMFieldElement<C>[] v) {
        if (v == null) {
            return null;
        }
        RingElem[] va = new RingElem[v.length];
        int i = 0;
        while (i < v.length) {
            va[i] = v[i] != null ? v[i].val : null;
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> C[][] fromCMFieldElement(CMFieldElement<C>[][] v) {
        if (v == null) {
            return null;
        }
        RingElem[][] va = new RingElem[v.length][];
        int i = 0;
        while (i < v.length) {
            va[i] = CMFieldElementUtil.fromCMFieldElement((CMFieldElement[])v[i]);
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> C[] fromCMFieldVector(FieldVector<CMFieldElement<C>> v) {
        if (v == null) {
            return null;
        }
        RingElem[] va = new RingElem[v.getDimension()];
        int i = 0;
        while (i < va.length) {
            CMFieldElement<C> e = v.getEntry(i);
            va[i] = e != null ? e.val : null;
            ++i;
        }
        return va;
    }

    public static <C extends RingElem<C>> ArrayList<C> listFromCMFieldVector(FieldVector<CMFieldElement<C>> v) {
        if (v == null) {
            return null;
        }
        ArrayList vv = new ArrayList(v.getDimension());
        int i = 0;
        while (i < v.getDimension()) {
            CMFieldElement<C> e = v.getEntry(i);
            if (e != null) {
                vv.add(e.val);
            } else {
                vv.add(null);
            }
            ++i;
        }
        return vv;
    }

    public static <C extends RingElem<C>> GenVector<C> vectorFromCMFieldVector(GenVectorModul<C> fac, FieldVector<CMFieldElement<C>> v) {
        if (v == null) {
            return null;
        }
        ArrayList<C> list = CMFieldElementUtil.listFromCMFieldVector(v);
        GenVector<C> vv = new GenVector<C>(fac, list);
        return vv;
    }

    public static <C extends RingElem<C>> List<List<C>> listFromCMFieldMatrix(FieldMatrix<CMFieldElement<C>> v) {
        if (v == null) {
            return null;
        }
        ArrayList<List<C>> vv = new ArrayList<List<C>>(v.getRowDimension());
        int i = 0;
        while (i < v.getRowDimension()) {
            FieldVector<CMFieldElement<C>> e = v.getRowVector(i + 1);
            ArrayList<C> l = CMFieldElementUtil.listFromCMFieldVector(e);
            vv.add(l);
            ++i;
        }
        return vv;
    }

    public static <C extends RingElem<C>> GenMatrix<C> matrixFromCMFieldMatrix(GenMatrixRing<C> fac, FieldMatrix<CMFieldElement<C>> v) {
        if (v == null) {
            return null;
        }
        List<List<C>> list = CMFieldElementUtil.listFromCMFieldMatrix(v);
        GenMatrix<C> vv = new GenMatrix<C>(fac, list);
        return vv;
    }
}

