/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.commons.math;

import edu.jas.commons.math.CMFieldElement;
import edu.jas.commons.math.CMFieldElementUtil;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenVector;
import org.apache.commons.math.linear.FieldDecompositionSolver;
import org.apache.commons.math.linear.FieldLUDecompositionImpl;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;

public class GaussElimination<C extends RingElem<C>> {
    public C determinant(GenMatrix<C> a) {
        FieldMatrix<CMFieldElement<C>> am = CMFieldElementUtil.toCMFieldMatrix(a);
        FieldLUDecompositionImpl<CMFieldElement<C>> lu = new FieldLUDecompositionImpl<CMFieldElement<C>>(am);
        CMFieldElement<C> dm = lu.getDeterminant();
        Object d = dm.val;
        return d;
    }

    public GenMatrix<C> inverse(GenMatrix<C> a) {
        FieldMatrix<CMFieldElement<C>> am = CMFieldElementUtil.toCMFieldMatrix(a);
        FieldLUDecompositionImpl<CMFieldElement<C>> lu = new FieldLUDecompositionImpl<CMFieldElement<C>>(am);
        FieldDecompositionSolver<CMFieldElement<C>> fds = lu.getSolver();
        FieldMatrix<CMFieldElement<C>> bm = fds.getInverse();
        GenMatrix g = CMFieldElementUtil.matrixFromCMFieldMatrix(a.ring, bm);
        return g;
    }

    public boolean isNullSpace(GenMatrix<C> a, GenMatrix<C> n) {
        GenMatrix<C> z = a.multiply(n);
        return z.isZERO();
    }

    public GenVector<C> solve(GenMatrix<C> a, GenVector<C> b) {
        FieldMatrix<CMFieldElement<C>> am = CMFieldElementUtil.toCMFieldMatrix(a);
        FieldVector<CMFieldElement<C>> bv = CMFieldElementUtil.toCMFieldElementVector(b);
        FieldLUDecompositionImpl<CMFieldElement<C>> lu = new FieldLUDecompositionImpl<CMFieldElement<C>>(am);
        FieldDecompositionSolver<CMFieldElement<C>> fds = lu.getSolver();
        FieldVector<CMFieldElement<C>> xv = fds.solve(bv);
        GenVector xa = CMFieldElementUtil.vectorFromCMFieldVector(b.modul, xv);
        return xa;
    }

    public C trace(GenMatrix<C> a) {
        FieldMatrix<CMFieldElement<C>> am = CMFieldElementUtil.toCMFieldMatrix(a);
        CMFieldElement<C> dm = am.getTrace();
        Object d = dm.val;
        return d;
    }
}

