/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.io.Serializable;

public class CriticalPair<C extends RingElem<C>>
implements Serializable {
    public final ExpVector e;
    public final GenPolynomial<C> pi;
    public final GenPolynomial<C> pj;
    public final int i;
    public final int j;
    protected volatile boolean inReduction;
    protected volatile GenPolynomial<C> reductum;

    public CriticalPair(ExpVector e, GenPolynomial<C> pi, GenPolynomial<C> pj, int i, int j) {
        this.e = e;
        this.pi = pi;
        this.pj = pj;
        this.i = i;
        this.j = j;
        this.inReduction = false;
        this.reductum = null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("pair( ");
        s.append(this.e + "," + this.i);
        if (this.pi != null) {
            s.append("{" + this.pi.length() + "}");
        }
        s.append("," + this.j);
        if (this.pj != null) {
            s.append("{" + this.pj.length() + "}");
        }
        if (this.inReduction) {
            s.append("," + this.inReduction);
        }
        if (this.reductum != null) {
            s.append("," + this.reductum.leadingExpVector());
        }
        s.append(" )");
        return s.toString();
    }

    public void setInReduction() {
        if (this.inReduction) {
            throw new IllegalStateException("already in reduction " + this);
        }
        this.inReduction = true;
    }

    public boolean getInReduction() {
        return this.inReduction;
    }

    public GenPolynomial<C> getReductum() {
        return this.reductum;
    }

    public void setReductum(GenPolynomial<C> r) {
        if (r == null) {
            throw new IllegalArgumentException("reduction null not allowed " + this);
        }
        this.inReduction = false;
        this.reductum = r;
    }

    public boolean isZERO() {
        if (this.reductum == null) {
            return false;
        }
        return this.reductum.isZERO();
    }

    public boolean isONE() {
        if (this.reductum == null) {
            return false;
        }
        return this.reductum.isONE();
    }
}

