/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairComparator;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CriticalPairList<C extends RingElem<C>> {
    private final GenPolynomialRing<C> ring;
    private final ArrayList<GenPolynomial<C>> P;
    private final SortedSet<CriticalPair<C>> pairlist;
    private final ArrayList<BitSet> red;
    private final Reduction<C> reduction;
    private boolean oneInGB = false;
    private boolean useCriterion4 = true;
    private int recordCount;
    private int putCount;
    private int remCount;
    private final int moduleVars;
    private static final Logger logger = Logger.getLogger(CriticalPairList.class);

    public CriticalPairList(GenPolynomialRing<C> r) {
        this(0, r);
    }

    public CriticalPairList(int m, GenPolynomialRing<C> r) {
        this.ring = r;
        if (m < 0 || this.ring.nvar < m) {
            throw new IllegalArgumentException("moduleVars > nvars");
        }
        this.moduleVars = m;
        this.P = new ArrayList();
        CriticalPairComparator cpc = new CriticalPairComparator(this.ring.tord);
        this.pairlist = new TreeSet(cpc);
        this.red = new ArrayList();
        this.recordCount = 0;
        this.putCount = 0;
        this.remCount = 0;
        if (this.ring instanceof GenSolvablePolynomialRing) {
            this.useCriterion4 = false;
        }
        this.reduction = new ReductionSeq();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("CriticalPairlist(");
        s.append("#put=" + this.putCount);
        s.append(", #rem=" + this.remCount);
        if (this.pairlist.size() != 0) {
            s.append(", size=" + this.pairlist.size());
        }
        s.append(")");
        return s.toString();
    }

    public synchronized int put(GenPolynomial<C> p) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector e = p.leadingExpVector();
        int len = this.P.size();
        int j = 0;
        while (j < len) {
            GenPolynomial<C> pj = this.P.get(j);
            ExpVector f = pj.leadingExpVector();
            if (this.moduleVars <= 0 || this.reduction.moduleCriterion(this.moduleVars, e, f)) {
                ExpVector g = e.lcm(f);
                CriticalPair<C> pair = new CriticalPair<C>(g, pj, p, j, len);
                this.pairlist.add(pair);
            }
            ++j;
        }
        this.P.add(p);
        BitSet redi = new BitSet();
        redi.set(0, len);
        this.red.add(redi);
        if (this.recordCount < len) {
            this.recordCount = len;
        }
        return len;
    }

    public synchronized int putOne() {
        ++this.putCount;
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add((GenPolynomial<C>)this.ring.getONE());
        this.red.clear();
        this.recordCount = 0;
        return 0;
    }

    public synchronized CriticalPair<C> getNext() {
        if (this.oneInGB) {
            return null;
        }
        CriticalPair pair = null;
        Iterator ip = this.pairlist.iterator();
        boolean c = false;
        while (!c & ip.hasNext()) {
            pair = (CriticalPair)ip.next();
            if (pair.getInReduction() || pair.getReductum() != null) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("" + pair));
            }
            if (c = this.useCriterion4 ? this.reduction.criterion4(pair.pi, pair.pj, pair.e) : true) {
                c = this.criterion3(pair.i, pair.j, pair.e);
            }
            this.red.get(pair.j).clear(pair.i);
            if (c) continue;
            pair.setReductum(this.ring.getZERO());
        }
        if (!c) {
            pair = null;
        } else {
            ++this.remCount;
            pair.setInReduction();
        }
        return pair;
    }

    public int record(CriticalPair<C> pair, GenPolynomial<C> p) {
        if (p == null) {
            p = this.ring.getZERO();
        }
        pair.setReductum((GenPolynomial<C>)p);
        if (!((GenPolynomial)p).isZERO() && !((GenPolynomial)p).isONE()) {
            ++this.recordCount;
            return this.recordCount;
        }
        return -1;
    }

    public int update(CriticalPair<C> pair, GenPolynomial<C> p) {
        if (p == null) {
            p = this.ring.getZERO();
        }
        pair.setReductum((GenPolynomial<C>)p);
        if (!((GenPolynomial)p).isZERO() && !((GenPolynomial)p).isONE()) {
            ++this.recordCount;
        }
        int c = this.update();
        if (!((GenPolynomial)p).isZERO() && !((GenPolynomial)p).isONE()) {
            return this.recordCount;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int update() {
        num = 0;
        if (!this.oneInGB) ** GOTO lbl15
        return num;
        while ((p = (pair = this.pairlist.first()).getReductum()) != null) {
            this.pairlist.remove(pair);
            ++num;
            if (!p.isZERO()) {
                if (p.isONE()) {
                    this.putOne();
                } else {
                    this.put(p);
                }
            }
lbl15:
            // 5 sources

            if (this.pairlist.size() > 0) continue;
        }
        return num;
    }

    public synchronized List<CriticalPair<C>> inWork() {
        ArrayList<CriticalPair<C>> iw = new ArrayList<CriticalPair<C>>();
        if (this.oneInGB) {
            return iw;
        }
        for (CriticalPair criticalPair : this.pairlist) {
            if (!criticalPair.getInReduction()) continue;
            iw.add(criticalPair);
        }
        return iw;
    }

    public synchronized int updateMany() {
        int num = 0;
        if (this.oneInGB) {
            return num;
        }
        ArrayList<CriticalPair> rem = new ArrayList<CriticalPair>();
        for (CriticalPair criticalPair : this.pairlist) {
            if (criticalPair.getReductum() == null) break;
            rem.add(criticalPair);
            ++num;
        }
        for (CriticalPair criticalPair : rem) {
            this.pairlist.remove(criticalPair);
            GenPolynomial p = criticalPair.getReductum();
            if (p.isZERO()) continue;
            if (p.isONE()) {
                this.putOne();
                continue;
            }
            this.put(p);
        }
        return num;
    }

    public boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    public ArrayList<GenPolynomial<C>> getList() {
        return this.P;
    }

    public int putCount() {
        return this.putCount;
    }

    public int remCount() {
        return this.remCount;
    }

    public boolean criterion3(int i, int j, ExpVector eij) {
        assert (i < j);
        boolean s = this.red.get(j).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        int k = 0;
        while (k < this.P.size()) {
            GenPolynomial<C> A;
            ExpVector ek;
            boolean m;
            if (i != k && j != k && (m = eij.multipleOf(ek = (A = this.P.get(k)).leadingExpVector()))) {
                if (k < i) {
                    s = this.red.get(i).get(k) || this.red.get(j).get(k);
                } else if (i < k && k < j) {
                    s = this.red.get(k).get(i) || this.red.get(j).get(k);
                } else if (j < k) {
                    boolean bl = s = this.red.get(k).get(i) || this.red.get(k).get(j);
                }
                if (!s) {
                    return s;
                }
            }
            ++k;
        }
        return true;
    }
}

