/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.DReduction;
import edu.jas.gb.ReductionAbstract;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class DReductionSeq<C extends RingElem<C>>
extends ReductionAbstract<C>
implements DReduction<C> {
    private static final Logger logger = Logger.getLogger(DReductionSeq.class);
    private final boolean debug = logger.isDebugEnabled();

    @Override
    public boolean isTopReducible(List<GenPolynomial<C>> P, GenPolynomial<C> A) {
        if (P == null || P.isEmpty()) {
            return false;
        }
        if (A == null || A.isZERO()) {
            return false;
        }
        boolean mt = false;
        ExpVector e = A.leadingExpVector();
        C a = A.leadingBaseCoefficient();
        for (GenPolynomial<C> p : P) {
            C b;
            RingElem r;
            mt = e.multipleOf(p.leadingExpVector());
            if (!mt || !(mt = (r = (RingElem)a.remainder(b = p.leadingBaseCoefficient())).isZERO())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        GenPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        if (Ap == null || Ap.isZERO()) {
            return true;
        }
        List<GenPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenPolynomial[l];
            int i = 0;
            while (i < Pp.size()) {
                P[i] = Pp.get(i);
                ++i;
            }
        }
        ExpVector[] htl = new ExpVector[l];
        RingElem[] lbc = new RingElem[l];
        GenPolynomial[] p = new GenPolynomial[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            p[i] = P[i];
            Map.Entry m = p[i].leadingMonomial();
            if (m != null) {
                p[j] = p[i];
                htl[j] = m.getKey();
                lbc[j] = (RingElem)m.getValue();
                ++j;
            }
            ++i;
        }
        l = j;
        boolean mt = false;
        SortedMap<ExpVector, C> Am = Ap.getMap();
        for (ExpVector e : Am.keySet()) {
            i = 0;
            while (i < l) {
                RingElem a;
                RingElem r;
                mt = e.multipleOf(htl[i]);
                if (mt && (mt = (r = (a = (RingElem)Am.get(e)).remainder(lbc[i])).isZERO())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        Map.Entry m;
        GenPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        List<GenPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenPolynomial[l];
            int i = 0;
            while (i < Pp.size()) {
                P[i] = Pp.get(i).abs();
                ++i;
            }
        }
        ExpVector[] htl = new ExpVector[l];
        RingElem[] lbc = new RingElem[l];
        GenPolynomial[] p = new GenPolynomial[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            p[i] = P[i];
            m = p[i].leadingMonomial();
            if (m != null) {
                p[j] = p[i];
                htl[j] = m.getKey();
                lbc[j] = (RingElem)m.getValue();
                ++j;
            }
            ++i;
        }
        l = j;
        RingElem r = null;
        boolean mt = false;
        GenPolynomial<RingElem> R = Ap.ring.getZERO();
        GenPolynomial<RingElem> Q = null;
        GenPolynomial<Object> S = Ap;
        while (S.length() > 0) {
            m = S.leadingMonomial();
            ExpVector e = m.getKey();
            RingElem a = (RingElem)m.getValue();
            i = 0;
            while (i < l) {
                mt = e.multipleOf(htl[i]);
                if (mt) {
                    r = a.remainder(lbc[i]);
                    mt = r.isZERO();
                }
                if (mt) break;
                ++i;
            }
            if (!mt) {
                R = R.sum(a, e);
                S = S.reductum();
                continue;
            }
            ExpVector f = e.subtract(htl[i]);
            RingElem b = a.divide(lbc[i]);
            R = R.sum(r, e);
            Q = p[i].multiply(b, f);
            S = S.reductum().subtract(Q.reductum());
        }
        return R.abs();
    }

    @Override
    public GenPolynomial<C> SPolynomial(GenPolynomial<C> Ap, GenPolynomial<C> Bp) {
        if (logger.isInfoEnabled()) {
            if (Bp == null || Bp.isZERO()) {
                return Ap.ring.getZERO();
            }
            if (Ap == null || Ap.isZERO()) {
                return Bp.ring.getZERO();
            }
            if (!Ap.ring.equals(Bp.ring)) {
                logger.error((Object)"rings not equal");
            }
        }
        Map.Entry<ExpVector, C> ma = Ap.leadingMonomial();
        Map.Entry<ExpVector, C> mb = Bp.leadingMonomial();
        ExpVector e = ma.getKey();
        ExpVector f = mb.getKey();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        RingElem a = (RingElem)ma.getValue();
        RingElem b = (RingElem)mb.getValue();
        RingElem c = a.gcd(b);
        RingElem m = a.multiply(b);
        RingElem l = m.divide(c);
        RingElem a1 = l.divide(a);
        RingElem b1 = l.divide(b);
        GenPolynomial<RingElem> App = Ap.multiply(a1, e1);
        GenPolynomial<RingElem> Bpp = Bp.multiply(b1, f1);
        GenPolynomial<GenPolynomial<RingElem>> Cp = App.subtract((RingElem)Bpp);
        return Cp;
    }

    @Override
    public GenPolynomial<C> GPolynomial(GenPolynomial<C> Ap, GenPolynomial<C> Bp) {
        if (logger.isInfoEnabled()) {
            if (Bp == null || Bp.isZERO()) {
                return Ap.ring.getZERO();
            }
            if (Ap == null || Ap.isZERO()) {
                return Bp.ring.getZERO();
            }
            if (!Ap.ring.equals(Bp.ring)) {
                logger.error((Object)"rings not equal");
            }
        }
        Map.Entry<ExpVector, C> ma = Ap.leadingMonomial();
        Map.Entry<ExpVector, C> mb = Bp.leadingMonomial();
        ExpVector e = ma.getKey();
        ExpVector f = mb.getKey();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        RingElem a = (RingElem)ma.getValue();
        RingElem b = (RingElem)mb.getValue();
        RingElem[] c = a.egcd(b);
        GenPolynomial<RingElem> App = Ap.multiply(c[1], e1);
        GenPolynomial<RingElem> Bpp = Bp.multiply(c[2], f1);
        GenPolynomial<GenPolynomial<RingElem>> Cp = App.sum((RingElem)Bpp);
        return Cp;
    }

    @Override
    public GenPolynomial<C> GPolynomial(List<GenPolynomial<C>> S, int i, GenPolynomial<C> Ap, int j, GenPolynomial<C> Bp) {
        throw new UnsupportedOperationException("not jet implemented");
    }

    @Override
    public boolean criterion4(GenPolynomial<C> A, GenPolynomial<C> B, ExpVector e) {
        C b;
        C a;
        C d;
        ExpVector ej;
        ExpVector ei;
        ExpVector g;
        ExpVector h;
        int s;
        if (logger.isInfoEnabled()) {
            if (!A.ring.equals(B.ring)) {
                logger.error((Object)"rings equal");
            }
            if (A instanceof GenSolvablePolynomial || B instanceof GenSolvablePolynomial) {
                logger.error((Object)"GBCriterion4 not applicabable to SolvablePolynomials");
                return true;
            }
        }
        return (s = (h = (g = (ei = A.leadingExpVector()).sum(ej = B.leadingExpVector())).subtract(e)).signum()) != 0 || !(d = (a = A.leadingBaseCoefficient()).gcd(b = B.leadingBaseCoefficient())).isONE();
    }

    @Override
    public boolean criterion4(GenPolynomial<C> A, GenPolynomial<C> B) {
        C b;
        C a;
        C d;
        ExpVector e;
        ExpVector ej;
        if (logger.isInfoEnabled() && (A instanceof GenSolvablePolynomial || B instanceof GenSolvablePolynomial)) {
            logger.error((Object)"GBCriterion4 not applicabable to SolvablePolynomials");
            return true;
        }
        ExpVector ei = A.leadingExpVector();
        ExpVector g = ei.sum(ej = B.leadingExpVector());
        ExpVector h = g.subtract(e = ei.lcm(ej));
        int s = h.signum();
        return s != 0 || !(d = (a = A.leadingBaseCoefficient()).gcd(b = B.leadingBaseCoefficient())).isONE();
    }

    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> row, List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        throw new UnsupportedOperationException("not jet implemented");
    }

    @Override
    public List<GenPolynomial<C>> irreducibleSet(List<GenPolynomial<C>> Pp) {
        ArrayList<GenPolynomial<C>> P = new ArrayList<GenPolynomial<C>>();
        if (Pp == null) {
            return null;
        }
        for (GenPolynomial<C> a : Pp) {
            if (a.isZERO()) continue;
            P.add(a);
        }
        int l = P.size();
        if (l <= 1) {
            return P;
        }
        int irr = 0;
        logger.debug((Object)"irr = ");
        while (irr != l) {
            GenPolynomial<C> a = P.remove(0);
            ExpVector e = a.leadingExpVector();
            a = this.normalform(P, a);
            logger.debug((Object)String.valueOf(irr));
            if (a.isZERO()) {
                if (--l > 1) continue;
                return P;
            }
            ExpVector f = a.leadingExpVector();
            irr = e.equals(f) ? ++irr : 0;
            P.add(a);
        }
        return P;
    }
}

