/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.DReductionSeq;
import edu.jas.gb.EReduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class EReductionSeq<C extends RingElem<C>>
extends DReductionSeq<C>
implements EReduction<C> {
    private static final Logger logger = Logger.getLogger(DReductionSeq.class);

    @Override
    public boolean isTopReducible(List<GenPolynomial<C>> P, GenPolynomial<C> A) {
        if (P == null || P.isEmpty()) {
            return false;
        }
        if (A == null || A.isZERO()) {
            return false;
        }
        boolean mt = false;
        ExpVector e = A.leadingExpVector();
        C a = A.leadingBaseCoefficient();
        for (GenPolynomial<C> p : P) {
            mt = e.multipleOf(p.leadingExpVector());
            if (!mt) continue;
            C b = p.leadingBaseCoefficient();
            RingElem r = (RingElem)a.remainder(b);
            boolean bl = mt = !r.equals(a);
            if (!mt) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        GenPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        if (Ap == null || Ap.isZERO()) {
            return true;
        }
        List<GenPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenPolynomial[l];
            int i = 0;
            while (i < Pp.size()) {
                P[i] = Pp.get(i);
                ++i;
            }
        }
        ExpVector[] htl = new ExpVector[l];
        RingElem[] lbc = new RingElem[l];
        GenPolynomial[] p = new GenPolynomial[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            p[i] = P[i];
            Map.Entry m = p[i].leadingMonomial();
            if (m != null) {
                p[j] = p[i];
                htl[j] = m.getKey();
                lbc[j] = (RingElem)m.getValue();
                ++j;
            }
            ++i;
        }
        l = j;
        boolean mt = false;
        SortedMap<ExpVector, C> Am = Ap.getMap();
        for (ExpVector e : Am.keySet()) {
            i = 0;
            while (i < l) {
                mt = e.multipleOf(htl[i]);
                if (mt) {
                    RingElem a = (RingElem)Am.get(e);
                    RingElem r = a.remainder(lbc[i]);
                    boolean bl = mt = !r.equals(a);
                    if (mt) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        Map.Entry m;
        GenPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        List<GenPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenPolynomial[l];
            int i = 0;
            while (i < Pp.size()) {
                P[i] = Pp.get(i).abs();
                ++i;
            }
        }
        ExpVector[] htl = new ExpVector[l];
        RingElem[] lbc = new RingElem[l];
        GenPolynomial[] p = new GenPolynomial[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            p[i] = P[i];
            m = p[i].leadingMonomial();
            if (m != null) {
                p[j] = p[i];
                htl[j] = m.getKey();
                lbc[j] = (RingElem)m.getValue();
                ++j;
            }
            ++i;
        }
        l = j;
        ExpVector e = null;
        ExpVector f = null;
        RingElem a = null;
        RingElem b = null;
        RingElem r = null;
        GenPolynomial<RingElem> R = Ap.ring.getZERO();
        AbelianGroupElem T = Ap.ring.getZERO();
        GenPolynomial<RingElem> Q = null;
        GenPolynomial<GenPolynomial<RingElem>> S = Ap;
        try {
            while (S.length() > 0) {
                boolean mt = false;
                m = S.leadingMonomial();
                e = m.getKey();
                a = (RingElem)m.getValue();
                i = 0;
                while (i < l) {
                    mt = e.multipleOf(htl[i]);
                    if (mt) {
                        f = e.subtract(htl[i]);
                        r = a.remainder(lbc[i]);
                        b = a.divide(lbc[i]);
                        if (f == null) {
                            System.out.println("f = null: " + e + ", " + htl[i]);
                            Q = p[i].multiply(b);
                        } else {
                            Q = p[i].multiply(b, f);
                        }
                        S = S.subtract(Q);
                        a = r;
                        if (r.isZERO()) break;
                    }
                    ++i;
                }
                if (a.isZERO()) continue;
                R = R.sum(a, e);
                S = S.reductum();
            }
        }
        catch (Exception ex) {
            System.out.println("R = " + R);
            System.out.println("S = " + S);
            System.out.println("f = " + f + ", " + e + ", " + htl[i]);
            System.out.println("a = " + a + ", " + b + ", " + r + ", " + lbc[i]);
            return T;
        }
        return R.abs();
    }

    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> row, List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        throw new UnsupportedOperationException("not jet implemented");
    }

    @Override
    public List<GenPolynomial<C>> irreducibleSet(List<GenPolynomial<C>> Pp) {
        ArrayList<GenPolynomial<C>> P = new ArrayList<GenPolynomial<C>>();
        if (Pp == null) {
            return null;
        }
        for (GenPolynomial<C> a : Pp) {
            if (a.isZERO()) continue;
            P.add(a);
        }
        int l = P.size();
        if (l <= 1) {
            return P;
        }
        int irr = 0;
        logger.debug((Object)"irr = ");
        while (irr != l) {
            GenPolynomial<C> a = P.remove(0);
            ExpVector e = a.leadingExpVector();
            C c = a.leadingBaseCoefficient();
            a = this.normalform(P, a);
            logger.debug((Object)String.valueOf(irr));
            if (a.isZERO()) {
                if (--l > 1) continue;
                return P;
            }
            ExpVector f = a.leadingExpVector();
            C d = a.leadingBaseCoefficient();
            irr = e.equals(f) && c.equals(d) ? ++irr : 0;
            P.add(a);
        }
        return P;
    }
}

