/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.gb.GBFactory;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class Examples {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        Examples.exampleGB();
    }

    public static void example1() {
    }

    public static void example2() {
    }

    public static void example3() {
        String[] vars = new String[]{"v3", "v2", "v1"};
        ModIntegerRing z2 = new ModIntegerRing(2L);
        GenPolynomialRing<ModInteger> z2p = new GenPolynomialRing<ModInteger>(z2, vars.length, new TermOrder(2), vars);
        ArrayList<GenPolynomial<GenPolynomial<ModInteger>>> fieldPolynomials = new ArrayList<GenPolynomial<GenPolynomial<ModInteger>>>();
        int i = 0;
        while (i < vars.length) {
            GenPolynomial<ModInteger> var = z2p.univariate(i);
            fieldPolynomials.add(var.multiply((ModInteger)((Object)var)).sum(var));
            ++i;
        }
        ArrayList polynomials = new ArrayList();
        GenPolynomial<ModInteger> v1 = z2p.univariate(0);
        GenPolynomial<ModInteger> v2 = z2p.univariate(1);
        GenPolynomial<ModInteger> v3 = z2p.univariate(2);
        GenPolynomial notV1 = v1.sum((ModInteger)((Object)z2p.ONE));
        GenPolynomial notV2 = v2.sum((ModInteger)((Object)z2p.ONE));
        GenPolynomial notV3 = v3.sum((ModInteger)((Object)z2p.ONE));
        GenPolynomial<GenPolynomial<ModInteger>> p1 = v1.multiply((ModInteger)((Object)v2));
        GenPolynomial p2 = notV1.multiply(notV2);
        GenPolynomial p3 = notV1.multiply(notV3);
        polynomials.add(p1);
        polynomials.add(p2);
        polynomials.add(p3);
        polynomials.addAll(fieldPolynomials);
        GroebnerBaseAbstract<ModInteger> gb = GBFactory.getImplementation(z2);
        List G = gb.GB(polynomials);
        System.out.println(G);
    }

    public static void exampleGB1() {
        BigRational coeff = new BigRational();
        GroebnerBaseAbstract<BigRational> gb = GBFactory.getImplementation(coeff);
        String exam = "(x1,x2,y) G ( ( x1 + x2 - 10 ), ( 2 x1 - x2 + 4 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        PolynomialList F2 = null;
        try {
            F2 = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("F = " + F2);
        List G = gb.GB(F2.list);
        PolynomialList trinks = new PolynomialList(F2.ring, G);
        System.out.println("G = " + trinks);
    }

    public static void exampleGB() {
        BigRational coeff = new BigRational();
        GroebnerBaseAbstract<BigRational> gb = GBFactory.getImplementation(coeff);
        String exam = "(x,y) G ( ( y - ( x^2 - 1 ) ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        PolynomialList F2 = null;
        try {
            F2 = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("F = " + F2);
        List G = gb.GB(F2.list);
        PolynomialList trinks = new PolynomialList(F2.ring, G);
        System.out.println("G = " + trinks);
    }

    public static void exampleGBTrinks() {
        BigRational coeff = new BigRational();
        GroebnerBaseAbstract<BigRational> bb = GBFactory.getImplementation(coeff);
        String exam = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        PolynomialList F2 = null;
        try {
            F2 = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("F = " + F2);
        List G = bb.GB(F2.list);
        PolynomialList trinks = new PolynomialList(F2.ring, G);
        System.out.println("G = " + trinks);
    }
}

