/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBClient;
import edu.jas.gb.GroebnerBaseDistributed;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistThreadPool;
import java.util.List;

public class GBDist<C extends RingElem<C>> {
    private final String mfile;
    protected final int threads;
    protected final int port;
    private final GroebnerBaseDistributed<C> bbd;
    private final DistThreadPool dtp;

    public GBDist(int threads, String mfile, int port) {
        this.threads = threads;
        this.mfile = mfile == null || mfile.length() == 0 ? "../util/machines" : mfile;
        this.port = port;
        this.bbd = new GroebnerBaseDistributed(threads, port);
        this.dtp = new DistThreadPool(threads, mfile);
    }

    public List<GenPolynomial<C>> execute(List<GenPolynomial<C>> F2) {
        String master = this.dtp.getEC().getMasterHost();
        int port = this.dtp.getEC().getMasterPort();
        GBClient gbc = new GBClient(master, port);
        int i = 0;
        while (i < this.threads) {
            this.dtp.addJob(gbc);
            ++i;
        }
        List<GenPolynomial<C>> G = this.bbd.GB(F2);
        return G;
    }

    public void terminate(boolean shutDown) {
        this.bbd.terminate();
        this.dtp.terminate(shutDown);
    }
}

