/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBClientHybrid;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistThreadPool;
import java.util.List;

public class GBDistHybrid<C extends RingElem<C>> {
    private final String mfile;
    protected final int threads;
    protected final int threadsPerNode;
    protected final int port;
    private final GroebnerBaseDistributedHybrid<C> bbd;
    private final DistThreadPool dtp;

    public GBDistHybrid(int threads, int threadsPerNode, String mfile, int port) {
        this.threads = threads;
        this.threadsPerNode = threadsPerNode;
        this.mfile = mfile == null || mfile.length() == 0 ? "../util/machines" : mfile;
        this.port = port;
        this.bbd = new GroebnerBaseDistributedHybrid(threads, threadsPerNode, port);
        this.dtp = new DistThreadPool(threads, mfile);
    }

    public List<GenPolynomial<C>> execute(List<GenPolynomial<C>> F2) {
        String master = this.dtp.getEC().getMasterHost();
        int port = this.dtp.getEC().getMasterPort();
        GBClientHybrid gbc = new GBClientHybrid(this.threadsPerNode, master, port);
        int i = 0;
        while (i < this.threads) {
            this.dtp.addJob(gbc);
            ++i;
        }
        List<GenPolynomial<C>> G = this.bbd.GB(F2);
        return G;
    }

    public void terminate(boolean shutDown) {
        this.bbd.terminate();
        this.dtp.terminate(shutDown);
    }
}

