/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.DGroebnerBaseSeq;
import edu.jas.gb.EGroebnerBaseSeq;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBasePseudoRecSeq;
import edu.jas.gb.GroebnerBasePseudoSeq;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.RGroebnerBasePseudoSeq;
import edu.jas.gb.RGroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import org.apache.log4j.Logger;

public class GBFactory {
    private static final Logger logger = Logger.getLogger(GBFactory.class);

    protected GBFactory() {
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getImplementation() {
        logger.warn((Object)"no coefficent factory given, assuming field coeffcients");
        GroebnerBaseSeq bba = new GroebnerBaseSeq();
        return bba;
    }

    public static GroebnerBaseAbstract<ModLong> getImplementation(ModLongRing fac) {
        GroebnerBaseAbstract bba = fac.isField() ? new GroebnerBaseSeq() : new GroebnerBasePseudoSeq<ModLong>(fac);
        return bba;
    }

    public static GroebnerBaseAbstract<ModInteger> getImplementation(ModIntegerRing fac) {
        GroebnerBaseAbstract bba = fac.isField() ? new GroebnerBaseSeq() : new GroebnerBasePseudoSeq<ModInteger>(fac);
        return bba;
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger fac) {
        return GBFactory.getImplementation(fac, Algo.igb);
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger fac, Algo a) {
        EGroebnerBaseSeq<BigInteger> bba;
        switch (a) {
            case igb: {
                bba = new GroebnerBasePseudoSeq<BigInteger>(fac);
                break;
            }
            case egb: {
                bba = new EGroebnerBaseSeq();
                break;
            }
            case dgb: {
                bba = new DGroebnerBaseSeq();
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available " + (Object)((Object)a));
            }
        }
        return bba;
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational fac) {
        GroebnerBaseSeq<BigRational> bba = new GroebnerBaseSeq<BigRational>();
        return bba;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> fac) {
        GroebnerBasePseudoRecSeq bba = new GroebnerBasePseudoRecSeq(fac);
        return bba;
    }

    public static <C extends RingElem<C>> GroebnerBaseAbstract<Product<C>> getImplementation(ProductRing<C> fac) {
        RGroebnerBaseSeq<Product<C>> bba = fac.onlyFields() ? new RGroebnerBaseSeq<Product<C>>() : new RGroebnerBasePseudoSeq<C>(fac);
        return bba;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getImplementation(RingFactory<C> fac) {
        logger.debug((Object)("fac = " + fac.getClass().getName()));
        if (fac.isField()) {
            return new GroebnerBaseSeq();
        }
        GroebnerBaseAbstract bba = null;
        RingFactory<C> ofac = fac;
        if (ofac instanceof GenPolynomialRing) {
            GroebnerBasePseudoRecSeq bbr = new GroebnerBasePseudoRecSeq((GenPolynomialRing)ofac);
            bba = bbr;
        } else {
            ProductRing pfac;
            bba = ofac instanceof ProductRing ? ((pfac = (ProductRing)ofac).onlyFields() ? new RGroebnerBaseSeq() : new RGroebnerBasePseudoSeq(pfac)) : new GroebnerBasePseudoSeq<C>(fac);
        }
        logger.debug((Object)("bba = " + bba.getClass().getName()));
        return bba;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getProxy(RingFactory<C> fac) {
        logger.debug((Object)("fac = " + fac.getClass().getName()));
        if (fac.isField()) {
            if (ComputerThreads.NO_THREADS) {
                return new GroebnerBaseSeq();
            }
            GroebnerBaseSeq e1 = new GroebnerBaseSeq();
            GroebnerBaseParallel e2 = new GroebnerBaseParallel(ComputerThreads.N_CPUS);
            return new GBProxy(e1, e2);
        }
        GroebnerBaseAbstract bba = null;
        RingFactory<C> ofac = fac;
        if (ofac instanceof GenPolynomialRing) {
            GroebnerBasePseudoRecSeq bbr = new GroebnerBasePseudoRecSeq((GenPolynomialRing)ofac);
            bba = bbr;
        } else {
            ProductRing pfac;
            bba = ofac instanceof ProductRing ? ((pfac = (ProductRing)ofac).onlyFields() ? new RGroebnerBaseSeq() : new RGroebnerBasePseudoSeq(pfac)) : new GroebnerBasePseudoSeq<C>(fac);
        }
        logger.debug((Object)("bba = " + bba.getClass().getName()));
        return bba;
    }

    public static enum Algo {
        igb,
        egb,
        dgb;

    }
}

