/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.GBFactory;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBasePseudoRecSeq;
import edu.jas.gb.GroebnerBasePseudoSeq;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.RGroebnerBasePseudoSeq;
import edu.jas.gb.RGroebnerBaseSeq;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GBFactoryTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GBFactoryTest.suite());
    }

    public GBFactoryTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GBFactoryTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBigInteger() {
        BigInteger bi = new BigInteger();
        GroebnerBaseAbstract<BigInteger> bba = GBFactory.getImplementation(bi);
        GBFactoryTest.assertTrue((String)("bba integer " + bba), (boolean)(bba instanceof GroebnerBasePseudoSeq));
    }

    public void testModInteger() {
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        GroebnerBaseAbstract<ModInteger> bba = GBFactory.getImplementation(mi);
        GBFactoryTest.assertTrue((String)("bba modular field " + bba), (boolean)(bba instanceof GroebnerBaseSeq));
        mi = new ModIntegerRing(30L);
        bba = GBFactory.getImplementation(mi);
        GBFactoryTest.assertTrue((String)("bba modular ring " + bba), (boolean)(bba instanceof GroebnerBasePseudoSeq));
    }

    public void testBigRational() {
        BigRational b = new BigRational();
        GroebnerBaseAbstract<BigRational> bba = GBFactory.getImplementation(b);
        GBFactoryTest.assertTrue((String)("bba field " + bba), (boolean)(bba instanceof GroebnerBaseSeq));
    }

    public void testBigComplex() {
        BigComplex b = new BigComplex();
        GroebnerBaseAbstract<BigComplex> bba = GBFactory.getImplementation(b);
        GBFactoryTest.assertTrue((String)("bba field " + bba), (boolean)(bba instanceof GroebnerBaseSeq));
    }

    public void testAlgebraicNumberBigRational() {
        BigRational b = new BigRational();
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(b, 1);
        GenPolynomial<BigRational> mo = fac.random(this.kl, this.ll, this.el, this.q);
        while (mo.isZERO() || mo.isONE() || mo.isConstant()) {
            mo = fac.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(mo);
        GroebnerBaseAbstract<BigRational> bba = GBFactory.getImplementation(afac);
        GBFactoryTest.assertTrue((String)("bba algebraic ring " + bba), (boolean)(bba instanceof GroebnerBasePseudoSeq));
        mo = fac.univariate(0).subtract((BigRational)fac.getONE());
        afac = new AlgebraicNumberRing<BigRational>(mo, true);
        bba = GBFactory.getImplementation(afac);
        GBFactoryTest.assertTrue((String)("bba algebraic field " + bba), (boolean)(bba instanceof GroebnerBaseSeq));
    }

    public void testAlgebraicNumberModInteger() {
        ModIntegerRing b = new ModIntegerRing(19L, true);
        GenPolynomialRing<ModInteger> fac = new GenPolynomialRing<ModInteger>(b, 1);
        GenPolynomial<ModInteger> mo = fac.random(this.kl, this.ll, this.el, this.q);
        while (mo.isZERO() || mo.isONE() || mo.isConstant()) {
            mo = fac.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<ModInteger> afac = new AlgebraicNumberRing<ModInteger>(mo);
        MonoidElem a = afac.getONE();
        GroebnerBaseAbstract<ModInteger> bba = GBFactory.getImplementation(afac);
        GBFactoryTest.assertTrue((String)("bba algebraic ring " + bba), (boolean)(bba instanceof GroebnerBasePseudoSeq));
    }

    public void testGenPolynomial() {
        GenPolynomialRing<BigRational> fac;
        BigRational b = new BigRational();
        GenPolynomialRing<BigRational> rf = fac = new GenPolynomialRing<BigRational>(b, this.rl, this.to);
        GroebnerBaseAbstract<GenPolynomial<BigRational>> bba = GBFactory.getImplementation(fac);
        GBFactoryTest.assertTrue((String)("bba recursive polynomial " + bba), (boolean)(bba instanceof GroebnerBasePseudoRecSeq));
        GroebnerBaseAbstract<BigRational> bb = GBFactory.getImplementation(rf);
        GBFactoryTest.assertTrue((String)("bba recursive polynomial " + bb), (boolean)(bb instanceof GroebnerBasePseudoRecSeq));
    }

    public void testProduct() {
        ProductRing<ModInteger> fac;
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        ProductRing<ModInteger> rf = fac = new ProductRing<ModInteger>(mi, 3);
        GroebnerBaseAbstract<Product<ModInteger>> bba = GBFactory.getImplementation(fac);
        GBFactoryTest.assertTrue((String)("bba product " + bba), (boolean)(bba instanceof RGroebnerBaseSeq));
        mi = new ModIntegerRing(30L);
        rf = fac = new ProductRing<ModInteger>(mi, 3);
        GroebnerBaseAbstract<ModInteger> bb = GBFactory.getImplementation(rf);
        GBFactoryTest.assertTrue((String)("bba product " + bb), (boolean)(bb instanceof RGroebnerBasePseudoSeq));
    }

    public void testProxy() {
        BigRational b = new BigRational();
        GroebnerBaseAbstract<BigRational> bba = GBFactory.getProxy(b);
        GBFactoryTest.assertTrue((String)("bba field " + bba), (boolean)(bba instanceof GBProxy));
        bba.terminate();
        ModIntegerRing m = new ModIntegerRing(6L);
        GroebnerBaseAbstract<ModInteger> bbm = GBFactory.getProxy(m);
        GBFactoryTest.assertTrue((String)("bbm ! field " + bbm), (!(bbm instanceof GBProxy) ? 1 : 0) != 0);
        bbm.terminate();
    }
}

