/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import edu.jas.vector.BasicLinAlg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public abstract class GroebnerBaseAbstract<C extends RingElem<C>>
implements GroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public final Reduction<C> red;
    public final BasicLinAlg<C> blas;

    public GroebnerBaseAbstract() {
        this(new ReductionSeq());
    }

    public GroebnerBaseAbstract(Reduction<C> red) {
        this.red = red;
        this.blas = new BasicLinAlg();
    }

    @Override
    public boolean isGB(List<GenPolynomial<C>> F2) {
        return this.isGB(0, F2);
    }

    @Override
    public boolean isGB(int modv, List<GenPolynomial<C>> F2) {
        if (F2 == null) {
            return true;
        }
        int i = 0;
        while (i < F2.size()) {
            GenPolynomial<C> pi = F2.get(i);
            int j = i + 1;
            while (j < F2.size()) {
                GenPolynomial<C> h;
                GenPolynomial<C> s;
                GenPolynomial<C> pj = F2.get(j);
                if (this.red.moduleCriterion(modv, pi, pj) && this.red.criterion4(pi, pj) && !(s = this.red.SPolynomial(pi, pj)).isZERO() && !(h = this.red.normalform(F2, s)).isZERO()) {
                    System.out.println("pi = " + pi + ", pj = " + pj);
                    System.out.println("s  = " + s + ", h = " + h);
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int commonZeroTest(List<GenPolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return 1;
        }
        GenPolynomialRing pfac = F2.get((int)0).ring;
        if (pfac.nvar <= 0) {
            return -1;
        }
        HashSet<Integer> v = new HashSet<Integer>();
        for (GenPolynomial<C> p : F2) {
            int[] u;
            ExpVector e = p.leadingExpVector();
            if (e == null || (u = e.dependencyOnVariables()) == null || u.length != 1) continue;
            v.add(u[0]);
        }
        if (pfac.nvar == v.size()) {
            return 0;
        }
        return 1;
    }

    @Override
    public List<GenPolynomial<C>> GB(List<GenPolynomial<C>> F2) {
        return this.GB(0, F2);
    }

    @Override
    public ExtendedGB<C> extGB(List<GenPolynomial<C>> F2) {
        return this.extGB(0, F2);
    }

    @Override
    public ExtendedGB<C> extGB(int modv, List<GenPolynomial<C>> F2) {
        throw new UnsupportedOperationException("extGB not implemented in " + this.getClass().getSimpleName());
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Gp) {
        GenPolynomial<C> a2;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Gp.size());
        for (GenPolynomial<C> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a2 = (GenPolynomial<C>)G.remove(0);
            if (this.red.isTopReducible(G, a2) || this.red.isTopReducible(F2, a2)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a2);
                ArrayList<GenPolynomial<C>> ff = new ArrayList<GenPolynomial<C>>(G);
                ff.addAll(F2);
                a2 = this.red.normalform(ff, a2);
                if (a2.isZERO()) continue;
                System.out.println("error, nf(a) " + a2);
                continue;
            }
            F2.add(a2);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        int len = G.size();
        int i = 0;
        while (i < len) {
            a2 = (GenPolynomial)G.remove(0);
            a2 = this.red.normalform(G, a2);
            G.add(a2);
            ++i;
        }
        return G;
    }

    @Override
    public boolean isReductionMatrix(ExtendedGB<C> exgb) {
        if (exgb == null) {
            return true;
        }
        return this.isReductionMatrix(exgb.F, exgb.G, exgb.F2G, exgb.G2F);
    }

    @Override
    public boolean isReductionMatrix(List<GenPolynomial<C>> F2, List<GenPolynomial<C>> G, List<List<GenPolynomial<C>>> Mf, List<List<GenPolynomial<C>>> Mg) {
        boolean t;
        int k = 0;
        for (List<GenPolynomial<C>> row : Mg) {
            t = this.red.isReductionNF(row, F2, G.get(k), null);
            if (!t) {
                logger.error((Object)("F isReductionMatrix s, k = " + F2.size() + ", " + k));
                return false;
            }
            ++k;
        }
        k = 0;
        for (List<GenPolynomial<C>> row : Mf) {
            t = this.red.isReductionNF(row, G, F2.get(k), null);
            if (!t) {
                logger.error((Object)("G isReductionMatrix s, k = " + G.size() + ", " + k));
                return false;
            }
            ++k;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public List<List<GenPolynomial<C>>> normalizeMatrix(int flen, List<List<GenPolynomial<C>>> M) {
        void var7_8;
        if (M == null) {
            return M;
        }
        if (M.size() == 0) {
            return M;
        }
        ArrayList<List<GenPolynomial<Object>>> N2 = new ArrayList<List<GenPolynomial<Object>>>();
        ArrayList<List<GenPolynomial<C>>> K = new ArrayList<List<GenPolynomial<C>>>();
        int len = M.get(M.size() - 1).size();
        for (List<GenPolynomial<C>> row : M) {
            ArrayList<GenPolynomial<C>> nrow = new ArrayList<GenPolynomial<C>>(row);
            int i = row.size();
            while (i < len) {
                nrow.add(null);
                ++i;
            }
            N2.add(nrow);
        }
        int k = flen;
        boolean bl = false;
        while (var7_8 < N2.size()) {
            List row = (List)N2.get((int)var7_8);
            if (this.debug) {
                logger.info((Object)("row = " + row));
            }
            K.add(row);
            if (var7_8 >= flen) {
                void j = var7_8 + true;
                while (j < N2.size()) {
                    GenPolynomial a;
                    List nrow = (List)N2.get((int)j);
                    if (k < nrow.size() && (a = (GenPolynomial)nrow.get(k)) != null && !a.isZERO()) {
                        List<GenPolynomial<C>> xrow = this.blas.scalarProduct(a, row);
                        xrow = this.blas.vectorAdd(xrow, nrow);
                        N2.set((int)j, xrow);
                    }
                    ++j;
                }
                ++k;
            }
            ++var7_8;
        }
        N2.clear();
        for (List list : K) {
            ArrayList<GenPolynomial> tr = new ArrayList<GenPolynomial>();
            int i2 = 0;
            while (i2 < flen) {
                tr.add((GenPolynomial)list.get(i2));
                ++i2;
            }
            N2.add(tr);
        }
        K = N2;
        return K;
    }

    public ExtendedGB<C> minimalExtendedGB(int flen, List<GenPolynomial<C>> Gp, List<List<GenPolynomial<C>>> M) {
        List<GenPolynomial<Object>> row;
        if (Gp == null) {
            return null;
        }
        if (Gp.size() <= 1) {
            return new ExtendedGB<C>(null, Gp, null, M);
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Gp);
        ArrayList F2 = new ArrayList(Gp.size());
        ArrayList<ArrayList<GenPolynomial<C>>> Mg = new ArrayList<ArrayList<GenPolynomial<C>>>(M.size());
        ArrayList Mf = new ArrayList(M.size());
        for (List<GenPolynomial<C>> r : M) {
            row = new ArrayList<GenPolynomial<C>>(r);
            Mg.add((ArrayList<GenPolynomial<C>>)row);
        }
        row = null;
        ArrayList<Integer> ix = new ArrayList<Integer>();
        ArrayList<Integer> jx = new ArrayList<Integer>();
        int k = 0;
        while (G.size() > 0) {
            ExpVector f;
            GenPolynomial p;
            GenPolynomial a = (GenPolynomial)G.remove(0);
            ExpVector e = a.leadingExpVector();
            ListIterator it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = (GenPolynomial)it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F2.listIterator();
            while (it.hasNext() && !mt) {
                p = (GenPolynomial)it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (!mt) {
                F2.add(a);
                ix.add(k);
            } else {
                jx.add(k);
            }
            ++k;
        }
        if (this.debug) {
            logger.debug((Object)("ix, #M, jx = " + ix + ", " + Mg.size() + ", " + jx));
        }
        int fix = -1;
        int i = 0;
        while (i < ix.size()) {
            int u = (Integer)ix.get(i);
            if (u >= flen && fix == -1) {
                fix = Mf.size();
            }
            if (u >= 0) {
                row = (List)Mg.get(u);
                Mf.add(row);
            }
            ++i;
        }
        if (F2.size() <= 1 || fix == -1) {
            return new ExtendedGB(null, F2, null, Mf);
        }
        return new ExtendedGB(null, F2, null, Mf);
    }

    public void terminate() {
        logger.info((Object)"terminate not implemented");
    }

    public int cancel() {
        logger.info((Object)"cancel not implemented");
        return 0;
    }
}

