/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseDistributed;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.JunitClientHybrid;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBaseDistHybridTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBase<BigRational> bbseq;
    GroebnerBaseDistributed<BigRational> bbdist;
    GroebnerBaseDistributedHybrid<BigRational> bbdisthyb;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 4;
    int ll = 7;
    int el = 3;
    float q = 0.2f;
    int threads = 2;
    int threadsPerNode = 2;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBaseDistHybridTest.suite());
    }

    public GroebnerBaseDistHybridTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GroebnerBaseDistHybridTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational coeff = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bbseq = new GroebnerBaseSeq<BigRational>();
        this.bbdist = null;
        this.bbdisthyb = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bbseq = null;
        this.bbdist = null;
        this.bbdisthyb.terminate();
        this.bbdisthyb = null;
        ComputerThreads.terminate();
    }

    Thread[] startThreads() {
        Thread[] clients = new Thread[this.threads];
        int t = 0;
        while (t < this.threads) {
            clients[t] = new Thread(new JunitClientHybrid(this.threadsPerNode, this.host, this.port));
            clients[t].start();
            ++t;
        }
        return clients;
    }

    /*
     * Exception decompiling
     */
    void stopThreads(Thread[] clients) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testDistributedHybridGBase() {
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Thread[] clients = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        clients = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        clients = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        clients = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        clients = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bbseq.isGB(this.L));
    }

    public void testTrinks7GBase() {
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        String exam = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GroebnerBaseDistHybridTest.fail((String)("" + e));
        }
        Thread[] clients = this.startThreads();
        this.G = this.bbdisthyb.GB(this.F.list);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistHybridTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        PolynomialList trinks = new PolynomialList(this.F.ring, this.G);
    }

    public void testTrinks7GBase_t1_p4() {
        this.threads = 1;
        this.threadsPerNode = 4;
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        String exam = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GroebnerBaseDistHybridTest.fail((String)("" + e));
        }
        Thread[] clients = this.startThreads();
        this.G = this.bbdisthyb.GB(this.F.list);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistHybridTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        PolynomialList trinks = new PolynomialList(this.F.ring, this.G);
    }

    public void testTrinks7GBase_t4_p1() {
        this.threads = 4;
        this.threadsPerNode = 1;
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        String exam = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GroebnerBaseDistHybridTest.fail((String)("" + e));
        }
        Thread[] clients = this.startThreads();
        this.G = this.bbdisthyb.GB(this.F.list);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistHybridTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        PolynomialList trinks = new PolynomialList(this.F.ring, this.G);
    }

    public void testTrinks7GBase_t2_p2() {
        this.threads = 2;
        this.threadsPerNode = 4;
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        String exam = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GroebnerBaseDistHybridTest.fail((String)("" + e));
        }
        Thread[] clients = this.startThreads();
        this.G = this.bbdisthyb.GB(this.F.list);
        this.stopThreads(clients);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistHybridTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        PolynomialList trinks = new PolynomialList(this.F.ring, this.G);
    }
}

