/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBasePartial;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.util.KsubSet;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBasePartTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBase<BigRational> bb;
    GroebnerBasePartial<BigRational> bbp;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBasePartTest.suite());
    }

    public GroebnerBasePartTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GroebnerBasePartTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational coeff = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBaseSeq<BigRational>();
        this.bbp = new GroebnerBasePartial();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
        ComputerThreads.terminate();
    }

    public void testTrinks7GBasePartRec() {
        String exam = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        catch (IOException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        OptimizedPolynomialList<GenPolynomial<BigRational>> rtrinks = this.bbp.partialGBrec(this.F.list, new String[]{"P", "Z", "T", "W"});
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGBrec(rtrinks.list));
        OptimizedPolynomialList<BigRational> trinks = this.bbp.partialGB(this.F.list, new String[]{"P", "Z", "T", "W"});
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGB(trinks.list));
    }

    public void testTrinks7GBasePart() {
        String exam = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        catch (IOException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        OptimizedPolynomialList<BigRational> trinks = this.bbp.partialGB(this.F.list, new String[]{"B", "S", "P", "Z", "T", "W"});
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGB(trinks.list));
        try {
            OptimizedPolynomialList<GenPolynomial<BigRational>> tr = this.bbp.partialGBrec(this.F.list, new String[]{"B", "S", "P", "Z", "T", "W"});
            GroebnerBasePartTest.fail((String)"must throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPartialPermutation() {
        String[] vars = new String[]{"B", "S", "T", "Z", "P", "W"};
        String[] pvars = new String[]{"P", "Z", "T", "W"};
        String[] rvars = new String[]{"S", "B"};
        List<Integer> perm1 = GroebnerBasePartial.partialPermutation(vars, pvars);
        List<Integer> perm2 = GroebnerBasePartial.partialPermutation(vars, pvars, null);
        GroebnerBasePartTest.assertEquals((String)"perm1 == perm2 ", perm1, perm2);
        List<Integer> perm3 = GroebnerBasePartial.partialPermutation(vars, pvars, rvars);
        GroebnerBasePartTest.assertFalse((String)"perm1 != perm3 ", (boolean)perm1.equals(perm3));
    }

    public void xtestElimPartialPermutation() {
        String[] vars = new String[]{"B", "S", "T", "Z", "P", "W"};
        String[] evars = new String[]{"P", "Z"};
        String[] pvars = new String[]{"T", "W"};
        String[] rvars = new String[]{"B", "S"};
        List<Integer> perm1 = GroebnerBasePartial.partialPermutation(vars, evars, pvars, rvars);
        System.out.println("perm1 = " + perm1);
        List<Integer> perm2 = GroebnerBasePartial.partialPermutation(vars, evars, pvars, null);
        System.out.println("perm2 = " + perm2);
        GroebnerBasePartTest.assertEquals((String)"perm1 == perm2 ", perm1, perm2);
        rvars = new String[]{"S", "B"};
        List<Integer> perm3 = GroebnerBasePartial.partialPermutation(vars, evars, pvars, rvars);
        System.out.println("perm3 = " + perm3);
        GroebnerBasePartTest.assertFalse((String)"perm1 != perm3 ", (boolean)perm1.equals(perm3));
    }

    public void testTrinks7GBaseElimPart() {
        String exam = "(B,S,T,Z,P,W) G ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        catch (IOException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        String[] evars = new String[]{"P", "Z"};
        String[] pvars = new String[]{"B", "S", "T", "W"};
        OptimizedPolynomialList<BigRational> trinks = this.bbp.elimPartialGB(this.F.list, evars, pvars);
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGB(trinks.list));
    }

    public void testGBasePart() {
        String exam = "(a,b,c,d,e,f) G ( ( a ), ( b^2 ), ( c^3 ), ( d^4 ), ( e^5 ), ( f^6 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        catch (IOException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        String[] evars = new String[]{"a", "b"};
        OptimizedPolynomialList<BigRational> G = this.bbp.partialGB(this.F.list, evars);
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(G) )", (boolean)this.bbp.isGB(G.list));
    }

    public void testPermGen() {
        String[] vars = new String[]{"a", "b", "c", "d", "e", "f"};
        ArrayList<String> sv = new ArrayList<String>(vars.length);
        int i = 0;
        while (i < vars.length) {
            sv.add(vars[i]);
            ++i;
        }
        String exam = "(a,b,c,d,e,f) G ( ( a ), ( b^2 ), ( c^3 ), ( d^4 ), ( e^5 ), ( f^6 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        PolynomialList F2 = null;
        try {
            F2 = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        catch (IOException e) {
            GroebnerBasePartTest.fail((String)("" + e));
        }
        int i2 = 0;
        while (i2 <= vars.length) {
            KsubSet ps = new KsubSet(sv, i2);
            for (List ev : ps) {
                Object[] evars = new String[ev.size()];
                int j = 0;
                while (j < ev.size()) {
                    evars[j] = (String)ev.get(j);
                    ++j;
                }
                String[] rvars = GroebnerBasePartial.remainingVars(vars, (String[])evars);
                List<Integer> perm1 = GroebnerBasePartial.partialPermutation(vars, (String[])evars);
                List<Integer> perm2 = GroebnerBasePartial.getPermutation(vars, rvars);
                GroebnerBasePartTest.assertEquals((String)("perm1 == perm2 " + Arrays.toString(evars)), perm1, perm2);
                GenPolynomialRing r = new GenPolynomialRing(this.fac.coFac, vars);
                GenPolynomialRing pr1 = TermOrderOptimization.permutation(perm1, r);
                GenPolynomialRing pr2 = TermOrderOptimization.permutation(perm2, r);
                GroebnerBasePartTest.assertEquals((String)"pr1 == pr2 ", pr1, pr2);
                List pF1 = TermOrderOptimization.permutation(perm1, pr1, F2.list);
                List pF2 = TermOrderOptimization.permutation(perm2, pr2, F2.list);
                GroebnerBasePartTest.assertEquals((String)"pF1 == pF2 ", pF1, pF2);
            }
            ++i2;
        }
    }
}

