/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PseudoReduction;
import edu.jas.gb.PseudoReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBasePseudoSeq<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePseudoSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> red;
    protected final RingFactory<C> cofac;

    public GroebnerBasePseudoSeq(RingFactory<C> rf) {
        this(new PseudoReductionSeq(), rf);
    }

    public GroebnerBasePseudoSeq(PseudoReduction<C> red, RingFactory<C> rf) {
        super(red);
        this.red = red;
        this.cofac = rf;
        this.engine = GCDFactory.getImplementation(rf);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        G = new ArrayList<GenPolynomial<C>>();
        pairlist = null;
        l = F.size();
        it = F.listIterator();
        while (it.hasNext()) {
            p = it.next();
            if (p.length() > 0) {
                p = this.engine.basePrimitivePart((GenPolynomial<C>)p);
                if ((p = p.abs()).isConstant()) {
                    G.clear();
                    G.add((GenPolynomial<C>)p);
                    return G;
                }
                G.add((GenPolynomial<C>)p);
                if (pairlist == null) {
                    pairlist = new OrderedPairlist<GenPolynomial<GenPolynomial<C>>>(modv, p.ring);
                }
                pairlist.put((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)p);
                continue;
            }
            --l;
        }
        if (l > 1) ** GOTO lbl54
        return G;
lbl-1000:
        // 1 sources

        {
            pair = pairlist.removeNext();
            if (pair == null) continue;
            pi = pair.pi;
            pj = pair.pj;
            S = this.red.SPolynomial(pi, pj);
            if (S.isZERO()) {
                pair.setZero();
                continue;
            }
            if (GroebnerBasePseudoSeq.logger.isDebugEnabled()) {
                GroebnerBasePseudoSeq.logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if ((H = this.red.normalform(G, S)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (GroebnerBasePseudoSeq.logger.isDebugEnabled()) {
                GroebnerBasePseudoSeq.logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            H = this.engine.basePrimitivePart((GenPolynomial<C>)H);
            if ((H = H.abs()).isConstant()) {
                G.clear();
                G.add((GenPolynomial<C>)H);
                return G;
            }
            if (GroebnerBasePseudoSeq.logger.isDebugEnabled()) {
                GroebnerBasePseudoSeq.logger.debug((Object)("H = " + H));
            }
            if (H.length() <= 0) continue;
            ++l;
            G.add((GenPolynomial<C>)H);
            pairlist.put((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)H);
lbl54:
            // 6 sources

            ** while (pairlist.hasNext())
        }
lbl55:
        // 1 sources

        GroebnerBasePseudoSeq.logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB(G);
        GroebnerBasePseudoSeq.logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Gp) {
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Gp.size());
        for (GenPolynomial<C> genPolynomial : Gp) {
            if (genPolynomial == null || genPolynomial.isZERO()) continue;
            G.add(genPolynomial);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            GenPolynomial genPolynomial = (GenPolynomial)G.remove(0);
            if (this.red.isTopReducible(G, genPolynomial) || this.red.isTopReducible(F2, genPolynomial)) {
                if (!this.debug) continue;
                System.out.println("dropped " + genPolynomial);
                ArrayList<GenPolynomial<C>> ff = new ArrayList<GenPolynomial<C>>(G);
                ff.addAll(F2);
                GenPolynomial<C> genPolynomial2 = this.red.normalform(ff, genPolynomial);
                if (genPolynomial2.isZERO()) continue;
                System.out.println("error, nf(a) " + genPolynomial2);
                continue;
            }
            F2.add(genPolynomial);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        int len = G.size();
        int i = 0;
        while (i < len) {
            GenPolynomial genPolynomial = (GenPolynomial)G.remove(0);
            GenPolynomial<C> genPolynomial4 = this.red.normalform(G, genPolynomial);
            genPolynomial4 = this.engine.basePrimitivePart(genPolynomial4);
            AbelianGroupElem abelianGroupElem = genPolynomial4.abs();
            G.add((GenPolynomial<C>)abelianGroupElem);
            ++i;
        }
        return G;
    }
}

