/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBasePseudoSeq;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBasePseudoSeqTest
extends TestCase {
    GenPolynomialRing<BigInteger> fac;
    List<GenPolynomial<BigInteger>> L;
    PolynomialList<BigInteger> F;
    List<GenPolynomial<BigInteger>> G;
    GroebnerBase<BigInteger> bb;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBasePseudoSeqTest.suite());
    }

    public GroebnerBasePseudoSeqTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GroebnerBasePseudoSeqTest.class);
        return suite;
    }

    protected void setUp() {
        BigInteger coeff = new BigInteger(9L);
        this.fac = new GenPolynomialRing<BigInteger>(coeff, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBasePseudoSeq<BigInteger>(coeff);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<BigInteger>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7GBase() {
        String exam = "Z(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( 10000 B**2 + 6600 B + 2673 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            GroebnerBasePseudoSeqTest.fail((String)("" + e));
        }
        catch (IOException e) {
            GroebnerBasePseudoSeqTest.fail((String)("" + e));
        }
        long t = System.currentTimeMillis();
        this.G = this.bb.GB(this.F.list);
        t = System.currentTimeMillis() - t;
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBasePseudoSeqTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        PolynomialList trinks = new PolynomialList(this.F.ring, this.G);
        GenPolynomialRing ifac = this.F.ring;
        BigRational cf = new BigRational();
        GenPolynomialRing<BigRational> rfac = new GenPolynomialRing<BigRational>(cf, ifac);
        List Fr = PolyUtil.fromIntegerCoefficients(rfac, this.F.list);
        GroebnerBaseSeq bbr = new GroebnerBaseSeq();
        long s = System.currentTimeMillis();
        List Gr = bbr.GB(Fr);
        s = System.currentTimeMillis() - s;
        List Gir = PolyUtil.fromIntegerCoefficients(rfac, this.G);
        Gir = PolyUtil.monic(Gir);
        GroebnerBasePseudoSeqTest.assertEquals((String)"ratGB == intGB", Gr, Gir);
    }
}

