/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.GroebnerBaseSeqPairDistributed;
import edu.jas.gb.JunitSeqPairClient;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBaseSeqPairDistTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBase<BigRational> bbseq;
    GroebnerBaseSeqPairDistributed<BigRational> bbdist;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 3;
    int ll = 7;
    int el = 3;
    float q = 0.2f;
    int threads = 2;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBaseSeqPairDistTest.suite());
    }

    public GroebnerBaseSeqPairDistTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GroebnerBaseSeqPairDistTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational coeff = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bbseq = new GroebnerBaseSeq<BigRational>();
        this.bbdist = new GroebnerBaseSeqPairDistributed(this.threads, this.port);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bbseq = null;
        this.bbdist.terminate();
        this.bbdist = null;
    }

    Thread[] startThreads() {
        Thread[] clients = new Thread[this.threads];
        int t = 0;
        while (t < this.threads) {
            clients[t] = new Thread(new JunitSeqPairClient(this.host, this.port));
            clients[t].start();
            ++t;
        }
        return clients;
    }

    void stopThreads(Thread[] clients) {
        int t = 0;
        while (t < this.threads) {
            try {
                clients[t].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++t;
        }
    }

    public void testSeqPairDistributedGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseSeqPairDistTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Thread[] clients = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)"isGB( { a } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseSeqPairDistTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        clients = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseSeqPairDistTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        clients = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseSeqPairDistTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        clients = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseSeqPairDistTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        clients = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bbseq.isGB(this.L));
    }

    public void testSequentialSeqPairDistributedGBase() {
        List Gp = null;
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L.add(this.a);
        List<GenPolynomial<BigRational>> Gs = this.bbseq.GB(this.L);
        Thread[] clients = this.startThreads();
        Gp = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gs.containsAll(Gp)" + Gs + ", " + Gp), (boolean)Gs.containsAll(Gp));
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gp.containsAll(Gs)" + Gs + ", " + Gp), (boolean)Gp.containsAll(Gs));
        this.L = Gs;
        this.L.add(this.b);
        Gs = this.bbseq.GB(this.L);
        clients = this.startThreads();
        Gp = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gs.containsAll(Gp)" + Gs + ", " + Gp), (boolean)Gs.containsAll(Gp));
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gp.containsAll(Gs)" + Gs + ", " + Gp), (boolean)Gp.containsAll(Gs));
        this.L = Gs;
        this.L.add(this.c);
        Gs = this.bbseq.GB(this.L);
        clients = this.startThreads();
        Gp = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gs.containsAll(Gp)" + Gs + ", " + Gp), (boolean)Gs.containsAll(Gp));
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gp.containsAll(Gs)" + Gs + ", " + Gp), (boolean)Gp.containsAll(Gs));
        this.L = Gs;
        this.L.add(this.d);
        Gs = this.bbseq.GB(this.L);
        clients = this.startThreads();
        Gp = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gs.containsAll(Gp)" + Gs + ", " + Gp), (boolean)Gs.containsAll(Gp));
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gp.containsAll(Gs)" + Gs + ", " + Gp), (boolean)Gp.containsAll(Gs));
        this.L = Gs;
        this.L.add(this.e);
        Gs = this.bbseq.GB(this.L);
        clients = this.startThreads();
        Gp = this.bbdist.GB(this.L);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gs.containsAll(Gp)" + Gs + ", " + Gp), (boolean)Gs.containsAll(Gp));
        GroebnerBaseSeqPairDistTest.assertTrue((String)("Gp.containsAll(Gs)" + Gs + ", " + Gp), (boolean)Gp.containsAll(Gs));
    }

    public void testTrinks7GBase() {
        String exam = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            this.F = parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GroebnerBaseSeqPairDistTest.fail((String)("" + e));
        }
        Thread[] clients = this.startThreads();
        this.G = this.bbdist.GB(this.F.list);
        this.stopThreads(clients);
        GroebnerBaseSeqPairDistTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseSeqPairDistTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        PolynomialList trinks = new PolynomialList(this.F.ring, this.G);
    }
}

