/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPairList;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducerServerSeqPair;
import edu.jas.gb.ReducerClientSeqPair;
import edu.jas.gb.ReducerServerSeqPair;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import edu.jas.util.SocketChannel;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseSeqPairDistributed<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseSeqPairDistributed.class);
    protected final int threads;
    protected static final int DEFAULT_THREADS = 2;
    protected final ThreadPool pool;
    protected static final int DEFAULT_PORT = 4711;
    protected final int port;

    public GroebnerBaseSeqPairDistributed() {
        this(2, 4711);
    }

    public GroebnerBaseSeqPairDistributed(int threads) {
        this(threads, new ThreadPool(threads), 4711);
    }

    public GroebnerBaseSeqPairDistributed(int threads, Reduction<C> red) {
        this(threads, new ThreadPool(threads), 4711, red);
    }

    public GroebnerBaseSeqPairDistributed(int threads, int port, Reduction<C> red) {
        this(threads, new ThreadPool(threads), port, red);
    }

    public GroebnerBaseSeqPairDistributed(int threads, int port) {
        this(threads, new ThreadPool(threads), port);
    }

    public GroebnerBaseSeqPairDistributed(int threads, ThreadPool pool, int port) {
        this(threads, pool, port, new ReductionPar());
    }

    public GroebnerBaseSeqPairDistributed(int threads, ThreadPool pool, int port, Reduction<C> red) {
        super(red);
        if (!(red instanceof ReductionPar)) {
            logger.warn((Object)"parallel GB should use parallel aware reduction");
        }
        if (threads < 1) {
            threads = 1;
        }
        this.threads = threads;
        this.pool = pool;
        this.port = port;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F2) {
        int DL_PORT = this.port + 100;
        ChannelFactory cf = new ChannelFactory(this.port);
        cf.init();
        DistHashTableServer dls = new DistHashTableServer(DL_PORT);
        dls.init();
        logger.debug((Object)"dist-list server running");
        List G = new ArrayList();
        CriticalPairList<C> pairlist = null;
        boolean oneInGB = false;
        int l = F2.size();
        ListIterator<GenPolynomial<C>> it = F2.listIterator();
        while (it.hasNext()) {
            GenPolynomial<C> p = it.next();
            if (p.length() > 0) {
                int unused;
                if ((p = p.monic()).isONE()) {
                    oneInGB = true;
                    G.clear();
                    G.add(p);
                }
                if (!oneInGB) {
                    G.add(p);
                }
                if (pairlist == null) {
                    pairlist = new CriticalPairList<C>(modv, p.ring);
                }
                if (p.isONE()) {
                    unused = pairlist.putOne();
                    continue;
                }
                unused = pairlist.put(p);
                continue;
            }
            --l;
        }
        logger.debug((Object)"looking for clients");
        DistHashTable theList = new DistHashTable("localhost", DL_PORT);
        ArrayList al = pairlist.getList();
        int i = 0;
        while (i < al.size()) {
            GenPolynomial nn = theList.put(new Integer(i), al.get(i));
            if (nn != null) {
                logger.info((Object)("double polynomials " + i + ", nn = " + nn + ", al(i) = " + al.get(i)));
            }
            ++i;
        }
        Terminator fin = new Terminator(this.threads);
        int i2 = 0;
        while (i2 < this.threads) {
            ReducerServerSeqPair R = new ReducerServerSeqPair(fin, cf, theList, G, pairlist);
            this.pool.addJob(R);
            ++i2;
        }
        logger.debug((Object)"main loop waiting");
        fin.waitDone();
        int ps = theList.size();
        G = pairlist.getList();
        if (ps != G.size()) {
            logger.error((Object)("#distributed list = " + theList.size() + " #pairlist list = " + G.size()));
        }
        long time = System.currentTimeMillis();
        List Gp = this.minimalGB(G);
        time = System.currentTimeMillis() - time;
        logger.info((Object)("parallel gbmi = " + time));
        G = Gp;
        cf.terminate();
        logger.info((Object)"theList.terminate()");
        theList.terminate();
        logger.info((Object)"dls.terminate()");
        dls.terminate();
        logger.info((Object)("" + pairlist));
        return G;
    }

    public void clientPart(String host) throws IOException {
        ChannelFactory cf = new ChannelFactory(this.port + 10);
        cf.init();
        SocketChannel pairChannel = cf.getChannel(host, this.port);
        int DL_PORT = this.port + 100;
        DistHashTable theList = new DistHashTable(host, DL_PORT);
        ReducerClientSeqPair R = new ReducerClientSeqPair(pairChannel, theList);
        R.run();
        pairChannel.close();
        theList.terminate();
        cf.terminate();
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Fp) {
        GenPolynomial<C> a;
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Fp.size());
        ListIterator<GenPolynomial<Object>> it = Fp.listIterator();
        while (it.hasNext()) {
            a = it.next();
            if (a.length() == 0) continue;
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenPolynomial<C>> F2 = new ArrayList<GenPolynomial<C>>(G.size());
        while (G.size() > 0) {
            ExpVector f;
            GenPolynomial<Object> p;
            a = G.remove(0);
            ExpVector e = a.leadingExpVector();
            it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F2.listIterator();
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (mt) continue;
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        MiReducerServerSeqPair[] mirs = new MiReducerServerSeqPair[G.size()];
        int i = 0;
        F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            mirs[i] = new MiReducerServerSeqPair<C>((List)G.clone(), (List)F2.clone(), a);
            this.pool.addJob(mirs[i]);
            ++i;
            F2.add(a);
        }
        G = F2;
        F2 = new ArrayList(G.size());
        i = 0;
        while (i < mirs.length) {
            a = mirs[i].getNF();
            F2.add(a);
            ++i;
        }
        return F2;
    }
}

