/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPairList;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducerSeqPair;
import edu.jas.gb.ReducerSeqPair;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseSeqPairParallel<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseSeqPairParallel.class);
    protected final int threads;
    protected final ThreadPool pool;

    public GroebnerBaseSeqPairParallel() {
        this(2);
    }

    public GroebnerBaseSeqPairParallel(int threads) {
        this(threads, new ThreadPool(threads));
    }

    public GroebnerBaseSeqPairParallel(int threads, ThreadPool pool) {
        this(threads, pool, new ReductionPar());
    }

    public GroebnerBaseSeqPairParallel(int threads, Reduction<C> red) {
        this(threads, new ThreadPool(threads), red);
    }

    public GroebnerBaseSeqPairParallel(int threads, ThreadPool pool, Reduction<C> red) {
        super(red);
        if (!(red instanceof ReductionPar)) {
            logger.warn((Object)"parallel GB should use parallel aware reduction");
        }
        if (threads < 1) {
            threads = 1;
        }
        this.threads = threads;
        this.pool = pool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int s = this.pool.cancel();
        return s;
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F2) {
        List<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>();
        CriticalPairList<C> pairlist = null;
        int l = F2.size();
        ListIterator<GenPolynomial<C>> it = F2.listIterator();
        while (it.hasNext()) {
            GenPolynomial<C> p = it.next();
            if (p.length() > 0) {
                if ((p = p.monic()).isONE()) {
                    G.clear();
                    G.add(p);
                    return G;
                }
                G.add(p);
                if (pairlist == null) {
                    pairlist = new CriticalPairList<C>(modv, p.ring);
                    if (!p.ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                pairlist.put(p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        Terminator fin = new Terminator(this.threads);
        int i = 0;
        while (i < this.threads) {
            ReducerSeqPair<C> R = new ReducerSeqPair<C>(fin, G, pairlist);
            this.pool.addJob(R);
            ++i;
        }
        fin.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug((Object)("#parallel list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Fp) {
        GenPolynomial<C> a;
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Fp.size());
        ListIterator<GenPolynomial<Object>> it = Fp.listIterator();
        while (it.hasNext()) {
            a = it.next();
            if (a.length() == 0) continue;
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenPolynomial<C>> F2 = new ArrayList<GenPolynomial<C>>(G.size());
        while (G.size() > 0) {
            ExpVector f;
            GenPolynomial<Object> p;
            a = G.remove(0);
            ExpVector e = a.leadingExpVector();
            it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F2.listIterator();
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (mt) continue;
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        MiReducerSeqPair[] mirs = new MiReducerSeqPair[G.size()];
        int i = 0;
        F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            mirs[i] = new MiReducerSeqPair<C>((List)G.clone(), (List)F2.clone(), a);
            this.pool.addJob(mirs[i]);
            ++i;
            F2.add(a);
        }
        G = F2;
        F2 = new ArrayList(G.size());
        i = 0;
        while (i < mirs.length) {
            a = mirs[i].getNF();
            F2.add(a);
            ++i;
        }
        return F2;
    }
}

