/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPair;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.Pair;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.TaggedSocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class HybridReducerClient<C extends RingElem<C>>
implements Runnable {
    private static final Logger logger = Logger.getLogger(HybridReducerClient.class);
    public final boolean debug = logger.isDebugEnabled();
    private final TaggedSocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final ReductionPar<C> red;
    private final int threadsPerNode;
    public final Integer pairTag = GroebnerBaseDistributedHybrid.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybrid.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybrid.ackTag;

    HybridReducerClient(int tpn, TaggedSocketChannel tc, Integer tid, DistHashTable<Integer, GenPolynomial<C>> dl) {
        this.threadsPerNode = tpn;
        this.pairChannel = tc;
        this.theList = dl;
        this.red = new ReductionPar();
    }

    @Override
    public void run() {
        if (this.debug) {
            logger.info((Object)("pairChannel   = " + this.pairChannel + " reducer client running"));
        }
        Pair pair = null;
        GenPolynomial<C> H = null;
        boolean goon = true;
        boolean doEnd = false;
        int reduction = 0;
        while (goon) {
            GBTransportMessReq req = new GBTransportMessReq();
            logger.info((Object)("send request = " + req));
            try {
                this.pairChannel.send(this.pairTag, req);
            }
            catch (IOException e) {
                goon = false;
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                logger.info((Object)"receive pair, exception ");
                break;
            }
            logger.debug((Object)("receive pair, goon = " + goon));
            doEnd = false;
            Object pp = null;
            try {
                pp = this.pairChannel.receive(this.pairTag);
            }
            catch (InterruptedException e) {
                goon = false;
                e.printStackTrace();
            }
            catch (IOException e) {
                goon = false;
                if (!logger.isDebugEnabled()) break;
                e.printStackTrace();
                break;
            }
            catch (ClassNotFoundException e) {
                goon = false;
                e.printStackTrace();
            }
            if (this.debug) {
                logger.info((Object)("received pair = " + pp));
            }
            H = null;
            if (pp == null) continue;
            if (pp instanceof GBTransportMessEnd) {
                goon = false;
                doEnd = true;
                continue;
            }
            if (pp instanceof GBTransportMessPair || pp instanceof GBTransportMessPairIndex) {
                GenPolynomial S;
                GenPolynomial pj = null;
                GenPolynomial pi = null;
                if (pp instanceof GBTransportMessPair && (pair = ((GBTransportMessPair)pp).pair) != null) {
                    pi = pair.pi;
                    pj = pair.pj;
                }
                if (pp instanceof GBTransportMessPairIndex) {
                    Integer pix = ((GBTransportMessPairIndex)pp).i;
                    Integer pjx = ((GBTransportMessPairIndex)pp).j;
                    pi = this.theList.getWait(pix);
                    pj = this.theList.getWait(pjx);
                }
                if (pi != null && pj != null && !(S = this.red.SPolynomial(pi, pj)).isZERO()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
                    }
                    H = this.red.normalform(this.theList, S);
                    ++reduction;
                    if (!H.isZERO()) {
                        H = H.monic();
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("ht(H) = " + H.leadingExpVector()));
                        }
                    }
                }
            }
            if (pp instanceof GBTransportMess) {
                logger.debug((Object)"null pair results in null H poly");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("#distributed list = " + this.theList.size()));
                logger.debug((Object)("send H polynomial = " + H));
            }
            try {
                this.pairChannel.send(this.resultTag, new GBTransportMessPoly(H));
                doEnd = true;
            }
            catch (IOException e) {
                goon = false;
                e.printStackTrace();
            }
            logger.info((Object)("done send poly message of " + pp));
            try {
                pp = this.pairChannel.receive(this.ackTag);
            }
            catch (InterruptedException e) {
                goon = false;
                e.printStackTrace();
            }
            catch (IOException e) {
                goon = false;
                if (!logger.isDebugEnabled()) break;
                e.printStackTrace();
                break;
            }
            catch (ClassNotFoundException e) {
                goon = false;
                e.printStackTrace();
            }
            if (!(pp instanceof GBTransportMess)) {
                logger.error((Object)("invalid acknowledgement " + pp));
            }
            logger.info((Object)("received acknowledgment " + pp));
        }
        logger.info((Object)("terminated, done " + reduction + " reductions"));
        if (!doEnd) {
            try {
                this.pairChannel.send(this.resultTag, new GBTransportMessEnd());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.info((Object)"terminated, send done");
        }
    }
}

