/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.OrderedPairlist;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

class HybridReducerReceiver<C extends RingElem<C>>
extends Thread {
    public static final Logger logger = Logger.getLogger(HybridReducerReceiver.class);
    public final boolean debug = logger.isDebugEnabled();
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final OrderedPairlist<C> pairlist;
    private final TaggedSocketChannel pairChannel;
    private final Terminator finner;
    private final int threadsPerNode;
    private final AtomicInteger active;
    private volatile boolean goon;
    public final Integer pairTag = GroebnerBaseDistributedHybrid.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybrid.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybrid.ackTag;

    HybridReducerReceiver(int tpn, Terminator fin, AtomicInteger a, TaggedSocketChannel pc, DistHashTable<Integer, GenPolynomial<C>> dl, OrderedPairlist<C> L) {
        this.active = a;
        this.threadsPerNode = tpn;
        this.finner = fin;
        this.pairChannel = pc;
        this.theList = dl;
        this.pairlist = L;
        this.goon = true;
    }

    @Override
    public void run() {
        GenPolynomial H = null;
        int red = 0;
        int polIndex = -1;
        while (this.goon) {
            logger.debug((Object)"receive result");
            Object rh = null;
            try {
                rh = this.pairChannel.receive(this.resultTag);
                int i = this.active.getAndDecrement();
            }
            catch (InterruptedException e) {
                this.goon = false;
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.goon = false;
                this.finner.initIdle(1);
                break;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                this.goon = false;
                this.finner.initIdle(1);
                break;
            }
            logger.info((Object)"received H polynomial");
            if (rh == null) {
                if (this.isInterrupted()) {
                    this.goon = false;
                    this.finner.initIdle(1);
                    break;
                }
            } else {
                if (rh instanceof GBTransportMessEnd) {
                    logger.info((Object)"received GBTransportMessEnd");
                    this.goon = false;
                    break;
                }
                if (rh instanceof GBTransportMessPoly) {
                    ++red;
                    GBTransportMessPoly mpi = (GBTransportMessPoly)rh;
                    H = mpi.pol;
                    if (H != null) {
                        if (this.debug) {
                            logger.info((Object)("H = " + H.leadingExpVector()));
                        }
                        if (!H.isZERO()) {
                            GenPolynomial nn;
                            if (H.isONE()) {
                                polIndex = this.pairlist.putOne(H);
                                nn = this.theList.put(new Integer(polIndex), H);
                                if (nn != null) {
                                    logger.info((Object)("double polynomials nn = " + nn + ", H = " + H));
                                }
                            } else {
                                polIndex = this.pairlist.put(H);
                                nn = this.theList.put(new Integer(polIndex), H);
                                if (nn != null) {
                                    logger.info((Object)("double polynomials nn = " + nn + ", H = " + H));
                                }
                            }
                        }
                    }
                }
            }
            this.finner.initIdle(1);
            try {
                this.pairChannel.send(this.ackTag, new GBTransportMess());
                logger.debug((Object)"send acknowledgement");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.goon = false;
                break;
            }
        }
        this.goon = false;
        logger.info((Object)("terminated, received " + red + " reductions"));
    }

    public void terminate() {
        this.goon = false;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug((Object)"HybridReducerReceiver terminated");
    }
}

