/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

public class Katsura {
    final int N;
    final String var;
    final String order;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: Katsura N <order> <var>");
            return;
        }
        int n = Integer.parseInt(args[0]);
        Katsura k = null;
        if (args.length == 1) {
            k = new Katsura(n);
        }
        if (args.length == 2) {
            k = new Katsura("u", n, args[1]);
        }
        if (args.length == 3) {
            k = new Katsura(args[2], n, args[1]);
        }
        System.out.println("#Katsura equations for N = " + n + ":");
        System.out.println("" + k);
    }

    public Katsura(int n) {
        this("u", n);
    }

    public Katsura(String v, int n) {
        this(v, n, "G");
    }

    public Katsura(String var, int n, String order) {
        this.var = var;
        this.N = n;
        this.order = order;
    }

    String sum1() {
        StringBuffer s = new StringBuffer();
        int i = -this.N;
        while (i <= this.N) {
            s.append(this.variable(i));
            if (i < this.N) {
                s.append(" + ");
            }
            ++i;
        }
        s.append(" - 1");
        return s.toString();
    }

    String sumUm(int m) {
        StringBuffer s = new StringBuffer();
        int i = -this.N;
        while (i <= this.N) {
            s.append(this.variable(i));
            s.append("*");
            s.append(this.variable(m - i));
            if (i < this.N) {
                s.append(" + ");
            }
            ++i;
        }
        s.append(" - " + this.variable(m));
        return s.toString();
    }

    public String varList(String order) {
        return this.varList("Rat", order);
    }

    public String varList(String coeff, String order) {
        StringBuffer s = new StringBuffer();
        s.append(coeff);
        s.append("(");
        int i = this.N;
        while (i >= 0) {
            s.append(this.variable(i));
            if (i > 0) {
                s.append(",");
            }
            --i;
        }
        s.append(")  ");
        s.append(order);
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.varList(this.order));
        s.append(System.getProperty("line.separator"));
        s.append(this.polyList());
        return s.toString();
    }

    public String polyList() {
        StringBuffer s = new StringBuffer();
        s.append("(" + System.getProperty("line.separator"));
        int m = 0;
        while (m <= this.N - 1) {
            s.append(this.sumUm(m));
            s.append("," + System.getProperty("line.separator"));
            ++m;
        }
        s.append(this.sum1());
        s.append(System.getProperty("line.separator"));
        s.append(")" + System.getProperty("line.separator"));
        return s.toString();
    }

    String variable(int i) {
        if (i < 0) {
            return this.variable(-i);
        }
        if (i > this.N) {
            return "0";
        }
        return String.valueOf(this.var) + i;
    }
}

