/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

class MiReducer<C extends RingElem<C>>
implements Runnable {
    private List<GenPolynomial<C>> G;
    private List<GenPolynomial<C>> F;
    private GenPolynomial<C> S;
    private GenPolynomial<C> H;
    private ReductionPar<C> red;
    private Semaphore done = new Semaphore(0);
    private static final Logger logger = Logger.getLogger(MiReducer.class);

    MiReducer(List<GenPolynomial<C>> G, List<GenPolynomial<C>> F2, GenPolynomial<C> p) {
        this.G = G;
        this.F = F2;
        this.S = p;
        this.H = this.S;
        this.red = new ReductionPar();
    }

    public String toString() {
        return "MiReducer";
    }

    public GenPolynomial<C> getNF() {
        try {
            this.done.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("interrupt in getNF");
        }
        return this.H;
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ht(S) = " + this.S.leadingExpVector()));
        }
        try {
            this.H = this.red.normalform(this.G, this.H);
            this.H = this.red.normalform(this.F, this.H);
            this.done.release();
        }
        catch (RuntimeException e) {
            Thread.currentThread().interrupt();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ht(H) = " + this.H.leadingExpVector()));
        }
    }
}

