/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.DReduction;
import edu.jas.gb.DReductionSeq;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderedDPairlist<C extends RingElem<C>>
extends OrderedPairlist<C> {
    private static final Logger logger = Logger.getLogger(OrderedDPairlist.class);
    protected final DReduction<C> dreduction = new DReductionSeq();

    public OrderedDPairlist(GenPolynomialRing<C> r) {
        this(0, r);
    }

    public OrderedDPairlist(int m, GenPolynomialRing<C> r) {
        super(m, r);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("OrderedDPairlist(");
        s.append("#put=" + this.putCount);
        s.append(", #rem=" + this.remCount);
        if (this.pairlist.size() != 0) {
            s.append(", size=" + this.pairlist.size());
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator ip = this.pairlist.entrySet().iterator();
        Pair pair = null;
        boolean c = false;
        ExpVector g = null;
        if (ip.hasNext()) {
            Map.Entry me = ip.next();
            g = (ExpVector)me.getKey();
            LinkedList xl = (LinkedList)me.getValue();
            pair = null;
            if (xl.size() > 0) {
                pair = (Pair)xl.removeFirst();
                int i = pair.i;
                int j = pair.j;
                c = this.useCriterion4 ? this.dreduction.criterion4(pair.pi, pair.pj, g) : true;
                pair.setUseCriterion4(c);
                if (c) {
                    c = this.criterion3(i, j, g);
                    pair.setUseCriterion3(c);
                }
                ((BitSet)this.red.get(j)).clear(i);
            }
            if (xl.size() == 0) {
                ip.remove();
            }
        }
        if (c) {
            ++this.remCount;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("g  = " + g + " " + pair));
        }
        return pair;
    }

    @Override
    public boolean criterion3(int i, int j, ExpVector eij) {
        boolean s = ((BitSet)this.red.get(j)).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        s = true;
        Object ci = ((GenPolynomial)this.P.get(i)).leadingBaseCoefficient();
        Object cj = ((GenPolynomial)this.P.get(j)).leadingBaseCoefficient();
        Object c = ci.gcd(cj);
        int k = 0;
        while (k < this.P.size()) {
            GenPolynomial A = (GenPolynomial)this.P.get(k);
            ExpVector ek = A.leadingExpVector();
            boolean m = eij.multipleOf(ek);
            if (m) {
                Object ck = A.leadingBaseCoefficient();
                RingElem r = (RingElem)c.remainder(ck);
                m = r.isZERO();
            }
            if (m) {
                if (k < i) {
                    boolean bl = s = ((BitSet)this.red.get(i)).get(k) || ((BitSet)this.red.get(j)).get(k);
                }
                if (i < k && k < j) {
                    boolean bl = s = ((BitSet)this.red.get(k)).get(i) || ((BitSet)this.red.get(j)).get(k);
                }
                if (j < k) {
                    boolean bl = s = ((BitSet)this.red.get(k)).get(i) || ((BitSet)this.red.get(k)).get(j);
                }
                if (!s) {
                    return s;
                }
            }
            ++k;
        }
        return true;
    }
}

