/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class OrderedPairlist<C extends RingElem<C>> {
    protected final ArrayList<GenPolynomial<C>> P;
    protected final TreeMap<ExpVector, LinkedList<Pair<C>>> pairlist;
    protected final ArrayList<BitSet> red;
    protected final GenPolynomialRing<C> ring;
    protected final Reduction<C> reduction;
    protected boolean oneInGB = false;
    protected boolean useCriterion4 = true;
    protected int putCount;
    protected int remCount;
    protected final int moduleVars;
    private static final Logger logger = Logger.getLogger(OrderedPairlist.class);

    public OrderedPairlist(GenPolynomialRing<C> r) {
        this(0, r);
    }

    public OrderedPairlist(int m, GenPolynomialRing<C> r) {
        this.moduleVars = m;
        this.ring = r;
        this.P = new ArrayList();
        this.pairlist = new TreeMap(this.ring.tord.getAscendComparator());
        this.red = new ArrayList();
        this.putCount = 0;
        this.remCount = 0;
        if (this.ring instanceof GenSolvablePolynomialRing) {
            this.useCriterion4 = false;
        }
        this.reduction = new ReductionSeq();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("OrderedPairlist(");
        s.append("#put=" + this.putCount);
        s.append(", #rem=" + this.remCount);
        if (this.pairlist.size() != 0) {
            s.append(", size=" + this.pairlist.size());
        }
        s.append(")");
        return s.toString();
    }

    public synchronized int put(GenPolynomial<C> p) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector e = p.leadingExpVector();
        int l = this.P.size();
        int j = 0;
        while (j < l) {
            GenPolynomial<C> pj = this.P.get(j);
            ExpVector f = pj.leadingExpVector();
            if (this.moduleVars <= 0 || this.reduction.moduleCriterion(this.moduleVars, e, f)) {
                ExpVector g = e.lcm(f);
                Pair<C> pair = new Pair<C>(pj, p, j, l);
                LinkedList<Pair<C>> x = this.pairlist.get(g);
                LinkedList<Pair<Object>> xl = x == null ? new LinkedList() : x;
                xl.addFirst(pair);
                this.pairlist.put(g, xl);
            }
            ++j;
        }
        this.P.add(p);
        BitSet redi = new BitSet();
        redi.set(0, l);
        this.red.add(redi);
        return this.P.size() - 1;
    }

    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<ExpVector, LinkedList<Pair<C>>>> ip = this.pairlist.entrySet().iterator();
        Pair<C> pair = null;
        boolean c = false;
        while (!c && ip.hasNext()) {
            Map.Entry<ExpVector, LinkedList<Pair<C>>> me = ip.next();
            ExpVector g = me.getKey();
            LinkedList<Pair<C>> xl = me.getValue();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("g  = " + g));
            }
            pair = null;
            while (!c && xl.size() > 0) {
                pair = xl.removeFirst();
                int i = pair.i;
                int j = pair.j;
                c = this.useCriterion4 ? this.reduction.criterion4(pair.pi, pair.pj, g) : true;
                if (c) {
                    c = this.criterion3(i, j, g);
                }
                this.red.get(j).clear(i);
            }
            if (xl.size() != 0) continue;
            ip.remove();
        }
        if (!c) {
            pair = null;
        } else {
            ++this.remCount;
        }
        return pair;
    }

    public boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    public ArrayList<GenPolynomial<C>> getList() {
        return this.P;
    }

    public int putCount() {
        return this.putCount;
    }

    public int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(GenPolynomial<C> one) {
        ++this.putCount;
        if (one == null) {
            return this.P.size() - 1;
        }
        if (!one.isONE()) {
            return this.P.size() - 1;
        }
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add(one);
        this.red.clear();
        return this.P.size() - 1;
    }

    public boolean criterion3(int i, int j, ExpVector eij) {
        boolean s = this.red.get(j).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        s = true;
        int k = 0;
        while (k < this.P.size()) {
            GenPolynomial<C> A = this.P.get(k);
            ExpVector ek = A.leadingExpVector();
            boolean m = eij.multipleOf(ek);
            if (m) {
                if (k < i) {
                    boolean bl = s = this.red.get(i).get(k) || this.red.get(j).get(k);
                }
                if (i < k && k < j) {
                    boolean bl = s = this.red.get(k).get(i) || this.red.get(j).get(k);
                }
                if (j < k) {
                    boolean bl = s = this.red.get(k).get(i) || this.red.get(k).get(j);
                }
                if (!s) {
                    return s;
                }
            }
            ++k;
        }
        return true;
    }
}

