/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigInteger;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.RGroebnerBasePseudoSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class RGroebnerBasePseudoSeqTest
extends TestCase {
    ProductRing<BigInteger> pfac;
    GenPolynomialRing<Product<BigInteger>> fac;
    List<GenPolynomial<Product<BigInteger>>> L;
    PolynomialList<Product<BigInteger>> F;
    List<GenPolynomial<Product<BigInteger>>> G;
    GroebnerBase<Product<BigInteger>> bb;
    GenPolynomial<Product<BigInteger>> a;
    GenPolynomial<Product<BigInteger>> b;
    GenPolynomial<Product<BigInteger>> c;
    GenPolynomial<Product<BigInteger>> d;
    GenPolynomial<Product<BigInteger>> e;
    int pl = 3;
    int rl = 3;
    int kl = 7;
    int ll = 7;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)RGroebnerBasePseudoSeqTest.suite());
    }

    public RGroebnerBasePseudoSeqTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RGroebnerBasePseudoSeqTest.class);
        return suite;
    }

    protected void setUp() {
        BigInteger coeff = new BigInteger(9L);
        this.pfac = new ProductRing<BigInteger>(coeff, this.pl);
        this.fac = new GenPolynomialRing<BigInteger>(this.pfac, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new RGroebnerBasePseudoSeq<BigInteger>(this.pfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<Product<BigInteger>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        RGroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7() {
        String exam = "Z(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( 10000 B**2 + 6600 B + 2673 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        PolynomialList F2 = null;
        try {
            F2 = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            RGroebnerBasePseudoSeqTest.fail((String)("" + e));
        }
        catch (IOException e) {
            RGroebnerBasePseudoSeqTest.fail((String)("" + e));
        }
        ArrayList colist = new ArrayList();
        colist.add(new BigInteger());
        colist.add(new BigInteger());
        ProductRing pfac = new ProductRing(colist);
        GenPolynomialRing fac = new GenPolynomialRing(pfac, F2.ring);
        List Fp = null;
        Fp = PolyUtil.toProductGen(fac, F2.list);
        ArrayList Fpp = new ArrayList();
        for (GenPolynomial genPolynomial : Fp) {
            Fpp.add(genPolynomial.multiply(pfac.getAtomic(0)));
            Fpp.add(genPolynomial.multiply(pfac.getAtomic(1)));
        }
        Fp = Fpp;
        PolynomialList trinks = new PolynomialList(fac, Fp);
        RGroebnerBasePseudoSeq rGroebnerBasePseudoSeq = new RGroebnerBasePseudoSeq(pfac);
        List G = rGroebnerBasePseudoSeq.GB(Fp);
        trinks = new PolynomialList(fac, G);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)rGroebnerBasePseudoSeq.isGB(G));
    }
}

