/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.RGroebnerBaseSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class RGroebnerBaseSeqTest
extends TestCase {
    ProductRing<BigRational> pfac;
    GenPolynomialRing<Product<BigRational>> fac;
    List<GenPolynomial<Product<BigRational>>> L;
    PolynomialList<Product<BigRational>> F;
    List<GenPolynomial<Product<BigRational>>> G;
    GroebnerBase<Product<BigRational>> bb;
    GenPolynomial<Product<BigRational>> a;
    GenPolynomial<Product<BigRational>> b;
    GenPolynomial<Product<BigRational>> c;
    GenPolynomial<Product<BigRational>> d;
    GenPolynomial<Product<BigRational>> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)RGroebnerBaseSeqTest.suite());
    }

    public RGroebnerBaseSeqTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RGroebnerBaseSeqTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational coeff = new BigRational(9L);
        this.pfac = new ProductRing<BigRational>(coeff, 4);
        this.fac = new GenPolynomialRing<BigRational>(this.pfac, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new RGroebnerBaseSeq<Product<BigRational>>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<Product<BigRational>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7() {
        String exam = "Z(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( 10000 B**2 + 6600 B + 2673 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        PolynomialList F2 = null;
        try {
            F2 = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            RGroebnerBaseSeqTest.fail((String)("" + e));
        }
        catch (IOException e) {
            RGroebnerBaseSeqTest.fail((String)("" + e));
        }
        int rl = F2.ring.nvar;
        TermOrder to = F2.ring.tord;
        String[] vars = F2.ring.getVars();
        ArrayList colist = new ArrayList();
        colist.add(new ModIntegerRing(19L));
        colist.add(new ModIntegerRing(23L));
        ProductRing pfac = new ProductRing(colist);
        GenPolynomialRing<Product<ModInteger>> fac = new GenPolynomialRing<Product<ModInteger>>(pfac, rl, to, vars);
        List Fp = PolyUtil.toProduct(fac, F2.list);
        ArrayList<GenPolynomial<Product<ModInteger>>> Fpp = new ArrayList<GenPolynomial<Product<ModInteger>>>();
        for (GenPolynomial<Product<ModInteger>> genPolynomial : Fp) {
            Fpp.add(genPolynomial.multiply(pfac.getAtomic(0)));
            Fpp.add(genPolynomial.multiply(pfac.getAtomic(1)));
        }
        Fp = Fpp;
        PolynomialList<Product<ModInteger>> trinks = new PolynomialList<Product<ModInteger>>(fac, Fp);
        RGroebnerBaseSeq rGroebnerBaseSeq = new RGroebnerBaseSeq();
        List G = rGroebnerBaseSeq.GB(Fp);
        trinks = new PolynomialList<Product<ModInteger>>(fac, G);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)rGroebnerBaseSeq.isGB(G));
    }
}

