/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.RReduction;
import edu.jas.gb.ReductionAbstract;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RegularRingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class RReductionSeq<C extends RegularRingElem<C>>
extends ReductionAbstract<C>
implements RReduction<C> {
    private static final Logger logger = Logger.getLogger(RReductionSeq.class);
    private final boolean debug = logger.isDebugEnabled();

    @Override
    public boolean isTopReducible(List<GenPolynomial<C>> P, GenPolynomial<C> A) {
        if (P == null || P.isEmpty()) {
            return false;
        }
        if (A == null || A.isZERO()) {
            return false;
        }
        boolean mt = false;
        ExpVector e = A.leadingExpVector();
        RegularRingElem<RegularRingElem> a = (RegularRingElem)A.leadingBaseCoefficient();
        a = a.idempotent();
        for (GenPolynomial<C> p : P) {
            mt = e.multipleOf(p.leadingExpVector());
            if (!mt) continue;
            RegularRingElem b = (RegularRingElem)p.leadingBaseCoefficient();
            RegularRingElem r = a.idempotentAnd(b);
            boolean bl = mt = !r.isZERO();
            if (!mt) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStrongTopReducible(List<GenPolynomial<C>> P, GenPolynomial<C> A) {
        if (P == null || P.isEmpty()) {
            return false;
        }
        if (A == null || A.isZERO()) {
            return false;
        }
        boolean mt = false;
        ExpVector e = A.leadingExpVector();
        RegularRingElem a = (RegularRingElem)A.leadingBaseCoefficient();
        a = a.idempotent();
        for (GenPolynomial<C> p : P) {
            RegularRingElem b;
            mt = e.multipleOf(p.leadingExpVector());
            if (!mt || !(mt = a.equals((b = (RegularRingElem)p.leadingBaseCoefficient()).idempotent()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        GenPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        if (Ap == null || Ap.isZERO()) {
            return true;
        }
        List<GenPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenPolynomial[l];
            int i = 0;
            while (i < Pp.size()) {
                P[i] = Pp.get(i);
                ++i;
            }
        }
        ExpVector[] htl = new ExpVector[l];
        RegularRingElem[] lbc = new RegularRingElem[l];
        GenPolynomial[] p = new GenPolynomial[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            if (P[i] != null) {
                p[i] = P[i];
                Map.Entry m = p[i].leadingMonomial();
                if (m != null) {
                    p[j] = p[i];
                    htl[j] = m.getKey();
                    lbc[j] = (RegularRingElem)m.getValue();
                    ++j;
                }
            }
            ++i;
        }
        l = j;
        boolean mt = false;
        SortedMap<ExpVector, C> Am = Ap.getMap();
        for (ExpVector e : Am.keySet()) {
            i = 0;
            while (i < l) {
                mt = e.multipleOf(htl[i]);
                if (mt) {
                    RegularRingElem a = (RegularRingElem)Am.get(e);
                    RegularRingElem r = a.idempotentAnd(lbc[i]);
                    boolean bl = mt = !r.isZERO();
                    if (mt) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        Map.Entry m;
        GenPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        List<GenPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenPolynomial[l];
            int i = 0;
            while (i < Pp.size()) {
                P[i] = Pp.get(i);
                ++i;
            }
        }
        ExpVector[] htl = new ExpVector[l];
        RegularRingElem[] lbc = new RegularRingElem[l];
        GenPolynomial[] p = new GenPolynomial[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            if (P[i] != null) {
                p[i] = P[i].abs();
                m = p[i].leadingMonomial();
                if (m != null) {
                    p[j] = p[i];
                    htl[j] = m.getKey();
                    lbc[j] = (RegularRingElem)m.getValue();
                    ++j;
                }
            }
            ++i;
        }
        l = j;
        RegularRingElem r = null;
        boolean mt = false;
        GenPolynomial<RegularRingElem> R = Ap.ring.getZERO();
        GenPolynomial<RegularRingElem> Q = null;
        GenPolynomial<Object> S = Ap;
        while (S.length() > 0) {
            m = S.leadingMonomial();
            ExpVector e = m.getKey();
            RegularRingElem a = (RegularRingElem)m.getValue();
            i = 0;
            while (i < l) {
                mt = e.multipleOf(htl[i]);
                if (mt) {
                    r = a.idempotentAnd(lbc[i]);
                    boolean bl = mt = !r.isZERO();
                    if (mt) {
                        RegularRingElem b = a.divide(lbc[i]);
                        if (b.isZERO()) {
                            System.out.println("b == zero: r = " + r);
                        } else {
                            ExpVector f = e.subtract(htl[i]);
                            Q = p[i].multiply(b, f);
                            if (!e.equals(f = (S = S.subtract((Object)Q)).leadingExpVector())) {
                                a = (RegularRingElem)Ap.ring.coFac.getZERO();
                                break;
                            }
                            a = (RegularRingElem)S.leadingBaseCoefficient();
                        }
                    }
                }
                ++i;
            }
            if (a.isZERO()) continue;
            R = R.sum(a, e);
            S = S.reductum();
        }
        return R;
    }

    @Override
    public boolean criterion4(GenPolynomial<C> A, GenPolynomial<C> B, ExpVector e) {
        RegularRingElem b;
        RegularRingElem a;
        RegularRingElem d;
        ExpVector ej;
        ExpVector ei;
        ExpVector g;
        ExpVector h;
        int s;
        if (logger.isInfoEnabled()) {
            if (!A.ring.equals(B.ring)) {
                logger.error((Object)"rings equal");
            }
            if (A instanceof GenSolvablePolynomial || B instanceof GenSolvablePolynomial) {
                logger.error((Object)"GBCriterion4 not applicabable to SolvablePolynomials");
                return true;
            }
        }
        return (s = (h = (g = (ei = A.leadingExpVector()).sum(ej = B.leadingExpVector())).subtract(e)).signum()) != 0 || !(d = (a = (RegularRingElem)A.leadingBaseCoefficient()).multiply(b = (RegularRingElem)B.leadingBaseCoefficient())).isZERO();
    }

    @Override
    public boolean criterion4(GenPolynomial<C> A, GenPolynomial<C> B) {
        RegularRingElem b;
        RegularRingElem a;
        RegularRingElem d;
        ExpVector e;
        ExpVector ej;
        if (logger.isInfoEnabled() && (A instanceof GenSolvablePolynomial || B instanceof GenSolvablePolynomial)) {
            logger.error((Object)"GBCriterion4 not applicabable to SolvablePolynomials");
            return true;
        }
        ExpVector ei = A.leadingExpVector();
        ExpVector g = ei.sum(ej = B.leadingExpVector());
        ExpVector h = g.subtract(e = ei.lcm(ej));
        int s = h.signum();
        return s != 0 || !(d = (a = (RegularRingElem)A.leadingBaseCoefficient()).multiply(b = (RegularRingElem)B.leadingBaseCoefficient())).isZERO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> row, List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        Map.Entry m;
        GenPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        List<GenPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenPolynomial[l];
            int i = 0;
            while (i < Pp.size()) {
                P[i] = Pp.get(i);
                ++i;
            }
        }
        ExpVector[] htl = new ExpVector[l];
        RegularRingElem[] lbc = new RegularRingElem[l];
        GenPolynomial[] p = new GenPolynomial[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            p[i] = P[i];
            m = p[i].leadingMonomial();
            if (m != null) {
                p[j] = p[i];
                htl[j] = m.getKey();
                lbc[j] = (RegularRingElem)m.getValue();
                ++j;
            }
            ++i;
        }
        l = j;
        RegularRingElem r = null;
        boolean mt = false;
        GenPolynomial<RegularRingElem> fac = null;
        AbelianGroupElem zero = Ap.ring.getZERO();
        GenPolynomial<RegularRingElem> R = Ap.ring.getZERO();
        GenPolynomial<RegularRingElem> Q = null;
        GenPolynomial<Object> S = Ap;
        while (S.length() > 0) {
            m = S.leadingMonomial();
            ExpVector e = m.getKey();
            RegularRingElem a = (RegularRingElem)m.getValue();
            i = 0;
            while (i < l) {
                mt = e.multipleOf(htl[i]);
                if (mt) {
                    r = a.idempotentAnd(lbc[i]);
                    boolean bl = mt = !r.isZERO();
                    if (mt) {
                        if ((a = a.divide(lbc[i])).isZERO()) {
                            System.out.println("b == zero: r = " + r);
                        } else {
                            ExpVector f = e.subtract(htl[i]);
                            Q = p[i].multiply(a, f);
                            S = S.subtract((Object)Q);
                            fac = row.get(i);
                            fac = fac == null ? ((GenPolynomial)zero).sum(a, f) : fac.sum(a, f);
                            row.set(i, fac);
                            f = S.leadingExpVector();
                            if (!e.equals(f)) {
                                a = (RegularRingElem)Ap.ring.coFac.getZERO();
                                break;
                            }
                            a = (RegularRingElem)S.leadingBaseCoefficient();
                        }
                    }
                }
                ++i;
            }
            if (a.isZERO()) continue;
            R = R.sum(a, e);
            S = S.reductum();
        }
        return R;
    }

    @Override
    public List<GenPolynomial<C>> irreducibleSet(List<GenPolynomial<C>> Pp) {
        ArrayList<GenPolynomial<C>> P = new ArrayList<GenPolynomial<C>>();
        if (Pp == null) {
            return null;
        }
        for (GenPolynomial<C> a : Pp) {
            if (a.isZERO()) continue;
            P.add(a);
        }
        int l = P.size();
        if (l <= 1) {
            return P;
        }
        int irr = 0;
        logger.debug((Object)"irr = ");
        while (irr != l) {
            GenPolynomial<C> a = P.remove(0);
            ExpVector e = a.leadingExpVector();
            a = this.normalform(P, a);
            logger.debug((Object)String.valueOf(irr));
            if (a.isZERO()) {
                if (--l > 1) continue;
                return P;
            }
            ExpVector f = a.leadingExpVector();
            irr = e.equals(f) ? ++irr : 0;
            P.add(a);
        }
        return P;
    }

    @Override
    public boolean isBooleanClosed(GenPolynomial<C> A) {
        if (A == null || A.isZERO()) {
            return true;
        }
        RegularRingElem a = (RegularRingElem)A.leadingBaseCoefficient();
        Object i = a.idempotent();
        GenPolynomial<C> B = A.multiply(i);
        return A.equals(B);
    }

    @Override
    public boolean isBooleanClosed(List<GenPolynomial<C>> F2) {
        if (F2 == null || F2.size() == 0) {
            return true;
        }
        for (GenPolynomial<C> a : F2) {
            if (a == null || a.isZERO() || this.isBooleanClosed(a)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isReducedBooleanClosed(List<GenPolynomial<C>> F) {
        if (F == null || F.size() == 0) {
            return true;
        }
        for (GenPolynomial<C> a : F) {
            if (a != null) ** GOTO lbl14
            continue;
lbl-1000:
            // 1 sources

            {
                if (!this.isBooleanClosed(a)) {
                    b = this.booleanClosure(a);
                    if (!(b = this.normalform(F, b)).isZERO()) {
                        return false;
                    }
                }
                r = this.booleanRemainder(a);
                if (!(r = this.normalform(F, r)).isZERO()) {
                    return false;
                }
                a = r;
lbl14:
                // 2 sources

                ** while (!a.isZERO())
            }
lbl15:
            // 1 sources

        }
        return true;
    }

    @Override
    public GenPolynomial<C> booleanClosure(GenPolynomial<C> A) {
        if (A == null || A.isZERO()) {
            return A;
        }
        RegularRingElem a = (RegularRingElem)A.leadingBaseCoefficient();
        Object i = a.idempotent();
        GenPolynomial<C> B = A.multiply(i);
        return B;
    }

    @Override
    public GenPolynomial<C> booleanRemainder(GenPolynomial<C> A) {
        if (A == null || A.isZERO()) {
            return A;
        }
        RegularRingElem a = (RegularRingElem)A.leadingBaseCoefficient();
        Object i = a.idemComplement();
        GenPolynomial<C> B = A.multiply(i);
        return B;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<GenPolynomial<C>> booleanClosure(List<GenPolynomial<C>> F) {
        if (F == null || F.size() == 0) {
            return F;
        }
        B = new ArrayList<GenPolynomial<C>>(F.size());
        for (GenPolynomial<C> a : F) {
            if (a != null) ** GOTO lbl11
            continue;
lbl-1000:
            // 1 sources

            {
                b = this.booleanClosure(a);
                B.add(b);
                a = this.booleanRemainder(a);
lbl11:
                // 2 sources

                ** while (!a.isZERO())
            }
lbl12:
            // 1 sources

        }
        return B;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<GenPolynomial<C>> reducedBooleanClosure(List<GenPolynomial<C>> F) {
        if (F == null || F.size() == 0) {
            return F;
        }
        B = new ArrayList<GenPolynomial<C>>(F);
        len = B.size();
        i = 0;
        while (i < len) {
            block3: {
                a = (GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)B.remove(0);
                if (a != null) ** GOTO lbl16
                break block3;
lbl-1000:
                // 1 sources

                {
                    b = this.booleanClosure(a);
                    if ((b = this.booleanClosure(this.normalform(B, b))).isZERO()) break;
                    B.add(b);
                    c = a.subtract((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)b);
                    a = c = this.normalform(B, c);
lbl16:
                    // 2 sources

                    ** while (!a.isZERO())
                }
            }
            ++i;
        }
        return B;
    }

    @Override
    public List<GenPolynomial<C>> reducedBooleanClosure(List<GenPolynomial<C>> F2, GenPolynomial<C> A) {
        ArrayList<GenPolynomial<C>> B = new ArrayList<GenPolynomial<C>>();
        if (A == null || A.isZERO()) {
            return B;
        }
        GenPolynomial<GenPolynomial<C>> a = A;
        while (!a.isZERO()) {
            GenPolynomial<C> b = this.booleanClosure(a);
            if ((b = this.booleanClosure(this.normalform(F2, b))).isZERO()) break;
            B.add(b);
            GenPolynomial<GenPolynomial<C>> c = a.subtract(b);
            c = this.normalform(F2, c);
            a = c;
        }
        return B;
    }
}

