/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPair;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.Pair;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class ReducerClient<C extends RingElem<C>>
implements Runnable {
    private final SocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final ReductionPar<C> red;
    private static final Logger logger = Logger.getLogger(ReducerClient.class);

    ReducerClient(SocketChannel pc, DistHashTable<Integer, GenPolynomial<C>> dl) {
        this.pairChannel = pc;
        this.theList = dl;
        this.red = new ReductionPar();
    }

    @Override
    public void run() {
        logger.debug((Object)("pairChannel = " + this.pairChannel + " reducer client running"));
        Pair pair = null;
        GenPolynomial<C> H = null;
        boolean goon = true;
        int reduction = 0;
        while (goon) {
            GBTransportMessReq req = new GBTransportMessReq();
            logger.debug((Object)("send request = " + req));
            try {
                this.pairChannel.send(req);
            }
            catch (IOException e) {
                goon = false;
                e.printStackTrace();
                break;
            }
            logger.debug((Object)("receive pair, goon = " + goon));
            Object pp = null;
            try {
                pp = this.pairChannel.receive();
            }
            catch (IOException e) {
                goon = false;
                if (!logger.isDebugEnabled()) break;
                e.printStackTrace();
                break;
            }
            catch (ClassNotFoundException e) {
                goon = false;
                e.printStackTrace();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("received pair = " + pp));
            }
            H = null;
            if (pp == null) continue;
            if (pp instanceof GBTransportMessEnd) {
                goon = false;
                continue;
            }
            if (pp instanceof GBTransportMessPair || pp instanceof GBTransportMessPairIndex) {
                GenPolynomial S;
                GenPolynomial pj = null;
                GenPolynomial pi = null;
                if (pp instanceof GBTransportMessPair && (pair = ((GBTransportMessPair)pp).pair) != null) {
                    pi = pair.pi;
                    pj = pair.pj;
                }
                if (pp instanceof GBTransportMessPairIndex) {
                    Integer pix = ((GBTransportMessPairIndex)pp).i;
                    Integer pjx = ((GBTransportMessPairIndex)pp).j;
                    pi = this.theList.getWait(pix);
                    pj = this.theList.getWait(pjx);
                }
                if (pi != null && pj != null && !(S = this.red.SPolynomial(pi, pj)).isZERO()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
                    }
                    H = this.red.normalform(this.theList, S);
                    ++reduction;
                    if (!H.isZERO()) {
                        H = H.monic();
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("ht(H) = " + H.leadingExpVector()));
                        }
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("#distributed list = " + this.theList.size()));
                logger.debug((Object)("send H polynomial = " + H));
            }
            try {
                this.pairChannel.send(new GBTransportMessPoly(H));
            }
            catch (IOException e) {
                goon = false;
                e.printStackTrace();
            }
        }
        logger.info((Object)("terminated, done " + reduction + " reductions"));
        this.pairChannel.close();
    }
}

