/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.GBSPTransportMessEnd;
import edu.jas.gb.GBSPTransportMessPair;
import edu.jas.gb.GBSPTransportMessPairIndex;
import edu.jas.gb.GBSPTransportMessPoly;
import edu.jas.gb.GBSPTransportMessReq;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class ReducerClientSeqPair<C extends RingElem<C>>
implements Runnable {
    private final SocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final ReductionPar<C> red;
    private static final Logger logger = Logger.getLogger(ReducerClientSeqPair.class);

    ReducerClientSeqPair(SocketChannel pc, DistHashTable<Integer, GenPolynomial<C>> dl) {
        this.pairChannel = pc;
        this.theList = dl;
        this.red = new ReductionPar();
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("pairChannel = " + this.pairChannel + "reducer client running"));
        }
        CriticalPair pair = null;
        GenPolynomial H = null;
        boolean goon = true;
        int reduction = 0;
        while (goon) {
            GBSPTransportMessReq req = new GBSPTransportMessReq();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("send request = " + req));
            }
            try {
                this.pairChannel.send(req);
            }
            catch (IOException e) {
                goon = false;
                e.printStackTrace();
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("receive pair, goon = " + goon));
            }
            Object pp = null;
            try {
                pp = this.pairChannel.receive();
            }
            catch (IOException e) {
                goon = false;
                if (!logger.isDebugEnabled()) break;
                e.printStackTrace();
                break;
            }
            catch (ClassNotFoundException e) {
                goon = false;
                e.printStackTrace();
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)("received pair = " + pp));
            }
            H = null;
            if (pp == null) continue;
            if (pp instanceof GBSPTransportMessEnd) {
                goon = false;
                continue;
            }
            if (pp instanceof GBSPTransportMessPair || pp instanceof GBSPTransportMessPairIndex) {
                GenPolynomial pj = null;
                GenPolynomial pi = null;
                if (pp instanceof GBSPTransportMessPair && (pair = ((GBSPTransportMessPair)pp).pair) != null) {
                    pi = pair.pi;
                    pj = pair.pj;
                }
                if (pp instanceof GBSPTransportMessPairIndex) {
                    Integer pix = ((GBSPTransportMessPairIndex)pp).i;
                    Integer pjx = ((GBSPTransportMessPairIndex)pp).j;
                    pi = this.theList.getWait(pix);
                    pj = this.theList.getWait(pjx);
                }
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("pi = " + pi.leadingExpVector() + ", pj = " + pj.leadingExpVector()));
                }
                if (pi != null && pj != null) {
                    GenPolynomial S = this.red.SPolynomial(pi, pj);
                    if (S.isZERO()) {
                        H = S;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
                        }
                        H = this.red.normalform(this.theList, S);
                        ++reduction;
                        if (!H.isZERO()) {
                            H = H.monic();
                            if (logger.isDebugEnabled()) {
                                logger.info((Object)("ht(H) = " + H.leadingExpVector()));
                            }
                        }
                    }
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("invalid message = " + pp));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)("send H polynomial = " + H));
            }
            try {
                this.pairChannel.send(new GBSPTransportMessPoly(H));
            }
            catch (IOException e) {
                goon = false;
                e.printStackTrace();
                break;
            }
        }
        logger.info((Object)("terminated, done " + reduction + " reductions"));
        this.pairChannel.close();
    }
}

