/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairList;
import edu.jas.gb.GBSPTransportMess;
import edu.jas.gb.GBSPTransportMessEnd;
import edu.jas.gb.GBSPTransportMessPairIndex;
import edu.jas.gb.GBSPTransportMessPoly;
import edu.jas.gb.GBSPTransportMessReq;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

class ReducerServerSeqPair<C extends RingElem<C>>
implements Runnable {
    private final Terminator pool;
    private final ChannelFactory cf;
    private SocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final CriticalPairList<C> pairlist;
    private static final Logger logger = Logger.getLogger(ReducerServerSeqPair.class);

    ReducerServerSeqPair(Terminator fin, ChannelFactory cf, DistHashTable<Integer, GenPolynomial<C>> dl, List<GenPolynomial<C>> G, CriticalPairList<C> L) {
        this.pool = fin;
        this.cf = cf;
        this.theList = dl;
        this.pairlist = L;
    }

    @Override
    public void run() {
        block36: {
            logger.debug((Object)"reducer server running");
            try {
                this.pairChannel = this.cf.getChannel();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"get pair channel interrupted");
                e.printStackTrace();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pairChannel = " + this.pairChannel));
            }
            GenPolynomial H = null;
            boolean set = false;
            boolean goon = true;
            int polIndex = -1;
            int red = 0;
            int sleeps = 0;
            while (goon) {
                logger.debug((Object)"receive request");
                Object req = null;
                try {
                    req = this.pairChannel.receive();
                }
                catch (IOException e) {
                    goon = false;
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    goon = false;
                    e.printStackTrace();
                }
                if (req == null) {
                    goon = false;
                    break;
                }
                if (!(req instanceof GBSPTransportMessReq)) {
                    goon = false;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"find pair");
                    logger.debug((Object)("pool.hasJobs() " + this.pool.hasJobs() + " pairlist.hasNext() " + this.pairlist.hasNext()));
                }
                while (!this.pairlist.hasNext()) {
                    this.pairlist.update();
                    if (!set) {
                        this.pool.beIdle();
                        set = true;
                    }
                    if (!this.pool.hasJobs() && !this.pairlist.hasNext()) {
                        goon = false;
                        break;
                    }
                    try {
                        if (++sleeps % 10 == 0) {
                            logger.info((Object)" reducer is sleeping");
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        goon = false;
                        break;
                    }
                }
                if (!this.pairlist.hasNext() && !this.pool.hasJobs()) {
                    goon = false;
                    break;
                }
                if (set) {
                    set = false;
                    this.pool.notIdle();
                }
                CriticalPair<C> pair = this.pairlist.getNext();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("send pair = " + pair));
                    logger.info((Object)("theList keys " + this.theList.keySet()));
                }
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("inWork " + this.pairlist.inWork()));
                }
                GBSPTransportMess msg = null;
                msg = pair != null ? new GBSPTransportMessPairIndex(pair) : new GBSPTransportMess();
                try {
                    this.pairChannel.send(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    goon = false;
                    break;
                }
                this.pairlist.update();
                Object rh = null;
                try {
                    rh = this.pairChannel.receive();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    goon = false;
                    break;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    goon = false;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("received H polynomial rh = " + rh));
                }
                if (rh == null) {
                    if (pair != null) {
                        polIndex = this.pairlist.record(pair, null);
                    }
                    this.pairlist.update();
                    continue;
                }
                if (rh instanceof GBSPTransportMessPoly) {
                    ++red;
                    H = ((GBSPTransportMessPoly)rh).pol;
                    if (H == null) {
                        if (pair != null) {
                            polIndex = this.pairlist.record(pair, H);
                        }
                        this.pairlist.update();
                        continue;
                    }
                    if (H.isZERO()) {
                        polIndex = this.pairlist.record(pair, H);
                        continue;
                    }
                    if (H.isONE()) {
                        this.pairlist.putOne();
                        this.theList.put(new Integer(0), H);
                        goon = false;
                        continue;
                    }
                    polIndex = this.pairlist.record(pair, H);
                    this.theList.put(new Integer(polIndex), H);
                    continue;
                }
                if (pair != null) {
                    polIndex = this.pairlist.record(pair, null);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("invalid message " + rh));
            }
            logger.info((Object)("terminated, done " + red + " reductions"));
            logger.debug((Object)"send end");
            try {
                this.pairChannel.send(new GBSPTransportMessEnd());
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block36;
                e.printStackTrace();
            }
        }
        this.pool.beIdle();
        this.pairChannel.close();
    }
}

