/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.DReductionSeq;
import edu.jas.gb.EReductionSeq;
import edu.jas.gb.PseudoReductionEntry;
import edu.jas.gb.PseudoReductionSeq;
import edu.jas.gb.RPseudoReductionSeq;
import edu.jas.gb.RReductionSeq;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ReductionTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    ReductionSeq<BigRational> red;
    Reduction<BigRational> redpar;
    int rl = 4;
    int kl = 10;
    int ll = 11;
    int el = 5;
    float q = 0.6f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ReductionTest.suite());
    }

    public ReductionTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ReductionTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(0L), this.rl);
        this.red = new ReductionSeq();
        this.redpar = new ReductionPar<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.red = null;
        this.redpar = null;
    }

    public void testRatReduction0() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testRatReductionPar0() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testRatReduction() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
        this.e = this.red.SPolynomial(this.a, this.b);
        ExpVector ce = this.a.leadingExpVector().lcm(this.b.leadingExpVector());
        ExpVector ee = this.e.leadingExpVector();
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)ce.equals(this.e));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)this.red.isTopReducible(this.L, this.a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)this.red.isReducible(this.L, this.a));
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.L.add(this.b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)this.red.isTopReducible(this.L, this.b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)this.red.isReducible(this.L, this.b));
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)this.red.isNormalform(this.L, this.e));
    }

    public void testRatReductionPar() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)this.redpar.isTopReducible(this.L, this.a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)this.redpar.isReducible(this.L, this.a));
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.L.add(this.b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)this.redpar.isTopReducible(this.L, this.b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)this.redpar.isReducible(this.L, this.b));
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)this.redpar.isNormalform(this.L, this.e));
    }

    public void testComplexReduction() {
        GenPolynomialRing<BigComplex> fac = new GenPolynomialRing<BigComplex>(new BigComplex(0L), this.rl);
        ReductionSeq<BigComplex> cred = new ReductionSeq<BigComplex>();
        GenPolynomial<BigComplex> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigComplex> b = fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ArrayList L = new ArrayList();
        L.add(a);
        GenPolynomial<BigComplex> e = cred.normalform(L, a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        L.add(b);
        e = cred.normalform(L, a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)e.isZERO());
        L = new ArrayList();
        L.add(a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)cred.isTopReducible(L, a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)cred.isReducible(L, a));
        b = fac.random(this.kl, this.ll, this.el, this.q);
        L.add(b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)cred.isTopReducible(L, b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)cred.isReducible(L, b));
        GenPolynomial<BigComplex> c = fac.random(this.kl, this.ll, this.el, this.q);
        e = cred.normalform(L, c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)cred.isNormalform(L, e));
    }

    public void testRatReductionRecording() {
        ArrayList row = null;
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        row = new ArrayList(this.L.size());
        int m = 0;
        while (m < this.L.size()) {
            row.add(null);
            ++m;
        }
        this.e = this.red.normalform(row, this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(row, this.L, this.a, this.e));
        this.L.add(this.b);
        row = new ArrayList(this.L.size());
        m = 0;
        while (m < this.L.size()) {
            row.add(null);
            ++m;
        }
        this.e = this.red.normalform(row, this.L, this.b);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(row, this.L, this.b, this.e));
        this.L.add(this.c);
        row = new ArrayList(this.L.size());
        m = 0;
        while (m < this.L.size()) {
            row.add(null);
            ++m;
        }
        this.e = this.red.normalform(row, this.L, this.c);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(row, this.L, this.c, this.e));
        this.L.add(this.d);
        row = new ArrayList(this.L.size());
        m = 0;
        while (m < this.L.size()) {
            row.add(null);
            ++m;
        }
        this.e = this.red.normalform(row, this.L, this.d);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(row, this.L, this.d, this.e));
    }

    public void testIntegerEReduction() {
        BigInteger bi = new BigInteger(0L);
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(bi, this.rl);
        EReductionSeq<BigInteger> ered = new EReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> b = fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ArrayList L = new ArrayList();
        L.add(a);
        GenPolynomial<BigInteger> e = ered.normalform(L, a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        L.add(b);
        e = ered.normalform(L, a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)e.isZERO());
        GenPolynomial<BigInteger> c = fac.getONE();
        a = a.sum((BigInteger)((Object)c));
        e = ered.normalform(L, a);
        ReductionTest.assertTrue((String)"isONE( e ) some times", (boolean)e.isONE());
        L = new ArrayList();
        a = c.multiply(bi.fromInteger(4L));
        b = c.multiply(bi.fromInteger(5L));
        L.add(a);
        e = ered.normalform(L, b);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)e.isONE());
        a = fac.random(this.kl, this.ll, this.el, this.q);
        b = fac.random(this.kl, this.ll, this.el, this.q);
        c = ered.GPolynomial(a, b);
        e = ered.SPolynomial(a, b);
        BigInteger ci = a.leadingBaseCoefficient().gcd(b.leadingBaseCoefficient());
        ReductionTest.assertEquals((String)"gcd(lbc(a),lbc(b)) = lbc(c) ", (Object)ci, (Object)c.leadingBaseCoefficient());
        ExpVector ce = a.leadingExpVector().lcm(b.leadingExpVector());
        ReductionTest.assertEquals((String)"lcm(lt(a),lt(b)) == lt(c) ", (Object)ce, (Object)c.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)ce.equals(e.leadingExpVector()));
        L = new ArrayList();
        L.add(a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)ered.isTopReducible(L, a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)ered.isReducible(L, a));
        b = fac.random(this.kl, this.ll, this.el, this.q);
        L.add(b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)ered.isTopReducible(L, b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)ered.isReducible(L, b));
        c = fac.random(this.kl, this.ll, this.el, this.q);
        e = ered.normalform(L, c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)ered.isNormalform(L, e));
    }

    public void testIntegerDReduction() {
        BigInteger bi = new BigInteger(0L);
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(bi, this.rl);
        DReductionSeq<BigInteger> dred = new DReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> b = fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ArrayList L = new ArrayList();
        L.add(a);
        GenPolynomial<BigInteger> e = dred.normalform(L, a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        L.add(b);
        e = dred.normalform(L, a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)e.isZERO());
        GenPolynomial<BigInteger> c = fac.getONE();
        a = a.sum((BigInteger)((Object)c));
        e = dred.normalform(L, a);
        ReductionTest.assertTrue((String)"isONE( e ) some times", (boolean)e.isONE());
        L = new ArrayList();
        a = c.multiply(bi.fromInteger(5L));
        L.add(a);
        b = c.multiply(bi.fromInteger(4L));
        e = dred.normalform(L, b);
        ReductionTest.assertTrue((String)"nf(b) = b ", (boolean)e.equals(b));
        a = fac.random(this.kl, this.ll, this.el, this.q);
        b = fac.random(this.kl, this.ll, this.el, this.q);
        c = dred.GPolynomial(a, b);
        e = dred.SPolynomial(a, b);
        BigInteger ci = a.leadingBaseCoefficient().gcd(b.leadingBaseCoefficient());
        ReductionTest.assertEquals((String)"gcd(lbc(a),lbc(b)) = lbc(c) ", (Object)ci, (Object)c.leadingBaseCoefficient());
        ExpVector ce = a.leadingExpVector().lcm(b.leadingExpVector());
        ReductionTest.assertEquals((String)"lcm(lt(a),lt(b)) == lt(c) ", (Object)ce, (Object)c.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)ce.equals(e.leadingExpVector()));
        L = new ArrayList();
        L.add(a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)dred.isTopReducible(L, a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)dred.isReducible(L, a));
        b = fac.random(this.kl, this.ll, this.el, this.q);
        L.add(b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)dred.isTopReducible(L, b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)dred.isReducible(L, b));
        c = fac.random(this.kl, this.ll, this.el, this.q);
        e = dred.normalform(L, c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)dred.isNormalform(L, e));
    }

    public void testRationalRReduction() {
        BigRational bi = new BigRational(0L);
        ProductRing<BigRational> pr = new ProductRing<BigRational>(bi, 3);
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(pr, this.rl);
        RReductionSeq<BigRational> rred = new RReductionSeq<BigRational>();
        GenPolynomial<BigRational> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<RingElem<BigRational>> b = fac.random(this.kl, this.ll, this.el, this.q);
        while (a.isZERO()) {
            a = fac.random(this.kl, this.ll, this.el, this.q);
        }
        while (b.isZERO()) {
            b = fac.random(this.kl, this.ll, this.el, this.q);
        }
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ArrayList L = new ArrayList();
        L.add(a);
        GenPolynomial<RingElem<BigRational>> e = rred.normalform(L, a);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        L.add(b);
        e = rred.normalform(L, a);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rred.isNormalform(L, e));
        GenPolynomial<BigRational> c = fac.getONE();
        a = a.sum((BigRational)((Object)c));
        e = rred.normalform(L, a);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rred.isNormalform(L, e));
        L = new ArrayList();
        L.add(a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)rred.isTopReducible(L, a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)rred.isReducible(L, a));
        L.add(b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)rred.isTopReducible(L, b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)rred.isReducible(L, b));
        c = fac.random(this.kl, this.ll, this.el, this.q);
        e = rred.normalform(L, c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rred.isNormalform(L, e));
        c = rred.booleanClosure(a);
        ReductionTest.assertTrue((String)"isBC( c )", (boolean)rred.isBooleanClosed(c));
        b = a.subtract((BigRational)((Object)c));
        GenPolynomial<BigRational> d = rred.booleanRemainder(a);
        ReductionTest.assertEquals((String)"a-BC(a)=BR(a)", b, d);
        e = c.sum((BigRational)((Object)d));
        ReductionTest.assertEquals((String)"a==BC(a)+BR(a)", a, e);
        L = new ArrayList();
        L.add(a);
        List B = rred.booleanClosure(L);
        List Br = rred.reducedBooleanClosure(L);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rred.isBooleanClosed(B));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rred.isReducedBooleanClosed(Br));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rred.isBooleanClosed(Br));
        L.add(b);
        B = rred.booleanClosure(L);
        Br = rred.reducedBooleanClosure(L);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rred.isBooleanClosed(B));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rred.isReducedBooleanClosed(Br));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rred.isBooleanClosed(Br));
        while (c.isZERO()) {
            c = fac.random(this.kl, this.ll, this.el, this.q);
        }
        L.add(c);
        B = rred.booleanClosure(L);
        Br = rred.reducedBooleanClosure(L);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rred.isBooleanClosed(B));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rred.isReducedBooleanClosed(Br));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rred.isBooleanClosed(Br));
        while (d.isZERO()) {
            d = fac.random(this.kl, this.ll, this.el, this.q);
        }
        L.add(d);
        B = rred.booleanClosure(L);
        Br = rred.reducedBooleanClosure(L);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rred.isBooleanClosed(B));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rred.isReducedBooleanClosed(Br));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rred.isBooleanClosed(Br));
    }

    public void testRatRReductionRecording() {
        BigRational bi = new BigRational(0L);
        ProductRing<BigRational> pr = new ProductRing<BigRational>(bi, 3);
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(pr, this.rl);
        RReductionSeq<BigRational> rred = new RReductionSeq<BigRational>();
        GenPolynomial<BigRational> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigRational> b = fac.random(this.kl, this.ll, this.el, this.q);
        while (a.isZERO()) {
            a = fac.random(this.kl, this.ll, this.el, this.q);
        }
        while (b.isZERO()) {
            b = fac.random(this.kl, this.ll, this.el, this.q);
        }
        GenPolynomial<BigRational> c = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigRational> d = fac.random(this.kl, this.ll, this.el, this.q);
        ArrayList row = null;
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        ArrayList L = new ArrayList();
        L.add(a);
        row = new ArrayList(L.size());
        int m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        GenPolynomial<BigRational> e = rred.normalform(row, L, a);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rred.isReductionNF(row, L, a, e));
        L.add(b);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        e = rred.normalform(row, L, b);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rred.isReductionNF(row, L, b, e));
        L.add(c);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        e = rred.normalform(row, L, c);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rred.isReductionNF(row, L, c, e));
        L.add(d);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        e = rred.normalform(row, L, d);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rred.isReductionNF(row, L, d, e));
    }

    public void testIntegerPseudoReduction() {
        BigInteger bi = new BigInteger(0L);
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(bi, this.rl);
        PseudoReductionSeq<BigInteger> pred = new PseudoReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> b = fac.random(this.kl, this.ll, this.el, this.q);
        if (a.isZERO() || b.isZERO()) {
            return;
        }
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ArrayList L = new ArrayList();
        L.add(a);
        GenPolynomial<BigInteger> e = pred.normalform(L, a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        L.add(b);
        e = pred.normalform(L, a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)e.isZERO());
        GenPolynomial<BigInteger> c = fac.getONE();
        a = a.sum((BigInteger)((Object)c));
        e = pred.normalform(L, a);
        ReductionTest.assertTrue((String)"isConstant( e ) some times", (boolean)e.isConstant());
        L = new ArrayList();
        a = c.multiply(bi.fromInteger(4L));
        b = c.multiply(bi.fromInteger(5L));
        L.add(a);
        e = pred.normalform(L, b);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)e.isZERO());
        a = fac.random(this.kl, this.ll, this.el, this.q);
        b = fac.random(this.kl, this.ll, this.el, this.q);
        L = new ArrayList();
        L.add(a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)pred.isTopReducible(L, a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)pred.isReducible(L, a));
        b = fac.random(this.kl, this.ll, this.el, this.q);
        L.add(b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)pred.isTopReducible(L, b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)pred.isReducible(L, b));
        c = fac.random(this.kl, this.ll, this.el, this.q);
        e = pred.normalform(L, c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)pred.isNormalform(L, e));
    }

    public void testIntReductionRecording() {
        BigInteger bi = new BigInteger(0L);
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(bi, this.rl);
        PseudoReductionSeq<Object> pred = new PseudoReductionSeq<Object>();
        GenPolynomial<BigInteger> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> b = fac.random(this.kl, this.ll, this.el, this.q);
        if (a.isZERO() || b.isZERO()) {
            return;
        }
        GenPolynomial<BigInteger> c = fac.random(this.kl, this.ll, this.el + 1, this.q);
        GenPolynomial<BigInteger> d = fac.random(this.kl, this.ll, this.el + 2, this.q);
        ArrayList row = null;
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        ArrayList L = new ArrayList();
        L.add(a);
        row = new ArrayList(L.size());
        int m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        PseudoReductionEntry<BigInteger> mf = pred.normalformFactor(L, a);
        GenPolynomial<Object> e = mf.pol;
        GenPolynomial<BigInteger> f = a.multiply((BigInteger)mf.multiplicator);
        e = pred.normalform(row, L, f);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)e.isZERO());
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)pred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)pred.isReductionNF(row, L, f, e));
        L.add(b);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        mf = pred.normalformFactor(L, a);
        e = mf.pol;
        f = a.multiply((BigInteger)mf.multiplicator);
        e = pred.normalform(row, L, f);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)pred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)pred.isReductionNF(row, L, f, e));
        L.add(c);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        mf = pred.normalformFactor(L, a);
        e = mf.pol;
        f = a.multiply((BigInteger)mf.multiplicator);
        e = pred.normalform(row, L, f);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)pred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)pred.isReductionNF(row, L, f, e));
        L.add(d);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        mf = pred.normalformFactor(L, a);
        e = mf.pol;
        f = a.multiply((BigInteger)mf.multiplicator);
        e = pred.normalform(row, L, f);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)pred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)pred.isReductionNF(row, L, f, e));
    }

    public void testIntegerRReduction() {
        BigInteger bi = new BigInteger(0L);
        ProductRing<BigInteger> pr = new ProductRing<BigInteger>(bi, 3);
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(pr, this.rl);
        RPseudoReductionSeq<BigInteger> rpred = new RPseudoReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<RingElem<BigInteger>> b = fac.random(this.kl, this.ll, this.el, this.q);
        while (a.isZERO()) {
            a = fac.random(this.kl, this.ll, this.el, this.q);
        }
        while (b.isZERO()) {
            b = fac.random(this.kl, this.ll, this.el, this.q);
        }
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ArrayList L = new ArrayList();
        L.add(a);
        GenPolynomial<RingElem<BigInteger>> e = ((RReductionSeq)rpred).normalform(L, a);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rpred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        L.add(b);
        e = ((RReductionSeq)rpred).normalform(L, a);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rpred.isNormalform(L, e));
        GenPolynomial<BigInteger> c = fac.getONE();
        a = a.sum((BigInteger)((Object)c));
        e = ((RReductionSeq)rpred).normalform(L, a);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rpred.isNormalform(L, e));
        L = new ArrayList();
        L.add(a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)rpred.isTopReducible(L, a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)rpred.isReducible(L, a));
        L.add(b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)rpred.isTopReducible(L, b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)rpred.isReducible(L, b));
        c = fac.random(this.kl, this.ll, this.el, this.q);
        e = ((RReductionSeq)rpred).normalform(L, c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rpred.isNormalform(L, e));
        c = rpred.booleanClosure(a);
        ReductionTest.assertTrue((String)"isBC( c )", (boolean)rpred.isBooleanClosed(c));
        b = a.subtract((BigInteger)((Object)c));
        GenPolynomial<BigInteger> d = rpred.booleanRemainder(a);
        ReductionTest.assertEquals((String)"a-BC(a)=BR(a)", b, d);
        e = c.sum((BigInteger)((Object)d));
        ReductionTest.assertEquals((String)"a==BC(a)+BR(a)", a, e);
        L = new ArrayList();
        L.add(a);
        List B = rpred.booleanClosure(L);
        List Br = rpred.reducedBooleanClosure(L);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rpred.isBooleanClosed(B));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rpred.isReducedBooleanClosed(Br));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rpred.isBooleanClosed(Br));
        L.add(b);
        B = rpred.booleanClosure(L);
        Br = rpred.reducedBooleanClosure(L);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rpred.isBooleanClosed(B));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rpred.isReducedBooleanClosed(Br));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rpred.isBooleanClosed(Br));
        L.add(c);
        B = rpred.booleanClosure(L);
        Br = rpred.reducedBooleanClosure(L);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rpred.isBooleanClosed(B));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rpred.isReducedBooleanClosed(Br));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rpred.isBooleanClosed(Br));
        while (d.isZERO()) {
            d = fac.random(this.kl, this.ll, this.el, this.q);
        }
        L.add(d);
        B = rpred.booleanClosure(L);
        Br = rpred.reducedBooleanClosure(L);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rpred.isBooleanClosed(B));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rpred.isReducedBooleanClosed(Br));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rpred.isBooleanClosed(Br));
    }

    public void testIntRReductionRecording() {
        BigInteger bi = new BigInteger(0L);
        ProductRing<BigInteger> pr = new ProductRing<BigInteger>(bi, 3);
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(pr, this.rl);
        RPseudoReductionSeq<BigInteger> rpred = new RPseudoReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> a = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> b = fac.random(this.kl, this.ll, this.el, this.q);
        while (a.isZERO()) {
            a = fac.random(this.kl, this.ll, this.el, this.q);
        }
        while (b.isZERO()) {
            b = fac.random(this.kl, this.ll, this.el, this.q);
        }
        ReductionTest.assertTrue((String)"not isZERO( a )", (!a.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"not isZERO( b )", (!b.isZERO() ? 1 : 0) != 0);
        GenPolynomial<BigInteger> c = fac.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> d = fac.random(this.kl, this.ll, this.el, this.q);
        ArrayList row = null;
        ArrayList L = new ArrayList();
        L.add(a);
        row = new ArrayList(L.size());
        int m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        PseudoReductionEntry<BigInteger> mf = rpred.normalformFactor(L, a);
        GenPolynomial<Object> e = mf.pol;
        GenPolynomial<BigInteger> f = a.multiply((BigInteger)((Object)((Product)mf.multiplicator)));
        e = rpred.normalform(row, L, f);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rpred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)rpred.isReductionNF(row, L, f, e));
        L.add(b);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        mf = rpred.normalformFactor(L, a);
        e = mf.pol;
        f = a.multiply((BigInteger)((Object)((Product)mf.multiplicator)));
        e = rpred.normalform(row, L, f);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rpred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)rpred.isReductionNF(row, L, f, e));
        L.add(c);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        mf = rpred.normalformFactor(L, a);
        e = mf.pol;
        f = a.multiply((BigInteger)((Object)((Product)mf.multiplicator)));
        e = rpred.normalform(row, L, f);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rpred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)rpred.isReductionNF(row, L, f, e));
        L.add(d);
        row = new ArrayList(L.size());
        m = 0;
        while (m < L.size()) {
            row.add(null);
            ++m;
        }
        mf = rpred.normalformFactor(L, a);
        e = mf.pol;
        f = a.multiply((BigInteger)((Object)((Product)mf.multiplicator)));
        e = rpred.normalform(row, L, f);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rpred.isNormalform(L, e));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)rpred.isReductionNF(row, L, f, e));
    }
}

