/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBDist;
import edu.jas.gb.GBDistHybrid;
import edu.jas.gb.GBDistSP;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.GroebnerBaseSeqPairParallel;
import edu.jas.gb.GroebnerBaseSeqPairSeq;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.util.ExecutableServer;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class RunGB {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        String usage = "Usage: RunGB [ seq | seq+ | par | par+ | dist | dist1 | dist+ | dist1+ | disthyb1 | cli [port] ] <file> #procs/#threadsPerNode [machinefile]";
        if (args.length < 1) {
            System.out.println(usage);
            return;
        }
        boolean pairseq = false;
        String kind = args[0];
        String[] allkinds = new String[]{"seq", "seq+", "par", "par+", "dist", "dist1", "dist+", "dist1+", "disthyb1", "cli"};
        boolean sup = false;
        int i = 0;
        while (i < allkinds.length) {
            if (kind.equals(allkinds[i])) {
                sup = true;
                if (kind.indexOf("+") >= 0) {
                    pairseq = true;
                }
            }
            ++i;
        }
        if (!sup) {
            System.out.println(usage);
            return;
        }
        boolean once = false;
        int GB_SERVER_PORT = 7114;
        int port = 7114;
        if (kind.equals("cli")) {
            if (args.length >= 2) {
                try {
                    port = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    System.out.println(usage);
                    return;
                }
            }
            RunGB.runClient(port);
            return;
        }
        String filename = null;
        if (!kind.equals("cli")) {
            if (args.length < 2) {
                System.out.println(usage);
                return;
            }
            filename = args[1];
        }
        int threads = 0;
        int threadsPerNode = 1;
        if (kind.startsWith("par") || kind.startsWith("dist")) {
            String tup;
            if (args.length < 3) {
                System.out.println(usage);
                return;
            }
            String t = tup = args[2];
            int i2 = tup.indexOf("/");
            if (i2 >= 0) {
                t = tup.substring(0, i2).trim();
                tup = tup.substring(i2 + 1).trim();
                try {
                    threadsPerNode = Integer.parseInt(tup);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    System.out.println(usage);
                    return;
                }
            }
            try {
                threads = Integer.parseInt(t);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println(usage);
                return;
            }
        }
        String mfile = null;
        if (kind.startsWith("dist")) {
            mfile = args.length >= 4 ? args[3] : "machines";
        }
        FileReader problem = null;
        try {
            problem = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println(usage);
            return;
        }
        GenPolynomialTokenizer tok = new GenPolynomialTokenizer(problem);
        PolynomialList S = null;
        try {
            S = tok.nextPolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("S =\n" + S);
        if (kind.startsWith("seq")) {
            RunGB.runSequential(S, pairseq);
        }
        if (kind.startsWith("par")) {
            RunGB.runParallel(S, threads, pairseq);
        }
        if (kind.startsWith("dist1")) {
            RunGB.runMasterOnce(S, threads, mfile, port, pairseq);
        } else if (kind.startsWith("disthyb1")) {
            RunGB.runMasterOnceHyb(S, threads, threadsPerNode, mfile, port, pairseq);
        } else if (kind.startsWith("dist")) {
            RunGB.runMaster(S, threads, mfile, port, pairseq);
        }
        System.exit(0);
    }

    static void runMaster(PolynomialList S, int threads, String mfile, int port, boolean pairseq) {
        List L = S.list;
        List G = null;
        long t = System.currentTimeMillis();
        System.out.println("\nGroebner base distributed (" + threads + ", " + mfile + ", " + port + ") ...");
        GBDist gbd = null;
        GBDistSP gbds = null;
        if (pairseq) {
            gbds = new GBDistSP(threads, mfile, port);
        } else {
            gbd = new GBDist(threads, mfile, port);
        }
        long t1 = System.currentTimeMillis();
        G = pairseq ? gbds.execute(L) : gbd.execute(L);
        t1 = System.currentTimeMillis() - t1;
        if (pairseq) {
            gbds.terminate(false);
        } else {
            gbd.terminate(false);
        }
        S = new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (pairseq) {
            System.out.print("d+ ");
        } else {
            System.out.print("d ");
        }
        System.out.println("= " + threads + ", time = " + t + " milliseconds, " + (t - t1) + " start-up");
        System.out.println("");
    }

    static void runMasterOnce(PolynomialList S, int threads, String mfile, int port, boolean pairseq) {
        List L = S.list;
        List G = null;
        long t = System.currentTimeMillis();
        System.out.println("\nGroebner base distributed[once] (" + threads + ", " + mfile + ", " + port + ") ...");
        GBDist gbd = null;
        GBDistSP gbds = null;
        if (pairseq) {
            gbds = new GBDistSP(threads, mfile, port);
        } else {
            gbd = new GBDist(threads, mfile, port);
        }
        long t1 = System.currentTimeMillis();
        G = pairseq ? gbds.execute(L) : gbd.execute(L);
        t1 = System.currentTimeMillis() - t1;
        if (pairseq) {
            gbds.terminate(true);
        } else {
            gbd.terminate(true);
        }
        S = new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (pairseq) {
            System.out.print("d+ ");
        } else {
            System.out.print("d ");
        }
        System.out.println("= " + threads + ", time = " + t + " milliseconds, " + (t - t1) + " start-up");
        System.out.println("");
    }

    static void runMasterOnceHyb(PolynomialList S, int threads, int threadsPerNode, String mfile, int port, boolean pairseq) {
        List L = S.list;
        List G = null;
        long t = System.currentTimeMillis();
        System.out.println("\nGroebner base distributed hybrid[once] (" + threads + "/" + threadsPerNode + ", " + mfile + ", " + port + ") ...");
        GBDistHybrid gbd = null;
        if (pairseq) {
            System.out.println("... not implemented.");
            return;
        }
        gbd = new GBDistHybrid(threads, threadsPerNode, mfile, port);
        long t1 = System.currentTimeMillis();
        if (!pairseq) {
            G = gbd.execute(L);
        }
        t1 = System.currentTimeMillis() - t1;
        if (!pairseq) {
            gbd.terminate(false);
        }
        S = new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (pairseq) {
            System.out.print("d+ ");
        } else {
            System.out.print("d ");
        }
        System.out.println("= " + threads + ", ppn = " + threadsPerNode + ", time = " + t + " milliseconds, " + (t - t1) + " start-up");
        System.out.println("");
    }

    static void runClient(int port) {
        System.out.println("\nGroebner base distributed client (" + port + ") ...");
        ExecutableServer es = new ExecutableServer(port);
        es.init();
    }

    static void runParallel(PolynomialList S, int threads, boolean pairseq) {
        List L = S.list;
        GroebnerBaseParallel bb = null;
        GroebnerBaseSeqPairParallel bbs = null;
        if (pairseq) {
            bbs = new GroebnerBaseSeqPairParallel(threads);
        } else {
            bb = new GroebnerBaseParallel(threads);
        }
        long t = System.currentTimeMillis();
        System.out.println("\nGroebner base parallel (" + threads + ") ...");
        List G = pairseq ? bbs.GB(L) : bb.GB(L);
        S = new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (pairseq) {
            System.out.print("p+ ");
        } else {
            System.out.print("p ");
        }
        System.out.println("= " + threads + ", time = " + t + " milliseconds");
        System.out.println("");
        if (pairseq) {
            bbs.terminate();
        } else {
            bb.terminate();
        }
    }

    static void runSequential(PolynomialList S, boolean pairseq) {
        List L = S.list;
        GroebnerBaseAbstract bb = null;
        bb = pairseq ? new GroebnerBaseSeqPairSeq() : new GroebnerBaseSeq();
        long t = System.currentTimeMillis();
        System.out.println("\nGroebner base sequential ...");
        List G = bb.GB(L);
        S = new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (pairseq) {
            System.out.print("seq+, ");
        } else {
            System.out.print("seq, ");
        }
        System.out.println("time = " + t + " milliseconds");
        System.out.println("");
    }
}

