/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.SolvableGroebnerBaseParallel;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableGroebnerBaseSeqPairParallel;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class RunSGB {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        String usage = "Usage: RunSGB [ seq | par | par+ ] [ irr | left | right | two ] <file> #procs ";
        if (args.length < 3) {
            System.out.println(usage);
            return;
        }
        boolean pairseq = false;
        String kind = args[0];
        String[] allkinds = new String[]{"seq", "par", "par+"};
        boolean sup = false;
        int i = 0;
        while (i < allkinds.length) {
            if (kind.equals(allkinds[i])) {
                sup = true;
                if (kind.indexOf("+") >= 0) {
                    pairseq = true;
                }
            }
            ++i;
        }
        if (!sup) {
            System.out.println(usage);
            return;
        }
        String[] allmeth = new String[]{"irr", "left", "right", "two"};
        String action = args[1];
        sup = false;
        int i2 = 0;
        while (i2 < allmeth.length) {
            if (action.equals(allmeth[i2])) {
                sup = true;
            }
            ++i2;
        }
        if (!sup) {
            System.out.println(usage);
            return;
        }
        String filename = args[2];
        int threads = 0;
        if (kind.startsWith("par")) {
            String tup;
            if (args.length < 4) {
                System.out.println(usage);
                return;
            }
            String t = tup = args[3];
            try {
                threads = Integer.parseInt(t);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println(usage);
                return;
            }
            if (threads < 1) {
                threads = 1;
            }
        }
        FileReader problem = null;
        try {
            problem = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println(usage);
            return;
        }
        GenPolynomialTokenizer tok = new GenPolynomialTokenizer(problem);
        PolynomialList S = null;
        try {
            S = tok.nextSolvablePolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("S =\n" + S);
        if (kind.startsWith("seq")) {
            RunSGB.runSequential(S, action, pairseq);
        }
        if (kind.startsWith("par")) {
            RunSGB.runParallel(S, threads, action, pairseq);
        }
    }

    static void runSequential(PolynomialList S, String action, boolean pairseq) {
        List L = S.list;
        List G = null;
        SolvableReductionSeq sred = new SolvableReductionSeq();
        SolvableGroebnerBaseSeq sbb = null;
        if (pairseq) {
            System.out.println("SolvableGroebnerBaseSeqPairSeq not implemented using SolvableGroebnerBaseSeq");
            sbb = new SolvableGroebnerBaseSeq();
        } else {
            sbb = new SolvableGroebnerBaseSeq();
        }
        long t = System.currentTimeMillis();
        System.out.println("\nSolvable GB [" + action + "] sequential ...");
        if (action.equals("irr")) {
            G = sred.leftIrreducibleSet(L);
        }
        if (action.equals("left")) {
            G = sbb.leftGB(L);
        }
        if (action.equals("right")) {
            G = sbb.rightGB(L);
        }
        if (action.equals("two")) {
            G = sbb.twosidedGB(L);
        }
        if (G == null) {
            System.out.println("unknown action = " + action + "\n");
            return;
        }
        S = new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (pairseq) {
            System.out.print("seq+, ");
        } else {
            System.out.print("seq, ");
        }
        System.out.println("time = " + t + " milliseconds");
        System.out.println("");
    }

    static void runParallel(PolynomialList S, int threads, String action, boolean pairseq) {
        List L = S.list;
        List G = null;
        SolvableReductionPar sred = new SolvableReductionPar();
        SolvableGroebnerBaseParallel sbb = null;
        SolvableGroebnerBaseSeqPairParallel sbbs = null;
        if (pairseq) {
            sbbs = new SolvableGroebnerBaseSeqPairParallel(threads);
        } else {
            sbb = new SolvableGroebnerBaseParallel(threads);
        }
        long t = System.currentTimeMillis();
        System.out.println("\nSolvable GB [" + action + "] parallel " + threads + " threads ...");
        if (action.equals("irr")) {
            G = sred.leftIrreducibleSet(L);
        }
        if (action.equals("left")) {
            G = pairseq ? sbbs.leftGB(L) : sbb.leftGB(L);
        }
        if (action.equals("right")) {
            G = pairseq ? sbbs.rightGB(L) : sbb.rightGB(L);
        }
        if (action.equals("two")) {
            G = pairseq ? sbbs.twosidedGB(L) : sbb.twosidedGB(L);
        }
        if (G == null) {
            System.out.println("unknown action = " + action + "\n");
            return;
        }
        S = G.size() > 0 ? new PolynomialList(G.get((int)0).ring, G) : new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (pairseq) {
            System.out.print("p+ ");
        } else {
            System.out.print("p ");
        }
        System.out.println("= " + threads + ", time = " + t + " milliseconds");
        System.out.println("");
        if (pairseq) {
            sbbs.terminate();
        } else {
            sbb.terminate();
        }
    }
}

