/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public abstract class SolvableGroebnerBaseAbstract<C extends RingElem<C>>
implements SolvableGroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(SolvableGroebnerBaseAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    protected SolvableReduction<C> sred;
    protected Reduction<C> red;

    public SolvableGroebnerBaseAbstract() {
        this(new ReductionSeq(), new SolvableReductionSeq());
    }

    public SolvableGroebnerBaseAbstract(Reduction<C> red, SolvableReduction<C> sred) {
        this.red = red;
        this.sred = sred;
    }

    @Override
    public boolean isLeftGB(List<GenSolvablePolynomial<C>> F2) {
        return this.isLeftGB(0, F2);
    }

    @Override
    public boolean isLeftGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        int i = 0;
        while (i < F2.size()) {
            GenSolvablePolynomial<C> pi = F2.get(i);
            int j = i + 1;
            while (j < F2.size()) {
                GenSolvablePolynomial<C> h;
                GenSolvablePolynomial<C> s;
                GenSolvablePolynomial<C> pj = F2.get(j);
                if (this.red.moduleCriterion(modv, pi, pj) && !(s = this.sred.leftSPolynomial(pi, pj)).isZERO() && !(h = this.sred.leftNormalform(F2, s)).isZERO()) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isTwosidedGB(List<GenSolvablePolynomial<C>> Fp) {
        return this.isTwosidedGB(0, Fp);
    }

    @Override
    public boolean isTwosidedGB(int modv, List<GenSolvablePolynomial<C>> Fp) {
        int j;
        if (Fp == null || Fp.size() == 0) {
            return true;
        }
        GenSolvablePolynomialRing fac = Fp.get((int)0).ring;
        List X = fac.univariateList(modv);
        ArrayList F2 = new ArrayList(Fp.size() * (1 + X.size()));
        F2.addAll(Fp);
        int i = 0;
        while (i < Fp.size()) {
            GenSolvablePolynomial p = Fp.get(i);
            j = 0;
            while (j < X.size()) {
                GenSolvablePolynomial x = X.get(j);
                p = p.multiply(x);
                F2.add(p);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < F2.size()) {
            GenSolvablePolynomial pi = (GenSolvablePolynomial)F2.get(i);
            j = i + 1;
            while (j < F2.size()) {
                GenSolvablePolynomial<C> h;
                GenSolvablePolynomial<C> s;
                GenSolvablePolynomial pj = (GenSolvablePolynomial)F2.get(j);
                if (this.red.moduleCriterion(modv, pi, pj) && !(s = this.sred.leftSPolynomial(pi, pj)).isZERO() && !(h = this.sred.leftNormalform(F2, s)).isZERO()) {
                    logger.info((Object)("is not TwosidedGB: " + h));
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isRightGB(List<GenSolvablePolynomial<C>> F2) {
        return this.isRightGB(0, F2);
    }

    @Override
    public boolean isRightGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        int i = 0;
        while (i < F2.size()) {
            GenSolvablePolynomial<C> pi = F2.get(i);
            int j = i + 1;
            while (j < F2.size()) {
                GenSolvablePolynomial<C> h;
                GenSolvablePolynomial<C> s;
                GenSolvablePolynomial<C> pj = F2.get(j);
                if (this.red.moduleCriterion(modv, pi, pj) && !(s = this.sred.rightSPolynomial(pi, pj)).isZERO() && !(h = this.sred.rightNormalform(F2, s)).isZERO()) {
                    logger.info((Object)("isRightGB non zero h = " + h));
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(List<GenSolvablePolynomial<C>> F2) {
        return this.leftGB(0, F2);
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(List<GenSolvablePolynomial<C>> F2) {
        return this.extLeftGB(0, F2);
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> Gp) {
        GenSolvablePolynomial<C> a;
        ArrayList<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>();
        ListIterator<GenSolvablePolynomial<C>> it = Gp.listIterator();
        for (GenSolvablePolynomial<C> a2 : Gp) {
            if (a2.length() == 0) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenSolvablePolynomial<C>> F2 = new ArrayList<GenSolvablePolynomial<C>>();
        while (G.size() > 0) {
            ExpVector f;
            GenSolvablePolynomial<C> p;
            a = G.remove(0);
            ExpVector e = a.leadingExpVector();
            it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F2.listIterator();
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (mt) continue;
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        F2 = new ArrayList();
        while (G.size() > 0) {
            a = G.remove(0);
            a = this.sred.leftNormalform(G, a);
            a = this.sred.leftNormalform(F2, a);
            F2.add(a);
        }
        return F2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(List<GenSolvablePolynomial<C>> Fp) {
        return this.twosidedGB(0, Fp);
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(List<GenSolvablePolynomial<C>> F2) {
        return this.rightGB(0, F2);
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        GenSolvablePolynomial q;
        GenPolynomialRing ring = null;
        for (GenSolvablePolynomial<C> p : F2) {
            if (p == null) continue;
            ring = p.ring;
            break;
        }
        if (ring == null) {
            return F2;
        }
        GenPolynomialRing rring = ring.reverse(true);
        ArrayList rF = new ArrayList(F2.size());
        for (GenSolvablePolynomial<C> p : F2) {
            if (p == null) continue;
            q = (GenSolvablePolynomial)p.reverse(rring);
            rF.add(q);
        }
        PolynomialList pl = new PolynomialList(rring, rF);
        logger.info((Object)("reversed problem = " + pl));
        List rG = this.leftGB(modv, rF);
        long t = System.currentTimeMillis();
        boolean isit = this.isLeftGB(rG);
        t = System.currentTimeMillis() - t;
        logger.info((Object)("is left GB = " + isit + ", in " + t + " milliseconds"));
        ring = ((GenSolvablePolynomialRing)rring).reverse(true);
        ArrayList<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>(rG.size());
        for (GenSolvablePolynomial p : rG) {
            if (p == null) continue;
            q = (GenSolvablePolynomial)p.reverse(ring);
            G.add(q);
        }
        long t2 = System.currentTimeMillis();
        boolean isit2 = this.isRightGB(G);
        t2 = System.currentTimeMillis() - t2;
        logger.info((Object)("is right GB = " + isit2 + ", in " + t2 + " milliseconds"));
        return G;
    }

    @Override
    public boolean isLeftReductionMatrix(SolvableExtendedGB<C> exgb) {
        if (exgb == null) {
            return true;
        }
        return this.isLeftReductionMatrix(exgb.F, exgb.G, exgb.F2G, exgb.G2F);
    }

    @Override
    public boolean isLeftReductionMatrix(List<GenSolvablePolynomial<C>> F2, List<GenSolvablePolynomial<C>> G, List<List<GenSolvablePolynomial<C>>> Mf, List<List<GenSolvablePolynomial<C>>> Mg) {
        boolean t;
        int k = 0;
        for (List<GenSolvablePolynomial<C>> row : Mg) {
            t = this.sred.isLeftReductionNF(row, F2, G.get(k), null);
            if (!t) {
                logger.error((Object)("F isLeftReductionMatrix s, k = " + F2.size() + ", " + k));
                return false;
            }
            ++k;
        }
        k = 0;
        for (List<GenSolvablePolynomial<C>> row : Mf) {
            t = this.sred.isLeftReductionNF(row, G, F2.get(k), null);
            if (!t) {
                logger.error((Object)("G isLeftReductionMatrix s, k = " + G.size() + ", " + k));
                return false;
            }
            ++k;
        }
        return true;
    }
}

